/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.userchat_list;

import android.support.annotation.Nullable;
import android.support.v7.util.SortedList;
import android.support.v7.widget.RecyclerView;
import android.view.ViewGroup;
import com.zoyi.channel.plugin.android.activity.base.SortedListCallback;
import com.zoyi.channel.plugin.android.activity.userchat_list.contract.UserChatAdapterContract;
import com.zoyi.channel.plugin.android.activity.userchat_list.holder.UserChatHolder;
import com.zoyi.channel.plugin.android.activity.userchat_list.listener.OnUserChatClickListener;
import com.zoyi.channel.plugin.android.activity.userchat_list.model.UserChatItem;
import com.zoyi.channel.plugin.android.model.rest.Session;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatsWrapper;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import java.util.HashMap;
import java.util.Map;

class UserChatListAdapter
extends RecyclerView.Adapter<UserChatHolder>
implements UserChatAdapterContract.View,
UserChatAdapterContract.Model {
    @Nullable
    private OnUserChatClickListener listener;
    private Map<String, UserChatItem> map = new HashMap<String, UserChatItem>();
    private SortedList<UserChatItem> items = new SortedList(UserChatItem.class, new SortedListCallback(this, true));

    UserChatListAdapter() {
    }

    @Override
    public void setOnUserChatClickListener(OnUserChatClickListener clickListener) {
        this.listener = clickListener;
    }

    @Override
    public void init(UserChatsWrapper repo) {
        this.clear();
        this.items.beginBatchedUpdates();
        for (UserChat userChat : repo.getUserChats()) {
            if (!this.canUpsert(userChat)) continue;
            UserChatItem item = new UserChatItem(userChat);
            this.map.put(item.getId(), item);
            this.items.add((Object)item);
        }
        this.items.endBatchedUpdates();
    }

    public void clear() {
        if (this.map != null) {
            this.map.clear();
        }
        if (this.items != null) {
            this.items.clear();
        }
    }

    private void updateItem(UserChatItem item) {
        int position = this.items.indexOf((Object)item);
        if (position >= 0) {
            this.items.updateItemAt(position, (Object)item);
        }
    }

    @Override
    public void upsertUserChat(UserChat userChat) {
        if (userChat != null && this.canUpsert(userChat)) {
            String chatId = userChat.getId();
            if (this.map.containsKey(chatId)) {
                UserChatItem item = this.map.get(chatId);
                item.setUserChat(userChat);
                this.updateItem(item);
            } else {
                UserChatItem item = new UserChatItem(userChat);
                this.map.put(item.getId(), item);
                this.items.add((Object)item);
            }
        }
    }

    @Override
    public void removeUserChat(UserChat userChat) {
        if (userChat != null) {
            this.removeUserChat(userChat.getId());
        }
    }

    @Override
    public void removeUserChat(String chatId) {
        if (this.map.containsKey(chatId)) {
            this.items.remove((Object)this.map.get(chatId));
            this.map.remove(chatId);
        }
    }

    public UserChatHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return UserChatHolder.newInstance(parent, this.listener);
    }

    public void onBindViewHolder(UserChatHolder holder, int position) {
        holder.setUserChatItem((UserChatItem)this.items.get(position));
    }

    public int getItemCount() {
        return this.items.size();
    }

    @Nullable
    public String getChatId(int position) {
        if (this.items.size() <= position) {
            return null;
        }
        return ((UserChatItem)this.items.get(position)).getId();
    }

    @Override
    public void updateManager(String managerId) {
        for (int i = 0; i < this.items.size(); ++i) {
            UserChatItem item = (UserChatItem)this.items.get(i);
            if (!CompareUtils.isSame(item.getHostType(), "Manager") || !CompareUtils.isSame(item.getHostId(), managerId)) continue;
            this.items.updateItemAt(i, (Object)item);
        }
    }

    @Override
    public void updateSession(Session session) {
        if (session != null) {
            for (int i = 0; i < this.items.size(); ++i) {
                UserChatItem item = (UserChatItem)this.items.get(i);
                if (!CompareUtils.isSame(item.getId(), session.getId())) continue;
                this.items.updateItemAt(i, (Object)item);
                break;
            }
        }
    }

    private boolean canUpsert(@Nullable UserChat userChat) {
        return userChat != null && (!userChat.isStateReady() || userChat.getLastMessageId() != null);
    }
}

