/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.AnimRes;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentManager;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageButton;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.activity.chat.ChatAdapter;
import com.zoyi.channel.plugin.android.activity.chat.ChatContract;
import com.zoyi.channel.plugin.android.activity.chat.ChatPresenter;
import com.zoyi.channel.plugin.android.activity.chat.PreviewFragment;
import com.zoyi.channel.plugin.android.activity.chat.TopNavFragment;
import com.zoyi.channel.plugin.android.activity.chat.TypingManager;
import com.zoyi.channel.plugin.android.activity.chat.model.SendingMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.utils.ChatResponseManager;
import com.zoyi.channel.plugin.android.activity.download.DownloadActivity;
import com.zoyi.channel.plugin.android.activity.photo_album.PhotoAlbumActivity;
import com.zoyi.channel.plugin.android.activity.photo_album.PhotoAlbumStorage;
import com.zoyi.channel.plugin.android.activity.photo_picker.PhotoPickerActivity;
import com.zoyi.channel.plugin.android.activity.settings.SettingsActivity;
import com.zoyi.channel.plugin.android.activity.video.VideoViewerActivity;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.enumerate.StoreType;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.enumerate.UpdateType;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.entity.Entity;
import com.zoyi.channel.plugin.android.model.entity.Person;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.etc.Typing;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.selector.ChannelSelector;
import com.zoyi.channel.plugin.android.selector.ColorSelector;
import com.zoyi.channel.plugin.android.selector.CounterSelector;
import com.zoyi.channel.plugin.android.selector.ManagerSelector;
import com.zoyi.channel.plugin.android.selector.PluginSelector;
import com.zoyi.channel.plugin.android.selector.ProfileSelector;
import com.zoyi.channel.plugin.android.selector.UserChatSelector;
import com.zoyi.channel.plugin.android.socket.SocketManager;
import com.zoyi.channel.plugin.android.store.Store;
import com.zoyi.channel.plugin.android.store.TranslationStore;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.Executor;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.util.message_format.type.LinkType;
import com.zoyi.channel.plugin.android.view.handler.BackgroundToucher;
import com.zoyi.channel.plugin.android.view.handler.EditTextChangedListener;
import com.zoyi.channel.plugin.android.view.handler.InfiniteScrollListener;
import com.zoyi.channel.plugin.android.view.layout.BigBar;
import com.zoyi.channel.plugin.android.view.layout.BottomFloatingActionLayout;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;
import com.zoyi.channel.plugin.android.view.layout.ChatRecyclerView;
import com.zoyi.channel.plugin.android.view.layout.MenuButton;
import com.zoyi.channel.plugin.android.view.layout.NewChatButton;
import com.zoyi.channel.plugin.android.view.layout.WatchedEditText;
import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.functions.Action1;
import java.util.concurrent.TimeUnit;

public class ChatActivity
extends BaseActivity
implements ChatContract.View,
EditTextChangedListener,
View.OnClickListener,
TopNavFragment.OnChatTopNavListener {
    private static final int DELAY_EXPAND_COLLAPSE = 512;
    private TopNavFragment topNavFragment;
    private ChatRecyclerView chatList;
    private WatchedEditText editChat;
    private ImageButton imageSend;
    private View layoutInput;
    private PreviewFragment previewFragment;
    private CHTextView disabledInputText;
    private BottomFloatingActionLayout bottomFloatingActionLayout;
    private NewChatButton newChatButton;
    @Nullable
    private BigBar bigBar;
    private LinearLayoutManager layoutManager;
    private TypingManager typingManager;
    private ChatContract.Presenter presenter;
    private ChatAdapter adapter;
    @Nullable
    private Subscription countSubscription;
    private int enterAnimInCreate;
    private int existAnimInFinish;
    private boolean exit = false;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.init(R.layout.ch_plugin_activity_chat);
        String chatId = null;
        if (this.getIntent() != null) {
            chatId = this.getIntent().getStringExtra("chatId");
        }
        this.bigBar = this.getBigBar();
        this.initBigBar();
        FragmentManager fm = this.getSupportFragmentManager();
        this.presenter = new ChatPresenter((Context)this);
        this.adapter = new ChatAdapter(TextUtils.isEmpty((CharSequence)chatId));
        this.presenter.setView(this);
        this.presenter.setAdapterModel(this.adapter);
        this.presenter.setAdapterView(this.adapter);
        this.presenter.setChatId(chatId);
        this.topNavFragment = (TopNavFragment)fm.findFragmentById(R.id.f_chat_top_nav);
        this.previewFragment = (PreviewFragment)fm.findFragmentById(R.id.f_chat_preview);
        this.chatList = (ChatRecyclerView)this.findViewById(R.id.recycler_chat);
        this.imageSend = (ImageButton)this.findViewById(R.id.iv_chat_send);
        this.disabledInputText = (CHTextView)this.findViewById(R.id.text_disabled_input);
        this.editChat = (WatchedEditText)this.findViewById(R.id.edit_chat);
        this.layoutInput = this.findViewById(R.id.layout_input);
        this.newChatButton = (NewChatButton)this.findViewById(R.id.ch_button_new_chat);
        this.bottomFloatingActionLayout = (BottomFloatingActionLayout)this.findViewById(R.id.ch_layout_bottom_floating_action);
        this.typingManager = new TypingManager(chatId, "UserChat", this.editChat);
        this.topNavFragment.setOnChatTopNavListener(this);
        this.layoutManager = new LinearLayoutManager((Context)this);
        this.layoutManager.setStackFromEnd(true);
        this.chatList.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.chatList.setAdapter(this.adapter);
        this.chatList.setItemAnimator(null);
        this.chatList.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

            public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                if (bottom < oldBottom) {
                    ChatActivity.this.collapseTopNav(true);
                }
            }
        });
        this.chatList.setTopNavFragment(this.topNavFragment);
        this.chatList.addOnScrollListener(new InfiniteScrollListener(this.layoutManager, 1, this.chatList){

            @Override
            public void scrolledInList() {
                ChatActivity.this.bottomFloatingActionLayout.hide();
            }

            @Override
            public void scrollAttachedToBottom() {
                ChatActivity.this.previewFragment.hide();
                ChatActivity.this.bottomFloatingActionLayout.show();
            }

            @Override
            public void refresh() {
                ChatActivity.this.presenter.fetchBackwardMessages();
            }
        });
        this.bottomFloatingActionLayout.setRecyclerView(this.chatList);
        this.findViewById(R.id.button_attach).setOnClickListener((View.OnClickListener)this);
        this.imageSend.setOnClickListener((View.OnClickListener)this);
        this.editChat.setWatchedTextChangedListener(this);
        this.editChat.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                ChatActivity.this.adapter.setChatEditTextFocus(hasFocus);
            }
        });
        this.editChat.setText(PrefSupervisor.getStoredMessage((Context)this));
        PrefSupervisor.clearStoredMessage((Context)this);
        this.newChatButton.setClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChatActivity.this.setResult(22);
                ChatActivity.this.finish();
            }
        });
        this.setDisabledInputBoxView(false);
        BackgroundToucher.makeKeyboardEvent(this, this.chatList, (EditText)this.editChat);
        this.setBigbarStyle();
        this.presenter.init(chatId);
        if (SocketManager.isError()) {
            this.setReconnectVisibility(true);
        }
    }

    @Override
    protected void onDestroy() {
        if (this.countSubscription != null && !this.countSubscription.isUnsubscribed()) {
            this.countSubscription.unsubscribe();
        }
        Store.getInstance(TranslationStore.class).clearData();
        super.onDestroy();
    }

    @Override
    public void finish() {
        if (this.presenter != null && this.presenter.getChatId() != null) {
            this.presenter.leaveChat();
        }
        super.finish();
    }

    private void initBigBar() {
        if (this.bigBar != null) {
            this.bigBar.withActivity(this).addMenu(MenuButton.ActionType.SETTINGS, BigBar.MenuPosition.LEFT, MenuButton.MenuState.HIDDEN).addMenu(MenuButton.ActionType.BACK, BigBar.MenuPosition.LEFT, MenuButton.MenuState.HIDDEN).addText(BigBar.MenuPosition.LEFT).addMenu(MenuButton.ActionType.REFRESH, BigBar.MenuPosition.RIGHT, MenuButton.MenuState.HIDDEN).addMenu(MenuButton.ActionType.EXIT, BigBar.MenuPosition.RIGHT).build();
        }
        this.refreshChatCount(true);
        this.refreshMenuButton();
    }

    private void refreshChatCount(boolean force) {
        if (force) {
            if (this.bigBar != null) {
                this.bigBar.setText(CounterSelector.getTotalCounter());
            }
        } else {
            if (this.countSubscription != null && !this.countSubscription.isUnsubscribed()) {
                this.countSubscription.unsubscribe();
            }
            this.countSubscription = Observable.timer((long)600L, (TimeUnit)TimeUnit.MILLISECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe((Action1)new Action1<Long>(){

                public void call(Long aLong) {
                    if (ChatActivity.this.bigBar != null) {
                        ChatActivity.this.bigBar.setText(CounterSelector.getTotalCounter());
                    }
                }
            });
        }
    }

    private void refreshMenuButton() {
        if (this.bigBar != null) {
            if (UserChatSelector.getUserChatCount() > 0 || this.presenter != null && this.presenter.getUserChat() != null) {
                this.bigBar.setMenuState(MenuButton.ActionType.BACK, MenuButton.MenuState.VISIBLE);
                this.bigBar.setMenuState(MenuButton.ActionType.SETTINGS, MenuButton.MenuState.HIDDEN);
            } else {
                this.bigBar.setMenuState(MenuButton.ActionType.BACK, MenuButton.MenuState.HIDDEN);
                this.bigBar.setMenuState(MenuButton.ActionType.SETTINGS, MenuButton.MenuState.VISIBLE);
            }
        }
    }

    private void setBigbarStyle() {
        Channel channel;
        if (this.bigBar != null) {
            this.bigBar.setImageLeftOfTitle(R.drawable.ch_plugin_normal_w);
            this.bigBar.setImageRightOfTitle(ColorSelector.getTextColor() == -1 ? R.drawable.ch_plugin_dropdown_arrow_down : R.drawable.ch_plugin_dropdown_arrow_down_b);
        }
        if ((channel = ChannelSelector.getCurrentChannel()) != null && this.bigBar != null) {
            this.bigBar.setTitle(channel.getName());
        }
    }

    private void setDisabledInputBoxView(boolean isSocketEvent) {
        Channel channel = ChannelSelector.getCurrentChannel();
        if (channel != null) {
            if (isSocketEvent) {
                if (channel.isWorking() || "active".equals(channel.getAwayOption())) {
                    this.setDisabledInputBoxVisibility(false);
                }
            } else if (!channel.isWorking() && "disabled".equals(channel.getAwayOption())) {
                this.setDisabledInputBoxVisibility(true);
            } else {
                this.setDisabledInputBoxVisibility(false);
            }
        } else {
            this.setDisabledInputBoxVisibility(false);
        }
    }

    private void setDisabledInputBoxVisibility(boolean isDisabled) {
        this.disabledInputText.setVisibility(UIUtils.getVisible(isDisabled, true));
        this.layoutInput.setVisibility(UIUtils.getVisible(!isDisabled, true));
    }

    private void changeBigBar(boolean expand) {
        if (this.bigBar != null) {
            Plugin plugin = PluginSelector.getPlugin();
            Channel channel = ChannelSelector.getCurrentChannel();
            UserChat userChat = this.presenter.getUserChat();
            this.bigBar.getImageRightOfTitle().setRotation(expand ? -180.0f : 0.0f);
            if (userChat == null || userChat.getHostType() == null || userChat.getHostId() == null) {
                this.bigBar.setImageLeftOfTitle(ChatResponseManager.getResponseSymbol(channel));
                this.bigBar.setTitle(channel == null ? ResUtils.getString((Context)this, "ch.unknown") : channel.getName());
                this.bigBar.setSubTitleByKey(ChatResponseManager.getShortResponseDescriptionKey(channel)).setSubTitleVisibility(!expand);
            } else {
                ProfileEntity entity = ProfileSelector.getHostProfile(userChat.getHostType(), userChat.getHostId());
                this.bigBar.setImageLeftOfTitle(ChatResponseManager.getManagerOnlineSymbol(plugin, entity));
                this.bigBar.setTitle(entity == null ? "" : entity.getName());
                this.bigBar.setSubTitleVisibility(false);
            }
        }
    }

    @Override
    public void onLoadUserChat(@Nullable UserChat userChat) {
        if (userChat != null) {
            this.typingManager.setChatId(userChat.getId());
        }
        if (userChat == null || userChat.getHostType() == null || userChat.getHostId() == null) {
            this.topNavFragment.setFollowingManagers(ManagerSelector.getFollowingManagers());
        } else {
            this.topNavFragment.setLastResponseManager(ProfileSelector.getPerson(userChat.getHostType(), userChat.getHostId()));
        }
        if (userChat == null) {
            this.expandTopNav(false);
        } else {
            this.collapseTopNav(true);
        }
        if (this.bigBar != null) {
            this.bigBar.setOnClickListener(this);
        }
        this.refreshMenuButton();
    }

    @Override
    public void updateBackwardId(@Nullable String backwardId) {
        this.chatList.setBackwardId(backwardId);
    }

    @Override
    public void setInputLayoutVisibility(@Nullable String userChatState) {
        if (userChatState != null) {
            Views.setVisibility(this.layoutInput, CompareUtils.exists((Comparable)((Object)userChatState), (Comparable[])new String[]{"ready", "open", "following", "holding", "continue_chat"}));
            Views.setVisibility((View)this.newChatButton, CompareUtils.isSame(userChatState, "closed"));
            if (CompareUtils.exists((Comparable)((Object)userChatState), (Comparable[])new String[]{"solved", "closed"})) {
                this.hideKeyboard((EditText)this.editChat);
            }
            this.disabledInputText.setVisibility(8);
        }
    }

    @Override
    public void showRefreshButton() {
        if (this.bigBar != null) {
            this.bigBar.setMenuState(MenuButton.ActionType.REFRESH, MenuButton.MenuState.VISIBLE);
        }
    }

    @Override
    public boolean isMovableToBottomPosition() {
        int lastPosition = this.layoutManager.findLastVisibleItemPosition();
        return lastPosition <= this.adapter.getItemCount() - 2 && lastPosition >= this.adapter.getItemCount() - 4;
    }

    @Override
    public boolean isBottomPosition() {
        return this.layoutManager.findLastCompletelyVisibleItemPosition() >= this.adapter.getItemCount() - 2;
    }

    @Override
    public void scrollToPosition(int position) {
        this.layoutManager.scrollToPosition(position);
    }

    @Override
    public void scrollToBottom(boolean force) {
        if (this.layoutManager.findLastCompletelyVisibleItemPosition() == this.adapter.getItemCount() - 2 || force) {
            this.layoutManager.scrollToPosition(this.adapter.getItemCount() - 1);
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case 902: {
                if (resultCode != 12) break;
                this.presenter.sendImageFiles(data.getStringArrayListExtra("PHOTO_INTENT_KEY"));
                this.collapseTopNav(true);
                break;
            }
            case 3001: {
                PhotoAlbumStorage.getInstance().release();
                break;
            }
            case 3002: {
                if (resultCode != 23) break;
                this.setResult(23);
            }
        }
    }

    @Override
    protected void receiveRxEvent(Object o) {
        super.receiveRxEvent(o);
    }

    @Override
    public void receiveCommand(Command command, @Nullable Object object) {
        this.presenter.receiveCommand(command, object);
    }

    @Override
    public void receiveData(Entity entity, boolean upsert) {
        this.presenter.receiveData(entity, upsert);
    }

    @Override
    public void receiveStoreEvent(StoreType storeType, UpdateType updateType, @Nullable Entity entity) {
        switch (storeType) {
            case USER: 
            case VEIL: {
                this.refreshChatCount(false);
                break;
            }
            case USER_CHAT: {
                this.refreshMenuButton();
                UserChat userChat = (UserChat)entity;
                if (userChat == null) {
                    return;
                }
                if (CompareUtils.isSame(userChat.getId(), this.presenter.getChatId())) {
                    this.setInputLayoutVisibility(userChat.getState());
                    this.bottomFloatingActionLayout.bindUserChatState(userChat.getState());
                }
                this.changeBigBar(this.topNavFragment.isExpand());
                if (userChat.getHostType() == null || userChat.getHostId() == null) {
                    this.topNavFragment.setFollowingManagers(ManagerSelector.getFollowingManagers());
                    break;
                }
                this.topNavFragment.setLastResponseManager(ProfileSelector.getPerson(userChat.getHostType(), userChat.getHostId()));
            }
        }
    }

    @Override
    public void receiveTyping(Typing typing) {
        if (typing != null && typing.isOther() && typing.isSameChat(this.presenter.getChatId(), "UserChat")) {
            this.typingManager.addTTLTimer(typing);
            this.presenter.receiveTyping(typing);
        }
    }

    @Override
    public void receiveLanguageEvent() {
        this.presenter.receiveLanguageEvent();
    }

    @Override
    public void optionClicked(MenuButton.ActionType actionType) {
        switch (actionType) {
            case REFRESH: {
                this.presenter.refresh();
                break;
            }
            case SETTINGS: {
                IntentUtils.setNextActivity((Context)this, SettingsActivity.class).setTransition(Transition.SLIDE_FROM_BOTTOM).startActivityForResult(3002);
                break;
            }
            case BACK: {
                this.onBackPressed();
                break;
            }
            case EXIT: {
                this.goToMain();
            }
        }
    }

    @Override
    public void setRefreshVisibility(boolean showRefresh) {
        if (this.bigBar != null) {
            this.bigBar.setMenuState(MenuButton.ActionType.REFRESH, showRefresh ? MenuButton.MenuState.VISIBLE : MenuButton.MenuState.HIDDEN);
        }
    }

    @Override
    public void setReconnectVisibility(boolean show) {
        this.topNavFragment.setReconnectVisibility(show);
    }

    @Override
    public void setChannel(Channel channel) {
        this.changeBigBar(this.topNavFragment.isExpand());
        this.setDisabledInputBoxView(true);
        this.topNavFragment.setChannel(channel);
    }

    @Override
    public void processNewMessage(@Nullable ProfileEntity profileEntity, @Nullable Message message) {
        if (profileEntity == null || message == null || message.getLog() != null) {
            return;
        }
        if (this.layoutManager.canScrollVertically() && !this.isBottomPosition()) {
            this.previewFragment.show(profileEntity);
        }
    }

    @Override
    public void setLastResponseManager(@Nullable Person person) {
        this.topNavFragment.setLastResponseManager(person);
    }

    @Override
    public void onRemovedChat() {
        this.finish();
    }

    @Override
    public void onWatchedTextChanged(String s) {
        this.imageSend.setEnabled(!TextUtils.isEmpty((CharSequence)s.trim()));
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.button_attach) {
            this.hideKeyboard((EditText)this.editChat);
            IntentUtils.setNextActivity((Context)this, PhotoPickerActivity.class).startActivityForResult(902);
        }
        if (id2 == R.id.iv_chat_send) {
            this.presenter.sendTextMessage(this.editChat.getString());
            this.editChat.setText("");
            this.topNavFragment.collapse();
        }
        if (id2 == R.id.big_bar) {
            if (this.chatList.isScrolling()) {
                return;
            }
            if (this.topNavFragment.isExpand()) {
                this.collapseTopNav(true);
            } else {
                this.expandTopNav(true);
            }
        }
    }

    private void collapseTopNav(boolean immediately) {
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                ChatActivity.this.topNavFragment.collapse();
                ChatActivity.this.chatList.setTranslationY(0.0f, true);
                ChatActivity.this.changeBigBar(false);
            }
        }, immediately ? 0L : 512L);
    }

    private void expandTopNav(boolean immediately) {
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                int topNavHeight = ChatActivity.this.topNavFragment.getExpectHeight();
                ChatActivity.this.hideKeyboard((EditText)ChatActivity.this.editChat);
                ChatActivity.this.topNavFragment.setTranslationY(-topNavHeight);
                ChatActivity.this.topNavFragment.expand();
                if (ChatActivity.this.chatList.canScrollVertically(-1)) {
                    ChatActivity.this.changeBigBar(true);
                } else {
                    ChatActivity.this.changeBigBar(topNavHeight > 0);
                }
            }
        }, immediately ? 0L : 512L);
    }

    @Override
    public void onClickTopNav() {
        if (this.chatList.isScrolling()) {
            return;
        }
        this.topNavFragment.collapse();
    }

    @Override
    public void onFileDownload(File file) {
        if (file.getType() != null && file.getType().startsWith("video")) {
            IntentUtils.setNextActivity((Context)this, VideoViewerActivity.class).putExtra("filename", file.getName()).putExtra("url", file.getUrl()).startActivity();
        } else {
            IntentUtils.setNextActivity((Context)this, DownloadActivity.class).putExtra("url", file.getUrl()).putExtra("filename", file.getFilename()).putExtra("image", file.isImage()).setTransition(Transition.NONE).startActivity();
        }
    }

    @Override
    public void onShowPhotoAlbum(File file) {
        IntentUtils.setNextActivity((Context)this, PhotoAlbumActivity.class).putExtra("fileId", file.getId()).startActivityForResult(3001);
    }

    @Override
    public void onWebDescriptionClick(String url) {
        Executor.executeLinkAction((Context)this, url, LinkType.URL);
    }

    @Override
    public void onChangeProfileMessageFocus(boolean hasFocus) {
        if (Build.VERSION.SDK_INT >= 16) {
            this.layoutInput.setBackground(ContextCompat.getDrawable((Context)this, (int)(hasFocus ? R.drawable.ch_plugin_chat_disabled_input_box_bg : R.drawable.ch_plugin_chat_input_box_bg)));
        } else {
            this.layoutInput.setBackgroundDrawable(ContextCompat.getDrawable((Context)this, (int)(hasFocus ? R.drawable.ch_plugin_chat_disabled_input_box_bg : R.drawable.ch_plugin_chat_input_box_bg)));
        }
    }

    public void onBackPressed() {
        if (!UserChatSelector.isEmpty() || this.presenter != null && this.presenter.getUserChat() != null) {
            this.finish();
        } else {
            this.goToMain();
        }
    }

    private void goToMain() {
        this.exit = true;
        this.setResult(24);
        this.finish();
    }

    @Override
    public void requestFocusEditText() {
        this.editChat.requestFocus();
    }

    @Override
    public void sendingMessageClicked(final SendingMessageItem item) {
        final AlertDialog dialog = new AlertDialog.Builder((Context)this).setMessage((CharSequence)ResUtils.getString((Context)this, "ch.chat.resend.description")).setPositiveButton((CharSequence)ResUtils.getString((Context)this, "ch.chat.retry_sending_message"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ChatActivity.this.presenter.resend(item);
            }
        }).setNegativeButton((CharSequence)ResUtils.getString((Context)this, "ch.chat.resend.cancel"), null).setNeutralButton((CharSequence)ResUtils.getString((Context)this, "ch.chat.delete"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ChatActivity.this.presenter.removeFailedItem(item);
            }
        }).setCancelable(true).create();
        dialog.setOnShowListener(new DialogInterface.OnShowListener(){

            public void onShow(DialogInterface args) {
                int dark = ContextCompat.getColor((Context)ChatActivity.this, (int)R.color.ch_dark);
                int cobalt = ContextCompat.getColor((Context)ChatActivity.this, (int)R.color.ch_cobalt);
                dialog.getButton(-1).setTextColor(cobalt);
                dialog.getButton(-2).setTextColor(dark);
                dialog.getButton(-3).setTextColor(dark);
            }
        });
        dialog.show();
    }

    @Override
    @AnimRes
    protected int getExistAnimOfFinish() {
        if (UserChatSelector.isEmpty() || this.exit) {
            return R.anim.ch_plugin_slide_out_bottom;
        }
        return R.anim.ch_plugin_slide_out_right;
    }
}

