package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnWebMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.model.ChatMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.WebPage;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;

/**
 * Created by jerry on 2018. 3. 28..
 */

public class WebMessageHolder extends ImageMessageHolder implements View.OnClickListener{

  protected RelativeLayout webPageLayout;
  protected CHTextView webTitleText;
  protected CHTextView webDescriptionText;

  @Nullable
  private OnWebMessageClickListener listener;
  @Nullable
  private Message message;
  @Nullable
  private WebPage webPage;

  public static WebMessageHolder newInstance(
      ViewGroup parent,
      MessageType messageType,
      @Nullable OnWebMessageClickListener listener) {
    return new WebMessageHolder(getItemView(parent, messageType), messageType, listener);
  }

  public WebMessageHolder(View itemView, MessageType messageType, @Nullable OnWebMessageClickListener listener) {
    super(itemView, messageType, listener);
    this.listener = listener;

    webPageLayout = itemView.findViewById(R.id.ch_message_content_webpage);
    webTitleText = itemView.findViewById(R.id.text_web_title);
    webDescriptionText = itemView.findViewById(R.id.text_web_description);
  }

  @Override
  public void bind(ChatMessageItem item, boolean isConnectedMessage) {
    super.bind(item, isConnectedMessage);

    message = item.getMessage();
    if (message != null) {
      webPage = message.getWebPage();

      if (webPage != null) {
        if (MessageType.GUEST_WEB_MESSAGE == item.getType()) {
          if (guestMessageTextLayout != null) {
            guestMessageTextLayout.setVisibility(View.VISIBLE);
          }
        } else {
          if (managerMessageTextLayout != null) {
            managerMessageTextLayout.setVisibility(View.VISIBLE);
          }
        }
        setWebMessage(webPage, message.getMessage());
      }
    }
  }

  private void setWebMessage(WebPage webPage, String messageText) {
    webPageLayout.setVisibility(View.VISIBLE);
    webPageLayout.setOnClickListener(this);

    if (webPage.getPreviewThumb() != null) {
      super.setImageMessage(webPage.getPreviewThumb(), true, messageText);
      if (getPreviewImageSize() != null) {
        int width = getPreviewImageSize().x;
        int marginTop = (int) Utils.dpToPx(itemView.getContext(), 5f);

        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(width, ViewGroup.LayoutParams.WRAP_CONTENT);
        params.setMargins(0, marginTop, 0, 0);
        webPageLayout.setLayoutParams(params);
      }
    }

    if (!TextUtils.isEmpty(webPage.getTitle())) {
      webTitleText.setText(webPage.getTitle());
    } else {
      webTitleText.setText(webPage.getUrl() != null ? webPage.getUrl() : "");
    }

    if (!TextUtils.isEmpty(webPage.getDescription())) {
      webDescriptionText.setText(webPage.getTitle());
    } else {
      webDescriptionText.setText(webPage.getUrl() != null ? webPage.getUrl() : "");
    }
  }

  @Override
  protected void onImageClick() {
    if (listener != null && webPage != null) {
      listener.onWebDescriptionClick(webPage.getUrl());
    }
  }

  @Override
  public void onClick(View v) {
    if (listener != null && webPage != null) {
      listener.onWebDescriptionClick(webPage.getUrl());
    }
  }
}
