package com.zoyi.channel.plugin.android.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.provider.MediaStore;
import android.text.TextUtils;

import com.zoyi.channel.plugin.android.global.ChannelFileProvider;
import com.zoyi.channel.plugin.android.global.Const;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Executor {

  public static boolean takePhoto(Activity activity) {
    Intent takePictureIntent = new Intent(MediaStore.ACTION_IMAGE_CAPTURE);

    File photoFile = getPhotoFile();
    if (photoFile == null) {
      return false;
    }

    takePictureIntent.putExtra(
        MediaStore.EXTRA_OUTPUT,
        ChannelFileProvider.getUriForFile(activity, getPhotoFile()));

    if (takePictureIntent.resolveActivity(activity.getPackageManager()) != null) {
      activity.startActivityForResult(takePictureIntent, Const.REQUEST_TAKE_PHOTO);
      return true;
    }
    return false;
  }

  public static void startFileMediaScan(Activity activity, String filePath) {
    startFileMediaScan(activity, new File(filePath));
  }

  public static void startFileMediaScan(Activity activity, File file) {
    Intent mediaScanIntent = new Intent(Intent.ACTION_MEDIA_SCANNER_SCAN_FILE);

    mediaScanIntent.setData(Uri.fromFile(file));
    activity.sendBroadcast(mediaScanIntent);
  }

  private static String photoPath = null;
  public static String getPhotoPath() {
    return photoPath;
  }

  @SuppressLint("SimpleDateFormat")
  private static File getPhotoFile() {
    File file = null;

    try {
      String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());

      file = File.createTempFile(timeStamp, ".jpg", FileUtils.getPhotoDirectory());
      photoPath = file.getAbsolutePath();
    } catch (IOException e) {
      e.printStackTrace();
    }
    return file;
  }

  public static void goWeb(Context context, String url) {
    if (TextUtils.isEmpty(url)) {
      return;
    }

    Intent intent = new Intent(Intent.ACTION_VIEW);

    try {
      Uri uri = Uri.parse(url);

      if (uri.getScheme() == null || uri.getScheme().isEmpty()) {
        uri = Uri.parse("http://" + url);
      }

      intent.setData(uri);

      if (context != null) {
        context.startActivity(intent);
      }
    } catch (Exception ex) {
      L.e(ex.getMessage());
    }
  }

  public static void call(Context context, String phoneNumber) {
    if (TextUtils.isEmpty(phoneNumber)) {
      return;
    }

    Intent intent = new Intent(Intent.ACTION_DIAL);

    intent.setData(Uri.parse("tel:" + phoneNumber));

    if (intent.resolveActivity(context.getPackageManager()) != null) {
      context.startActivity(intent);
    }
  }
}
