package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.support.annotation.Nullable;
import android.text.util.Linkify;
import android.view.View;
import android.view.ViewGroup;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnTextMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.model.WelcomeMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.util.message_format.CustomMovementMethod;

/**
 * Created by mika on 2018. 6. 22..
 */

public class WelcomeMessageHolder extends TextMessageHolder {

  @Nullable
  private OnTextMessageClickListener listener;

  public static WelcomeMessageHolder newInstance(ViewGroup parent, @Nullable OnTextMessageClickListener listener) {
    return new WelcomeMessageHolder(getItemView(parent, MessageType.WELCOME_MESSAGE), listener);
  }

  public WelcomeMessageHolder(View itemView, @Nullable OnTextMessageClickListener listener) {
    super(itemView, MessageType.WELCOME_MESSAGE, listener);
  }

  public void bind(WelcomeMessageItem item) {
    super.bind(item.getMessage(), MessageType.WELCOME_MESSAGE, false);

    if (managerMessageTextLayout != null &&
        managerMessageText != null &&
        managerMessageHeadTop != null &&
        managerMessageContextTop != null) {
      managerMessageText.setLinksClickable(false);
      managerMessageText.setAutoLinkMask(Linkify.WEB_URLS);

      if (item.getMessage().getFormattedSpanMessage() != null) {
        managerMessageText.setText(item.getMessage().getFormattedSpanMessage());
        managerMessageText.setMovementMethod(CustomMovementMethod.getInstance());
      } else {
        managerMessageText.setText("");
      }

      managerMessageTextLayout.setVisibility(View.VISIBLE);
      managerMessageHeadTop.setVisibility(View.VISIBLE);
      managerMessageContextTop.setVisibility(View.GONE);
    }
  }
}
