/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.adapter.rxjava;

import com.zoyi.retrofit2.Response;
import com.zoyi.retrofit2.adapter.rxjava.Result;
import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.exceptions.CompositeException;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.exceptions.OnCompletedFailedException;
import com.zoyi.rx.exceptions.OnErrorFailedException;
import com.zoyi.rx.exceptions.OnErrorNotImplementedException;
import com.zoyi.rx.plugins.RxJavaPlugins;

final class ResultOnSubscribe<T>
implements Observable.OnSubscribe<Result<T>> {
    private final Observable.OnSubscribe<Response<T>> upstream;

    ResultOnSubscribe(Observable.OnSubscribe<Response<T>> upstream) {
        this.upstream = upstream;
    }

    public void call(Subscriber<? super Result<T>> subscriber) {
        this.upstream.call(new ResultSubscriber(subscriber));
    }

    private static class ResultSubscriber<R>
    extends Subscriber<Response<R>> {
        private final Subscriber<? super Result<R>> subscriber;

        ResultSubscriber(Subscriber<? super Result<R>> subscriber) {
            super(subscriber);
            this.subscriber = subscriber;
        }

        public void onNext(Response<R> response) {
            this.subscriber.onNext(Result.response(response));
        }

        public void onError(Throwable throwable) {
            try {
                this.subscriber.onNext(Result.error(throwable));
            }
            catch (Throwable t) {
                try {
                    this.subscriber.onError(t);
                }
                catch (OnCompletedFailedException | OnErrorFailedException | OnErrorNotImplementedException e) {
                    RxJavaPlugins.getInstance().getErrorHandler().handleError(e);
                }
                catch (Throwable inner) {
                    Exceptions.throwIfFatal((Throwable)inner);
                    CompositeException composite = new CompositeException(new Throwable[]{t, inner});
                    RxJavaPlugins.getInstance().getErrorHandler().handleError((Throwable)composite);
                }
                return;
            }
            this.subscriber.onCompleted();
        }

        public void onCompleted() {
            this.subscriber.onCompleted();
        }
    }
}

