/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat;

import android.content.Context;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.activity.chat.ChatAdapterContract;
import com.zoyi.channel.plugin.android.activity.chat.ChatContract;
import com.zoyi.channel.plugin.android.activity.chat.ChatManager;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnFileMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnFormMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnImageMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageReviewListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageSendListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnProfileUpdateListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnSendingMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnTextMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnWebMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.model.MobileNumber;
import com.zoyi.channel.plugin.android.activity.chat.model.NewMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.ProfileBotMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SendingMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.TypingItem;
import com.zoyi.channel.plugin.android.enumerate.ChatState;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.enumerate.TranslationState;
import com.zoyi.channel.plugin.android.event.ChannelModelBus;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.ActionInput;
import com.zoyi.channel.plugin.android.model.TranslationInfo;
import com.zoyi.channel.plugin.android.model.entity.Entity;
import com.zoyi.channel.plugin.android.model.entity.Person;
import com.zoyi.channel.plugin.android.model.etc.Typing;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Country;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.model.rest.Session;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.model.wrapper.CountryWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.MessageWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.MessagesWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.TranslationRepo;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatWrapper;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.selector.GuestSelector;
import com.zoyi.channel.plugin.android.selector.PluginSelector;
import com.zoyi.channel.plugin.android.selector.ProfileSelector;
import com.zoyi.channel.plugin.android.selector.TranslationSelector;
import com.zoyi.channel.plugin.android.socket.SocketManager;
import com.zoyi.channel.plugin.android.store.Store;
import com.zoyi.channel.plugin.android.store.TranslationStore;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.RequestUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.channel.plugin.android.view.dialog.CountryCodeDialog;
import com.zoyi.okhttp3.RequestBody;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class ChatPresenter
implements ChatContract.Presenter,
OnTextMessageClickListener,
OnFileMessageClickListener,
OnImageMessageClickListener,
OnWebMessageClickListener,
OnSendingMessageClickListener,
OnMessageSendListener,
OnMessageReviewListener,
OnProfileUpdateListener,
OnFormMessageClickListener {
    private ChatContract.View view;
    private ChatAdapterContract.View adapterView;
    private ChatAdapterContract.Model adapterModel;
    private Context context;
    @Nullable
    private UserChat userChat;
    @Nullable
    private Session session;
    @Nullable
    private String chatId;
    private ChatState state = ChatState.IDLE;
    private String backwardId = "zzzzzzzzzzzzzzzz";
    private String forwardId = "0000000000000000";
    private String forwardTempId = "0000000000000000";
    private Long forwardTimestamp = Long.MIN_VALUE;
    private int fetchCounter = 0;
    private boolean backwardLoading = false;
    private boolean isStateCompleted = false;
    private boolean isNewUserChat = false;
    @Nullable
    private Long lastReadAt;
    private long welcomedAt;
    private List<Country> countries;
    private List<SendingMessageItem> tempQueue;
    private final Object messageObject = new Object();

    public ChatPresenter(Context context) {
        this.context = context;
        TimeUtils.refreshOffset();
        this.tempQueue = new ArrayList<SendingMessageItem>();
        this.countries = new ArrayList<Country>();
    }

    @Override
    @Initializer
    public void setView(ChatContract.View view) {
        this.view = view;
    }

    @Override
    @Nullable
    public UserChat getUserChat() {
        return this.userChat;
    }

    @Override
    @Nullable
    public String getChatId() {
        return this.chatId;
    }

    @Override
    public boolean isStateCompleted() {
        return this.isStateCompleted;
    }

    @Override
    public void setChatId(@Nullable String chatId) {
        this.chatId = chatId;
    }

    @Override
    @Initializer
    public void setAdapterView(ChatAdapterContract.View adapterView) {
        this.adapterView = adapterView;
        this.adapterView.setOnTextMessageClickListener(this);
        this.adapterView.setOnFileMessageClickListener(this);
        this.adapterView.setOnImageMessageClickListener(this);
        this.adapterView.setOnWebMessageClickListener(this);
        this.adapterView.setOnSendingMessageClickListener(this);
        this.adapterView.setOnMessageReviewListener(this);
        this.adapterView.setOnProfileUpdateListener(this);
        this.adapterView.setOnFormMessageClickListener(this);
    }

    @Override
    @Initializer
    public void setAdapterModel(ChatAdapterContract.Model adapterModel) {
        this.adapterModel = adapterModel;
    }

    @Override
    public void init(@Nullable String chatId) {
        if (!TextUtils.isEmpty((CharSequence)chatId)) {
            this.fetchUserChat(chatId);
        } else {
            this.addWelcomeMessage();
            this.view.onLoadUserChat(null, false);
            this.view.updateBackwardId(null);
        }
    }

    private void addWelcomeMessage() {
        String channelLanguage = PrefSupervisor.getPluginLanguage(this.context);
        Plugin plugin = PluginSelector.getPlugin();
        String message = plugin != null ? (GuestSelector.isNamed() ? plugin.getWelcomeNamedI18n().get(channelLanguage).replace("${name}", GuestSelector.getName()) : plugin.getWelcomeI18n().get(channelLanguage)) : ResUtils.getString(this.context, "ch.unknown");
        if (!TextUtils.isEmpty((CharSequence)message)) {
            this.welcomedAt = System.currentTimeMillis();
            this.adapterModel.setWelcomeMessage(message, this.welcomedAt);
        }
    }

    private void fetchUserChat(String chatId) {
        this.chatId = chatId;
        this.adapterModel.addMessageItems(this.getChatManager().getFailedItems(chatId));
        if (this.userChat == null) {
            this.view.showProgress(ResUtils.getString(this.context, "ch.loading_information"));
        }
        this.setState(ChatState.USER_CHAT_LOADING, false);
        ChannelIO.getApi().getUserChat(chatId).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<UserChatWrapper>(){

            @Override
            public void onError(RetrofitException error) {
                ChatPresenter.this.view.hideProgress();
                ChatPresenter.this.handleUserChatFetchError(error);
            }

            @Override
            public void onNext(UserChatWrapper repo) {
                if (repo != null) {
                    repo.update();
                }
                ChatPresenter.this.setUserChat(repo, false);
            }
        });
    }

    private void createUserChat() {
        this.view.showProgress(ResUtils.getString(this.context, "ch.loading_information"));
        this.setState(ChatState.USER_CHAT_LOADING, false);
        Plugin plugin = PluginSelector.getPlugin();
        if (plugin != null && plugin.getKey() != null) {
            ChannelIO.getApi().createUserChat(plugin.getKey(), plugin.getId(), this.welcomedAt).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<UserChatWrapper>(){

                @Override
                public void onError(RetrofitException error) {
                    ChatPresenter.this.view.hideProgress();
                    ChatPresenter.this.handleUserChatFetchError(error);
                }

                @Override
                public void onNext(UserChatWrapper repo) {
                    if (repo != null) {
                        repo.update();
                    }
                    RxBus.post(new ChannelModelBus(repo.getUserChat(), true));
                    RxBus.post(new ChannelModelBus(repo.getSession(), true));
                    ChatPresenter.this.setUserChat(repo, true);
                }
            });
        } else {
            this.view.hideProgress();
        }
    }

    private void setUserChat(UserChatWrapper wrapper, boolean create) {
        this.view.hideProgress();
        if (this.isStateEquals(ChatState.USER_CHAT_LOADING)) {
            if (wrapper == null) {
                this.handleUserChatFetchError(new Exception("UserChatWrapper cannot be null"));
            } else {
                this.userChat = wrapper.getUserChat();
                this.chatId = this.userChat.getId();
                this.isStateCompleted = this.userChat.isStateCompleted();
                this.session = wrapper.getSession();
                this.adapterModel.setUserChat(this.userChat);
                this.view.onLoadUserChat(this.userChat, create);
                this.view.setInputLayoutVisibility();
                this.view.setReconnectVisibility(false);
                if (this.lastReadAt == null) {
                    this.lastReadAt = create ? Long.MAX_VALUE : this.session.getLastReadAt();
                }
                if (this.tempQueue.size() > 0) {
                    this.getChatManager().send(this.chatId, this.tempQueue, this);
                    this.tempQueue.clear();
                }
                this.joinChat();
            }
        }
    }

    private void handleUserChatFetchError(Throwable throwable) {
        if (throwable != null) {
            L.e(throwable.getMessage());
        }
        if (this.isStateEquals(ChatState.USER_CHAT_LOADING)) {
            this.setState(ChatState.USER_CHAT_NOT_LOADED, true);
        }
    }

    private void joinChat() {
        if (SocketManager.isReady()) {
            this.setState(ChatState.CHAT_JOINING, false);
            SocketManager.joinChat(this.chatId);
        } else {
            this.setState(ChatState.WAITING_SOCKET, false);
            SocketManager.reconnect();
        }
    }

    private boolean isAvailableRequest(int count) {
        return this.isStateEquals(ChatState.MESSAGES_LOADING) && this.fetchCounter == count;
    }

    private void fetchMessages() {
        if (SocketManager.isReady()) {
            ++this.fetchCounter;
            this.setState(ChatState.MESSAGES_LOADING, false);
            if (!this.isMessageExists()) {
                this.fetchInitMessages(this.fetchCounter);
            } else {
                this.fetchForwardMessages(this.forwardId, this.fetchCounter);
            }
        } else {
            this.setState(ChatState.WAITING_SOCKET, false);
            SocketManager.reconnect();
        }
    }

    @Override
    public boolean isMessageExists() {
        return CompareUtils.compare(this.backwardId, this.forwardId) < 0;
    }

    private void fetchInitMessages(final int counter) {
        if (!TextUtils.isEmpty((CharSequence)this.chatId)) {
            ChannelIO.getApi().getMessages(this.chatId, "zzzzzzzzzzzzzzzz", 30, "DESC").subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<MessagesWrapper>(){

                @Override
                public void onError(RetrofitException error) {
                    if (ChatPresenter.this.isAvailableRequest(counter)) {
                        ChatPresenter.this.handleMessagesFetchError(error, counter);
                    }
                }

                @Override
                public void onNext(MessagesWrapper repo) {
                    if (ChatPresenter.this.isAvailableRequest(counter)) {
                        if (repo != null) {
                            repo.update();
                        }
                        if (repo == null) {
                            ChatPresenter.this.handleMessagesFetchError(new Exception("MessagesWrapper cannot be null"), counter);
                        } else {
                            ChatPresenter.this.backwardId = repo.getNext();
                            ChatPresenter.this.view.updateBackwardId(ChatPresenter.this.backwardId);
                            ChatPresenter.this.addMessages(repo.getMessages());
                            ChatPresenter.this.calculateForwardId(repo.getMessages());
                            ChatPresenter.this.calculateForwardId();
                            if (ChatPresenter.this.lastReadAt >= ChatPresenter.this.forwardTimestamp) {
                                ChatPresenter.this.lastReadAt = Long.MAX_VALUE;
                            }
                            ChatPresenter.this.addNewMessageItem(repo.getMessages());
                            ChatPresenter.this.setState(ChatState.CHAT_READY, false);
                            ChatPresenter.this.readAll();
                            if (ChatPresenter.this.isNewUserChat) {
                                ChatPresenter.this.requestProfileBot();
                                ChatPresenter.this.isNewUserChat = false;
                            }
                            ChatPresenter.this.view.scrollToBottom(true);
                        }
                    }
                }
            });
        }
    }

    @Override
    public void fetchBackwardMessages() {
        if (this.backwardLoading || !this.isMessageExists() || this.chatId == null) {
            return;
        }
        this.backwardLoading = true;
        ChannelIO.getApi().getMessages(this.chatId, this.backwardId, 30, "DESC").subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<MessagesWrapper>(){

            @Override
            public void onError(RetrofitException error) {
                ChatPresenter.this.backwardLoading = false;
                ChatPresenter.this.handleMessagesFetchError(error, ChatPresenter.this.fetchCounter);
            }

            @Override
            public void onNext(MessagesWrapper repo) {
                if (repo != null) {
                    repo.update();
                }
                if (repo == null) {
                    ChatPresenter.this.handleMessagesFetchError(new Exception("MessagesWrapper cannot be null"), ChatPresenter.this.fetchCounter);
                } else {
                    ChatPresenter.this.backwardId = repo.getNext();
                    ChatPresenter.this.view.updateBackwardId(ChatPresenter.this.backwardId);
                    ChatPresenter.this.adapterModel.addMessages(repo.getMessages(), ChatPresenter.this.chatId);
                    ChatPresenter.this.addNewMessageItem(repo.getMessages());
                }
                ChatPresenter.this.backwardLoading = false;
            }
        });
    }

    @Override
    public void fetchForwardMessages(String since, final int counter) {
        if (!TextUtils.isEmpty((CharSequence)this.chatId)) {
            ChannelIO.getApi().getMessages(this.chatId, since, 30, "ASC").subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<MessagesWrapper>(){

                @Override
                public void onError(RetrofitException error) {
                    if (ChatPresenter.this.isAvailableRequest(counter)) {
                        ChatPresenter.this.handleMessagesFetchError(error, counter);
                    }
                }

                @Override
                public void onNext(MessagesWrapper repo) {
                    if (ChatPresenter.this.isAvailableRequest(counter)) {
                        if (repo == null) {
                            ChatPresenter.this.handleMessagesFetchError(new Exception("MessagesWrapper cannot be null"), counter);
                        } else {
                            repo.update();
                            ChatPresenter.this.addMessages(repo.getMessages());
                            ChatPresenter.this.calculateForwardId(repo.getMessages());
                            if (repo.getNext() == null) {
                                ChatPresenter.this.calculateForwardId();
                                ChatPresenter.this.setState(ChatState.CHAT_READY, false);
                                ChatPresenter.this.readAll();
                            } else {
                                ChatPresenter.this.fetchForwardMessages(ChatPresenter.this.forwardId, counter);
                            }
                        }
                    }
                }
            });
        }
    }

    private void handleMessagesFetchError(Throwable throwable, int counter) {
        if (throwable != null) {
            L.e(throwable.getMessage());
        }
        if (this.isStateEquals(ChatState.MESSAGES_LOADING) && this.fetchCounter == counter) {
            this.setState(ChatState.MESSAGES_NOT_LOADED, true);
        }
    }

    private void addNewMessageItem(List<Message> messages) {
        if (this.lastReadAt == null || this.isStateCompleted) {
            return;
        }
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        if (messages != null) {
            for (Message message : messages) {
                if (message.getLog() != null) continue;
                min = Math.min(min, message.getCreatedAt());
                max = Math.max(max, message.getCreatedAt());
            }
        }
        if (min <= this.lastReadAt && this.lastReadAt < max) {
            this.adapterModel.addMessageItem(new NewMessageItem(this.lastReadAt));
        }
    }

    private void addMessage(Message message) {
        if (!TextUtils.isEmpty((CharSequence)this.chatId) && CompareUtils.isSame(message.getChatId(), this.chatId)) {
            String oldMessageId = this.adapterModel.getLastMessageItemId();
            this.adapterModel.addMessage(message, this.chatId);
            String newMessageId = this.adapterModel.getLastMessageItemId();
            if (this.isStateEquals(ChatState.CHAT_READY)) {
                this.calculateForwardId(message);
                this.readAll();
            } else {
                this.forwardTempId = CompareUtils.max(this.forwardTempId, message.getId());
            }
            this.forwardTimestamp = Math.max(this.forwardTimestamp, message.getCreatedAt());
            this.view.scrollToBottom(this.view.isMovableToBottomPosition());
            if (!CompareUtils.isSame(oldMessageId, newMessageId)) {
                this.view.processNewMessage(ProfileSelector.getHostProfile(message.getPersonType(), message.getPersonId()), message);
            }
        }
    }

    private void addMessages(List<Message> messages) {
        if (messages != null) {
            for (Message message : messages) {
                this.forwardTimestamp = Math.max(this.forwardTimestamp, message.getCreatedAt());
                this.forwardId = CompareUtils.max(this.forwardId, message.getId());
            }
        }
        this.adapterModel.addMessages(messages, this.chatId);
    }

    private void calculateForwardId(Message message) {
        if (message != null) {
            this.forwardId = CompareUtils.max(this.forwardId, message.getId());
        }
    }

    private void calculateForwardId(List<Message> messages) {
        if (messages != null) {
            for (Message message : messages) {
                this.calculateForwardId(message);
            }
        }
    }

    private void calculateForwardId() {
        this.forwardId = CompareUtils.max(this.forwardId, this.forwardTempId);
    }

    @Override
    public void sendTextMessage(String message) {
        if (!TextUtils.isEmpty((CharSequence)message)) {
            SendingMessageItem item = new SendingMessageItem(this.chatId, message, false);
            this.adapterModel.addMessageItem(item);
            this.sendMessages(Collections.singletonList(item));
        }
    }

    @Override
    public void sendImageFiles(ArrayList<String> imagePaths) {
        ArrayList<SendingMessageItem> items = new ArrayList<SendingMessageItem>();
        if (imagePaths != null) {
            for (String p : imagePaths) {
                SendingMessageItem item = new SendingMessageItem(this.chatId, p, true);
                this.adapterModel.addMessageItem(item);
                items.add(item);
            }
        }
        this.sendMessages(items);
    }

    private void sendSelectedFormMessage(SendingMessageItem item) {
        this.adapterModel.addMessageItem(item);
        this.sendMessages(Collections.singletonList(item));
    }

    private void sendMessages(List<SendingMessageItem> items) {
        this.view.scrollToBottom(true);
        if (this.chatId == null) {
            this.tempQueue.addAll(items);
            this.isNewUserChat = true;
            this.createUserChat();
        } else {
            this.getChatManager().send(items, (OnMessageSendListener)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveData(Entity entity, boolean upsert) {
        if (entity != null) {
            if (!TextUtils.isEmpty((CharSequence)this.chatId)) {
                Object object = this.messageObject;
                synchronized (object) {
                    switch (entity.getClass().getSimpleName()) {
                        case "Message": {
                            Message message = (Message)entity;
                            if (message.getBotOption() != null && message.getBotOption().isWelcome() && this.adapterModel.getWelcomeMessage() != null) {
                                return;
                            }
                            this.handleMessageLog(message);
                            this.addMessage(message);
                            break;
                        }
                        case "Bot": 
                        case "Manager": {
                            if (this.userChat == null || this.userChat.isStateReady() || this.userChat.isStateOpen()) break;
                            this.view.setPerson((Person)entity);
                            break;
                        }
                        case "UserChat": {
                            this.handleUserChatData((UserChat)entity, this.chatId);
                            this.view.changeBigBar();
                        }
                    }
                }
            }
            if ("Channel".equals(entity.getClass().getSimpleName())) {
                this.view.setChannel((Channel)entity);
            }
        }
    }

    private void handleUserChatData(UserChat userChat, String chatId) {
        if (userChat == null || !chatId.equals(userChat.getId())) {
            return;
        }
        this.userChat = userChat;
        if (userChat.isStateRemoved()) {
            this.leaveChat();
            this.view.onRemovedChat();
        } else if (userChat.isStateCompleted()) {
            this.adapterModel.addMessageItem(userChat);
            this.view.scrollToBottom(false);
        } else if (userChat.isStateFollowing()) {
            this.view.setPerson(ProfileSelector.getPerson(userChat.getHostType(), userChat.getHostId()));
        }
    }

    private void handleMessageLog(Message message) {
        if (CompareUtils.isSame(message.getChatId(), this.chatId) && this.userChat != null) {
            if (message.getLog() == null) {
                return;
            }
            if (message.getLog().isResolve()) {
                this.isStateCompleted = true;
                this.userChat.setState("resolved");
            } else if (message.getLog().isClose()) {
                this.isStateCompleted = true;
                this.userChat.setState("closed");
            } else {
                this.isStateCompleted = false;
            }
            this.adapterModel.setUserChat(this.userChat);
            this.view.setInputLayoutVisibility();
        }
    }

    private void requestProfileBot() {
        Plugin plugin = PluginSelector.getPlugin();
        if (plugin != null && !TextUtils.isEmpty((CharSequence)this.chatId)) {
            ChannelIO.getApi().requestProfileBot(this.chatId, plugin.getId()).onBackpressureBuffer().subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe();
        }
    }

    private void readAll() {
        if (!TextUtils.isEmpty((CharSequence)this.chatId)) {
            ChannelIO.getApi().readAll(this.chatId).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe(new RestSubscriber());
        }
    }

    @Override
    public void receiveCommand(Command command, @Nullable Object object) {
        switch (command) {
            case APP_STARTED: {
                this.refresh();
                break;
            }
            case SOCKET_DISCONNECTED: {
                ++this.fetchCounter;
                if (this.isStateEquals(ChatState.IDLE)) break;
                this.setState(ChatState.USER_CHAT_NOT_LOADED, true);
                break;
            }
            case SOCKET_ERROR: {
                this.view.setReconnectVisibility(true);
                break;
            }
            case READY: {
                this.view.setReconnectVisibility(false);
                if (this.isStateEquals(ChatState.WAITING_SOCKET)) {
                    this.joinChat();
                    break;
                }
                this.refresh();
                break;
            }
            case LEAVED: {
                if (object == null || CompareUtils.compare(this.chatId, (String)object) != 0 || !this.isStateEquals(ChatState.CHAT_READY)) break;
                this.setState(ChatState.NOT_JOINED, false);
                break;
            }
            case JOINED: {
                if (object == null || CompareUtils.compare(this.chatId, (String)object) != 0 || !this.isStateEquals(ChatState.CHAT_JOINING)) break;
                this.view.setReconnectVisibility(false);
                this.fetchMessages();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveTyping(Typing typing) {
        Object object = this.messageObject;
        synchronized (object) {
            TypingItem item = new TypingItem();
            int position = this.adapterModel.getIndex(item);
            if (position >= 0) {
                item = (TypingItem)this.adapterModel.getItem(position);
            }
            if (item == null) {
                return;
            }
            switch (typing.getAction()) {
                case "start": {
                    item.addOrUpdateTyping(typing);
                    break;
                }
                case "stop": {
                    item.removeTyping(typing);
                }
            }
            this.adapterModel.addOrUpdateMessageItem(position, item);
        }
    }

    @Override
    public void receiveLanguageEvent() {
        if (this.chatId == null) {
            this.addWelcomeMessage();
        }
    }

    @Override
    public void requestResendClicked(SendingMessageItem item) {
        this.view.sendingMessageClicked(item);
    }

    @Override
    public void resend(SendingMessageItem item) {
        if (item != null) {
            this.removeFailedItem(item);
            item.refreshCreatedAt();
            this.adapterModel.addMessageItem(item);
            this.getChatManager().send(item, (OnMessageSendListener)this);
        }
    }

    @Override
    public void removeFailedItem(SendingMessageItem item) {
        if (item != null) {
            this.adapterModel.removeMessageItem(item);
            this.getChatManager().removeFailedItem(item.getCreatedAt());
        }
    }

    @Override
    public void sendSuccessed(SendingMessageItem item, Message message) {
        this.adapterModel.removeMessageItem(item);
        this.receiveData(message, true);
    }

    @Override
    public void sendFailed(SendingMessageItem item) {
        this.adapterModel.addMessageItem(item);
    }

    @Override
    public void refresh() {
        switch (this.state) {
            case USER_CHAT_NOT_LOADED: {
                if (!TextUtils.isEmpty((CharSequence)this.chatId)) {
                    this.fetchUserChat(this.chatId);
                    break;
                }
                this.createUserChat();
                break;
            }
            case WAITING_SOCKET: {
                SocketManager.connect();
                break;
            }
            case NOT_JOINED: {
                this.setState(ChatState.CHAT_JOINING, true);
                SocketManager.joinChat(this.chatId);
                break;
            }
            case MESSAGES_NOT_LOADED: {
                this.fetchMessages();
                break;
            }
            case IDLE: {
                this.init(this.chatId);
            }
        }
    }

    private void setState(ChatState state, boolean showRefresh) {
        this.state = state;
        this.view.setRefreshVisibility(showRefresh);
    }

    private boolean isStateEquals(ChatState targetState) {
        return targetState.equals((Object)this.state);
    }

    @Override
    public void onMessageReview(@Nullable String review) {
        if (!TextUtils.isEmpty((CharSequence)this.chatId)) {
            ChannelIO.getApi().reviewUserChat(this.chatId, review).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<UserChatWrapper>(){

                @Override
                public void onError(RetrofitException error) {
                    L.e(error.getMessage());
                }

                @Override
                public void onNext(UserChatWrapper repo) {
                    UserChat userChat;
                    if (repo != null) {
                        repo.update();
                    }
                    if (repo != null && (userChat = repo.getUserChat()) != null) {
                        ChatPresenter.this.adapterModel.addMessageItem(userChat);
                    }
                }
            });
        }
    }

    @Override
    public void leaveChat() {
        SocketManager.leaveChat(this.chatId);
    }

    private ChatManager getChatManager() {
        return ChatManager.get();
    }

    @Override
    public void getCountries(final ProfileBotMessageItem item, final String key, final MobileNumber mobileNumber) {
        if (this.countries == null || this.countries.isEmpty()) {
            this.view.showProgress(ResUtils.getString(this.context, "ch.loading_information"));
            ChannelIO.getApi().getCountries().subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<CountryWrapper>(){

                @Override
                public void onError(RetrofitException e) {
                    ChatPresenter.this.view.hideProgress();
                }

                @Override
                public void onNext(CountryWrapper repo) {
                    ChatPresenter.this.view.hideProgress();
                    if (repo != null) {
                        repo.set();
                    }
                    if (repo != null) {
                        ChatPresenter.this.countries = repo.getCountries();
                        ChatPresenter.this.showCountryDialog(item, key, mobileNumber);
                    }
                }
            });
        } else {
            this.showCountryDialog(item, key, mobileNumber);
        }
    }

    private void showCountryDialog(final ProfileBotMessageItem item, final String key, final MobileNumber mobileNumber) {
        String countryName;
        switch (PrefSupervisor.getPluginLanguage(this.context)) {
            case "ko": {
                countryName = "South Korea";
                break;
            }
            case "ja": {
                countryName = "Japan";
                break;
            }
            default: {
                countryName = "United States";
            }
        }
        new CountryCodeDialog(this.context, countryName, this.countries, new CountryCodeDialog.OnCountryCodeSelectListener(){

            @Override
            public void onCountryCodeSelected(int position, String countryCode) {
                mobileNumber.setCountryCode(Integer.valueOf(countryCode));
                item.setInputState(key, mobileNumber, false, null);
                ChatPresenter.this.adapterModel.addMessageItem(item);
            }
        }).show();
    }

    @Override
    public void onProfileUpdate(final ProfileBotMessageItem item, final String key, Object value) {
        item.setInputState(key, item.getInputState(), true, null);
        this.adapterModel.addMessageItem(item);
        RequestBody requestBody = RequestUtils.form().set(key, value).create();
        ChannelIO.getApi().updateProfileBot(item.getMessage().getId(), requestBody).onBackpressureBuffer().subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<MessageWrapper>(){

            @Override
            public void onError(RetrofitException error) {
                item.setInputState(key, item.getInputState(), false, ResUtils.getString(ChatPresenter.this.context, "ch.profile_form.error"));
                ChatPresenter.this.adapterModel.addMessageItem(item);
                ChatPresenter.this.view.scrollToBottom(ChatPresenter.this.view.isMovableToBottomPosition());
            }

            @Override
            public void onNext(MessageWrapper repo) {
                if (repo != null) {
                    repo.update();
                }
                item.setMessage(repo.getMessage());
                item.resetInputState();
                ChatPresenter.this.adapterModel.addMessageItem(item);
                ChatPresenter.this.view.scrollToBottom(ChatPresenter.this.view.isMovableToBottomPosition());
            }
        });
    }

    @Override
    public void onCompleteWriteProfile() {
        if (this.userChat != null && !this.userChat.isStateCompleted() && !this.userChat.isStateRemoved()) {
            this.view.requestFocusEditText();
        }
    }

    @Override
    public void onChangeProfileFocus(boolean hasFocus) {
        this.view.onChangeProfileMessageFocus(hasFocus);
    }

    @Override
    public void onFormMessageClick(ActionInput actionInput) {
        HashMap<String, String> submit = new HashMap<String, String>();
        submit.put("id", actionInput.getMessage().getId());
        submit.put("key", actionInput.getKey());
        SendingMessageItem item = new SendingMessageItem(actionInput.getMessage().getChatId(), actionInput.getValue(PrefSupervisor.getPluginLanguage(this.context)), false);
        item.setSubmit(submit);
        this.sendSelectedFormMessage(item);
    }

    @Override
    public void onTranslationMessageClick(final Message message) {
        String pluginLanguage = PrefSupervisor.getPluginLanguage(this.context);
        final String uniqueId = TranslationInfo.createId(message.getId(), pluginLanguage);
        TranslationInfo translationInfo = TranslationSelector.get(uniqueId);
        if (translationInfo == null) {
            Store.getInstance(TranslationStore.class).add(TranslationInfo.createProgressStateInfo(uniqueId));
            this.adapterModel.addMessage(message, this.chatId);
            ChannelIO.getApi().getTranslatedMessage(message.getId(), pluginLanguage).onBackpressureBuffer().subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<TranslationRepo>(){

                @Override
                public void onError(RetrofitException error) {
                    Store.getInstance(TranslationStore.class).add(TranslationInfo.createOriginStateInfo(uniqueId));
                    ChatPresenter.this.adapterModel.addMessage(message, ChatPresenter.this.chatId);
                }

                @Override
                public void onNext(TranslationRepo repo) {
                    if (repo != null && repo.getTranslatedMessage() != null) {
                        TranslationInfo info = new TranslationInfo(uniqueId, repo.getTranslatedMessage(), TranslationState.TRANSLATED);
                        Store.getInstance(TranslationStore.class).add(info);
                    } else {
                        Store.getInstance(TranslationStore.class).add(TranslationInfo.createOriginStateInfo(uniqueId));
                    }
                    ChatPresenter.this.adapterModel.addMessage(message, ChatPresenter.this.chatId);
                }
            });
        } else {
            translationInfo.setState(TranslationState.ORIGIN.equals((Object)translationInfo.getState()) ? TranslationState.TRANSLATED : TranslationState.ORIGIN);
            Store.getInstance(TranslationStore.class).add(translationInfo);
            this.adapterModel.addMessage(message, this.chatId);
        }
    }

    @Override
    public void onFileClick(File file) {
        this.view.onFileDownload(file);
    }

    @Override
    public void onWebDescriptionClick(String url) {
        this.view.onUrlClicked(url);
    }

    @Override
    public void onImageClick(File file) {
        this.adapterModel.setImageFilesToStorage();
        this.view.onShowPhotoAlbum(file);
    }
}

