package com.zoyi.channel.plugin.android.util.message_format.message;

import android.text.Spannable;
import android.text.SpannableStringBuilder;

import com.zoyi.channel.plugin.android.util.L;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by jerry on 2018. 6. 5..
 */

public class MentionMessage implements MessagePattern {

  private Pattern mentionPattern = Pattern.compile("<@[a-zA-Z0-9]+(:[\\d]+)?>");

  @Override
  public SpannableStringBuilder parse(SpannableStringBuilder span) {
    Matcher matcher = mentionPattern.matcher(span);

    while (matcher.find()) {
      try {
        int start = matcher.start();
        int end = matcher.end();
        int center;

        String plainText = span.toString();

        center = plainText.substring(start).indexOf(':');
        if (center != -1 && start + center < end) {
          center += start;
          span.delete(center, end - 1);
          center++;
        } else {
          center = end;
        }

        span.delete(center - 1, center);
        span.delete(start, start + 1);

        matcher = mentionPattern.matcher(span);

      } catch (IndexOutOfBoundsException indexException) {
        L.e(indexException.getMessage());
        return span;
      }
    }
    return span;
  }
}

