/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint.network;

import com.splunk.mint.ActionNetwork;
import com.splunk.mint.Logger;
import com.splunk.mint.Properties;
import com.splunk.mint.network.Counter;
import com.splunk.mint.network.Metric;
import com.splunk.mint.network.MonitorRegistry;
import com.splunk.mint.network.NetLogManager$StartConnectionInfo;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;

public class NetLogManager {
    private static final long CONNECTION_TIMEOUT = 60000L;
    private static volatile HashMap<String, NetLogManager$StartConnectionInfo> connectionsMap = new HashMap();
    private static NetLogManager mNetLogManager = null;

    public static synchronized String exceptionToString(Throwable throwable) {
        if (throwable == null) {
            return "NA";
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    public synchronized void startNetworkCall(String string, String string2, long l2, String string3) {
        if (string != null) {
            string = this.cleanUrl(string);
            boolean bl = this.checkIfURLisExcluded(string2);
            if (!bl) {
                NetLogManager$StartConnectionInfo netLogManager$StartConnectionInfo = new NetLogManager$StartConnectionInfo(this);
                new NetLogManager$StartConnectionInfo(this).startTime = l2;
                netLogManager$StartConnectionInfo.url = string2;
                netLogManager$StartConnectionInfo.protocol = string3;
                connectionsMap.put(string, netLogManager$StartConnectionInfo);
                this.removeOldEntries();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void endNetworkCall(MonitorRegistry object, String object22, long l2, int n2) {
        if (object22 != null) {
            NetLogManager$StartConnectionInfo netLogManager$StartConnectionInfo;
            String string = this.cleanUrl((String)object22);
            if (connectionsMap != null && connectionsMap.containsKey(string) && (netLogManager$StartConnectionInfo = connectionsMap.get(string)) != null) {
                void var5_7;
                void var3_6;
                connectionsMap.remove(string);
                Long l3 = 0L;
                long l4 = 0L;
                for (Metric<?> metric : ((MonitorRegistry)((Object)object)).getMetricsForName(string)) {
                    if (!(metric instanceof Counter)) continue;
                    if (((Counter)metric).getName().endsWith("-bytes-out")) {
                        l3 = (Long)metric.getValue();
                        continue;
                    }
                    if (!((Counter)metric).getName().endsWith("-bytes-in")) continue;
                    l4 = (Long)metric.getValue();
                }
                ActionNetwork.logNetwork(netLogManager$StartConnectionInfo.url, netLogManager$StartConnectionInfo.startTime, (long)var3_6, netLogManager$StartConnectionInfo.protocol, (int)var5_7, String.valueOf(l3), String.valueOf(l4), null, null);
            }
        }
    }

    public synchronized void cancelNetworkCall(MonitorRegistry object, String string, long l2, String string2, String string3) {
        if (string != null) {
            string = this.cleanUrl(string);
            if (connectionsMap != null && connectionsMap.containsKey(string) && (object = connectionsMap.get(string)) != null) {
                connectionsMap.remove(string);
                ActionNetwork.logNetwork(((NetLogManager$StartConnectionInfo)object).url, ((NetLogManager$StartConnectionInfo)object).startTime, l2, string2, 0, "NA", "NA", string3, null);
            }
        }
    }

    public synchronized void logNetworkRequest(String string, String string2, long l2, long l3, int n2, long l4, long l5, String string3, HashMap<String, Object> hashMap) {
        boolean bl = this.checkIfURLisExcluded(string);
        if (!bl) {
            ActionNetwork.logNetwork(string, l2, l3, string2, n2, String.valueOf(l4), String.valueOf(l5), string3, hashMap);
        }
    }

    private synchronized void removeOldEntries() {
        Iterator<Map.Entry<String, NetLogManager$StartConnectionInfo>> iterator = connectionsMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, NetLogManager$StartConnectionInfo> entry = iterator.next();
            long l2 = entry.getValue().startTime;
            if (System.currentTimeMillis() - l2 <= 60000L) continue;
            iterator.remove();
        }
    }

    public static synchronized NetLogManager getInstance() {
        if (mNetLogManager == null) {
            mNetLogManager = new NetLogManager();
        }
        return mNetLogManager;
    }

    private boolean checkIfURLisExcluded(String string) {
        if (string == null) {
            return true;
        }
        if (Properties.excludedUrls != null) {
            string = this.cleanUrl(string);
            for (String string2 : Properties.excludedUrls) {
                if (!string.contains(string2)) continue;
                return true;
            }
        }
        return false;
    }

    private String cleanUrl(String string) {
        if (string != null) {
            string = string.toLowerCase();
            string = string.replaceAll("https://", "");
            string = string.replaceAll("http://", "");
            string = string.replaceAll("www.", "");
        }
        return string;
    }

    public static boolean deviceSupporsNetworkMonitoring() {
        try {
            GenericDeclaration genericDeclaration = Class.forName("java.net.PlainSocketImpl");
            if (genericDeclaration == null) {
                return false;
            }
            if ((genericDeclaration = ((Class)genericDeclaration).getDeclaredConstructor(new Class[0])) == null) {
                return false;
            }
            ((Constructor)genericDeclaration).newInstance(new Object[0]);
            Logger.logInfo("Device supports Network Monitoring");
            return true;
        }
        catch (RuntimeException runtimeException) {
            Logger.logInfo("deviceSupporsNetworkMonitoring: " + runtimeException.getMessage());
        }
        catch (Exception exception) {
            Logger.logInfo("deviceSupporsNetworkMonitoring: " + exception.getMessage());
        }
        return false;
    }

    public static final int getStatusCodeFromURLConnection(URLConnection uRLConnection) {
        int n2 = 0;
        if (uRLConnection != null) {
            if (uRLConnection instanceof HttpURLConnection) {
                try {
                    n2 = ((HttpURLConnection)uRLConnection).getResponseCode();
                }
                catch (Exception exception) {}
            } else if (uRLConnection instanceof HttpsURLConnection) {
                try {
                    n2 = ((HttpsURLConnection)uRLConnection).getResponseCode();
                }
                catch (Exception exception) {}
            }
        }
        return n2;
    }
}

