/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint;

import android.content.Context;
import android.content.SharedPreferences;
import com.splunk.mint.Properties;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Random;

class UidManager {
    private static final String UID_PREFERENCES = "UIDPREFERENCES";
    private static final String UID_FIELD = "UID_FIELD";
    private static final String UID_ERROR_ID = "12345678901234567890123456789012";
    private static final String UID_NOSAVED = "UID_NOSAVED";
    private static final int UID_CORRECT_LENTH = 32;
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    UidManager() {
    }

    protected static final String getUid(Context context) {
        SharedPreferences sharedPreferences;
        if (Properties.UID != null && Properties.UID.length() == 32) {
            return Properties.UID;
        }
        String string = UID_ERROR_ID;
        if (context != null && (sharedPreferences = context.getSharedPreferences(UID_PREFERENCES, 0)) != null) {
            string = sharedPreferences.getString(UID_FIELD, UID_NOSAVED);
        }
        if (string.equals(UID_NOSAVED) || string.equals(UID_ERROR_ID)) {
            string = UidManager.generateUid();
            UidManager.saveUid(context, string);
        }
        return string;
    }

    protected static void saveUid(Context context, String string) {
        if (string != null && string.length() == 32) {
            Properties.UID = string;
            if ((context = context.getSharedPreferences(UID_PREFERENCES, 0)) != null) {
                context.edit().putString(UID_FIELD, string).apply();
            }
        }
    }

    private static final String generateUid() {
        Object object = Long.valueOf(new Date().getTime()).toString();
        Object object2 = new Object().toString();
        long l2 = System.nanoTime();
        Object object3 = String.valueOf(l2);
        String string = Integer.toString((int)(new Random(System.currentTimeMillis()).nextDouble() * 65535.0));
        object = (String)object + (String)object2 + (String)object3 + string + "android_id";
        object2 = null;
        try {
            object3 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            try {
                object3 = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                object3 = null;
            }
        }
        if (object3 != null) {
            try {
                object = ((String)object).getBytes("UTF-8");
                object2 = ((MessageDigest)object3).digest((byte[])object);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                object = unsupportedEncodingException;
                unsupportedEncodingException.printStackTrace();
            }
            return new String(UidManager.encodeHex((byte[])object2));
        }
        return UID_ERROR_ID;
    }

    private static final char[] encodeHex(byte[] byArray) {
        int n2 = byArray.length;
        char[] cArray = new char[n2 << 1];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            cArray[n3++] = DIGITS[(0xF0 & byArray[i2]) >>> 4];
            cArray[n3++] = DIGITS[0xF & byArray[i2]];
        }
        return cArray;
    }
}

