/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint;

import android.content.Context;
import com.splunk.mint.BaseDTO;
import com.splunk.mint.DataSaver;
import com.splunk.mint.InterfaceDataType;
import com.splunk.mint.LastPing;
import com.splunk.mint.Logger;
import com.splunk.mint.MintLogLevel;
import com.splunk.mint.MintUrls;
import com.splunk.mint.NetSender;
import com.splunk.mint.NetSenderResponse;
import com.splunk.mint.Properties;
import com.splunk.mint.Properties$RemoteSettingsProps;
import com.splunk.mint.RemoteSettings;
import com.splunk.mint.RemoteSettingsData;
import com.splunk.mint.Utils;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

class ActionEvent
extends BaseDTO
implements InterfaceDataType {
    private Long gnipTimestamp = null;
    protected String eventName = "";
    protected Integer eventLevel = null;
    protected long duration = -1L;

    public ActionEvent(byte by, String string, Integer n2, HashMap<String, Object> hashMap, Long l2) {
        this(by, string, n2, hashMap, l2, null);
    }

    public ActionEvent(byte by, String string, Integer n2, HashMap<String, Object> hashMap, Long l2, String string2) {
        super(by, hashMap, string2);
        this.eventName = string;
        this.eventLevel = n2;
        if (by == 3) {
            this.gnipTimestamp = l2;
        }
    }

    public static final ActionEvent createEvent(String string) {
        return new ActionEvent(1, string, Utils.convertLoggingLevelToInt(MintLogLevel.Verbose), null, null);
    }

    public static final ActionEvent createEvent(String string, MintLogLevel mintLogLevel, HashMap<String, Object> hashMap) {
        return new ActionEvent(1, string, Utils.convertLoggingLevelToInt(mintLogLevel), hashMap, null);
    }

    public static final ActionEvent createPing() {
        ActionEvent actionEvent = new ActionEvent(2, null, null, null, null);
        return actionEvent;
    }

    public static final ActionEvent createGnip(Context context) {
        ActionEvent actionEvent = new ActionEvent(3, null, null, null, null);
        new ActionEvent(3, null, null, null, null).duration = actionEvent.timestampMilis - LastPing.getLastPingSentTime(context);
        return actionEvent;
    }

    public static final ActionEvent createGnip(Context context, Long object, String string) {
        object = new ActionEvent(3, null, null, null, (Long)object, string);
        v0.duration = ((ActionEvent)object).timestampMilis - LastPing.getLastPingSentTime(context);
        return object;
    }

    @Override
    public String toJsonLine() {
        JSONObject jSONObject = this.getBasicDataFixtureJson();
        try {
            if (this.duration != -1L) {
                if (this.duration > 1000000000000L) {
                    this.duration = 1L;
                }
                jSONObject.put("ses_duration", this.duration);
            }
            if (this.eventName != null) {
                jSONObject.put("event_name", (Object)this.eventName);
            }
            if (this.eventLevel != null) {
                jSONObject.put("level", (Object)this.eventLevel);
            }
            if (this.type == 2) {
                jSONObject.put("rooted", Properties.HAS_ROOT);
                jSONObject.put("fsEncrypted", (Object)Properties.ISFSENCRYPTED);
            }
        }
        catch (JSONException jSONException) {
            JSONException jSONException2 = jSONException;
            jSONException.printStackTrace();
        }
        if (this.type == 3 && this.gnipTimestamp != null) {
            return jSONObject.toString() + Properties.getSeparator(this.type, String.valueOf(this.gnipTimestamp));
        }
        return jSONObject.toString() + Properties.getSeparator(this.type);
    }

    @Override
    public void send(Context context, boolean bl) {
        if (this.type == 2) {
            Object object;
            NetSenderResponse netSenderResponse;
            if (Properties.hecEnabled) {
                netSenderResponse = NetSender.sendBlocking(MintUrls.getURL(), this.toJsonLine(), bl);
            } else {
                object = new StringBuilder();
                ((StringBuilder)object).append(MintUrls.getURL(0, 1));
                ((StringBuilder)object).append("?hash=");
                ((StringBuilder)object).append(Properties$RemoteSettingsProps.hashCode);
                netSenderResponse = NetSender.sendBlocking(((StringBuilder)object).toString(), this.toJsonLine(), bl);
            }
            object = RemoteSettings.convertJsonToRemoteSettings(netSenderResponse.getServerResponse());
            if (object != null) {
                RemoteSettings.saveAndLoadRemoteSettings(context, (RemoteSettingsData)object);
            }
            return;
        }
        NetSender.send(this.toJsonLine(), bl);
    }

    @Override
    public void save() {
        if (this.eventLevel != null && this.eventLevel < Properties$RemoteSettingsProps.eventLevel) {
            Logger.logInfo("Event's level is lower than the minimum level from Remote Settings, event will not be saved");
            return;
        }
        DataSaver.save(this.toJsonLine());
    }

    @Override
    public void send(boolean bl) {
        NetSender.send(this.toJsonLine(), bl);
    }
}

