/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android;

import android.app.Application;
import android.content.Context;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.text.TextUtils;
import com.splunk.mint.Mint;
import com.zoyi.channel.plugin.android.ActivityLifecycleManager;
import com.zoyi.channel.plugin.android.ChannelException;
import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.CheckIn;
import com.zoyi.channel.plugin.android.OnChannelPluginChangedListener;
import com.zoyi.channel.plugin.android.OnChatListener;
import com.zoyi.channel.plugin.android.OnCheckInListener;
import com.zoyi.channel.plugin.android.OnGuestUpdatedListener;
import com.zoyi.channel.plugin.android.activity.chat.ChatManager;
import com.zoyi.channel.plugin.android.activity.userchat_list.UserChatListActivity;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.event.CommandBus;
import com.zoyi.channel.plugin.android.event.LauncherBus;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.global.CheckInPrefSupervisor;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Event;
import com.zoyi.channel.plugin.android.model.wrapper.PackageWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.PluginWrapper;
import com.zoyi.channel.plugin.android.network.ChannelApi;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.network.ServiceFactory;
import com.zoyi.channel.plugin.android.push.ChannelPushManager;
import com.zoyi.channel.plugin.android.socket.SocketManager;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.RequestUtils;
import com.zoyi.okhttp3.RequestBody;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.schedulers.Schedulers;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;

public class ChannelPlugin {
    private static final String MINT_DEBUG_KEY = "e72f17f4";
    private static final String MINT_PROD_KEY = "22464da6";
    private static boolean isDebugMode = false;
    private static boolean isEnabledTrackDefaultEvent = true;
    private static ChannelPlugin channelPlugin;
    private static ChannelApi channelApi;
    private static OnChatListener onChatListener;
    private Application application;
    private String pluginKey;
    private Thread.UncaughtExceptionHandler mUncaughtExceptionHandler;
    private AtomicInteger checkInCounter = new AtomicInteger(0);
    private ActivityLifecycleManager activityLifecycleManager;

    public static void initialize(Application application, String pluginId) {
        ChannelPlugin.initialize(application, pluginId, false, true);
    }

    public static void initialize(Application application, String pluginId, boolean debugMode) {
        ChannelPlugin.initialize(application, pluginId, debugMode, true);
    }

    public static void initialize(Application application, String pluginId, boolean debugMode, boolean enabledTrackDefaultEvent) {
        if (channelPlugin != null) {
            L.i("Channel plugin already initialized");
            return;
        }
        if (application == null) {
            L.e("Application cannot be null");
            return;
        }
        if (pluginId == null) {
            L.e("Plugin key cannot be null");
            return;
        }
        isDebugMode = debugMode;
        isEnabledTrackDefaultEvent = enabledTrackDefaultEvent;
        channelPlugin = new ChannelPlugin(application, pluginId);
    }

    private ChannelPlugin(Application application, String pluginKey) {
        this.application = application;
        this.pluginKey = pluginKey;
        this.activityLifecycleManager = new ActivityLifecycleManager();
        ChannelStore.create(application, pluginKey);
        SocketManager.create(application);
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.activityLifecycleManager);
        this.mUncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable ex) {
                if (Looper.getMainLooper().getThread() == thread) {
                    ChannelPlugin.this.mUncaughtExceptionHandler.uncaughtException(thread, ex);
                } else if (ex instanceof RejectedExecutionException) {
                    SocketManager.reconnect();
                }
            }
        });
    }

    public static void checkIn() {
        ChannelPlugin.checkIn(null, null);
    }

    public static void checkIn(OnCheckInListener listener) {
        ChannelPlugin.checkIn(null, listener);
    }

    public static void checkIn(CheckIn checkIn) {
        ChannelPlugin.checkIn(checkIn, null);
    }

    public static void checkIn(CheckIn checkIn, OnCheckInListener listener) {
        if (ChannelPlugin.isInitialized()) {
            if (!ChannelPlugin.isDataStored()) {
                channelPlugin.checkVersion(checkIn, listener);
            } else if (listener != null) {
                listener.onFailed(new ChannelException(ChannelException.StatusCode.ALREADY_CHECKED_IN, "Already checked in. Please check out and try again."));
            }
        } else if (listener != null) {
            listener.onFailed(new ChannelException(ChannelException.StatusCode.NOT_INITIALIZED, "Please initialize first"));
        }
    }

    private void checkVersion(final CheckIn checkIn, final OnCheckInListener listener) {
        final int counter = this.checkInCounter.incrementAndGet();
        ChannelPlugin.getApi().getLastestPackage("com.zoyi.channel.plugin.android", "2.3.1").subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<PackageWrapper>(){

            @Override
            public void onError(Throwable error) {
                if (counter != ChannelPlugin.this.checkInCounter.get()) {
                    return;
                }
                if (listener != null) {
                    listener.onFailed(new ChannelException(ChannelException.StatusCode.NETWORK_TIMEOUT, error.getMessage()));
                }
            }

            @Override
            public void onNext(PackageWrapper wrapper) {
                if (counter != ChannelPlugin.this.checkInCounter.get()) {
                    return;
                }
                if (!wrapper.isNeedToUpgrade()) {
                    if (!CompareUtils.isSame(wrapper.getVersionString(), "2.3.1")) {
                        L.i("Newest version is: " + wrapper.getVersionString());
                    }
                    ChannelPlugin.this.checkInProcess(checkIn, listener, counter);
                } else if (listener != null) {
                    listener.onFailed(new ChannelException(ChannelException.StatusCode.NOT_AVAILABLE_VERSION, "Need to upgrade, Minimum version is: " + wrapper.getMinCompatibleVersion()));
                }
            }
        });
    }

    private void checkInProcess(final CheckIn checkIn, final OnCheckInListener listener, final int counter) {
        HashMap<String, Object> form = new HashMap<String, Object>();
        if (checkIn != null) {
            form.put("name", checkIn.getName());
            form.put("mobileNumber", checkIn.getMobileNumber());
            form.put("avatarUrl", checkIn.getAvatarUrl());
            form.put("meta", checkIn.getMeta());
        }
        RequestBody body = RequestUtils.form(form).create();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (checkIn != null && checkIn.getUserId() != null) {
            headers.put("X-User-Id", checkIn.getUserId());
        }
        if (PrefSupervisor.getVeilId((Context)this.application) != null) {
            headers.put("X-Veil-Id", PrefSupervisor.getVeilId((Context)this.application));
        }
        ChannelPlugin.getApi().checkIn(headers, this.pluginKey, null, body).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<PluginWrapper>(){

            @Override
            public void onError(Throwable e) {
                if (counter != ChannelPlugin.this.checkInCounter.get()) {
                    return;
                }
                L.e(e.getMessage());
                if (listener != null) {
                    ChannelException.StatusCode code = ChannelException.StatusCode.CHECK_IN_ERROR;
                    if (e instanceof RetrofitException) {
                        switch (((RetrofitException)e).getKind()) {
                            case HTTP: {
                                code = ChannelException.StatusCode.CHECK_IN_ERROR;
                                break;
                            }
                            case NETWORK: {
                                code = ChannelException.StatusCode.NETWORK_TIMEOUT;
                                break;
                            }
                            case UNEXPECTED: {
                                code = ChannelException.StatusCode.UNKNOWN;
                            }
                        }
                    }
                    listener.onFailed(new ChannelException(code, e.getMessage()));
                }
            }

            @Override
            public void onNext(PluginWrapper pluginWrapper) {
                if (counter != ChannelPlugin.this.checkInCounter.get()) {
                    return;
                }
                ChannelPlugin.this.initBugTracking(pluginWrapper.getChannel());
                if (checkIn == null) {
                    CheckInPrefSupervisor.setVeil((Context)ChannelPlugin.this.application, pluginWrapper.getVeil());
                } else {
                    CheckInPrefSupervisor.set((Context)ChannelPlugin.this.application, checkIn);
                }
                ChannelStore.checkIn(pluginWrapper);
                if (!ChannelStore.isWorking()) {
                    return;
                }
                ChannelPushManager.sendTokenToChannelPlugin((Context)ChannelPlugin.this.application);
                SocketManager.setChannelId(pluginWrapper.getChannel().getId());
                SocketManager.connect();
                RxBus.post(new CommandBus(Command.CHECKED_IN, pluginWrapper.getPlugin()));
                if (isEnabledTrackDefaultEvent) {
                    ChannelPlugin.track((Context)ChannelPlugin.this.application, "CheckIn", null);
                }
                if (listener != null) {
                    listener.onSuccessed();
                }
            }
        });
    }

    public static void checkOut() {
        if (ChannelPlugin.isInitialized()) {
            channelPlugin.checkOutProcess();
        }
    }

    private void checkOutProcess() {
        this.checkInCounter.incrementAndGet();
        ChannelPushManager.deleteToken((Context)this.application);
        CheckInPrefSupervisor.clear((Context)this.application);
        ChannelStore.clear();
        RxBus.post(new CommandBus(Command.CHECKED_OUT));
        SocketManager.setChannelId(null);
        SocketManager.disconnect();
        ChatManager.release();
        this.releaseBugTracking();
    }

    @Deprecated
    public static boolean launch(@NonNull Context context) {
        return ChannelPlugin.show(context);
    }

    public static boolean show(@NonNull Context context) {
        if (!ChannelPlugin.isInitialized() || !ChannelPlugin.isDataStored()) {
            L.e("Please check in first");
            return false;
        }
        if (!ChannelStore.isWorking()) {
            L.e("This plugin is in a hidden state");
            return false;
        }
        for (OnChannelPluginChangedListener l : ChannelStore.getOnChannelPluginChangedListeners()) {
            if (l == null) continue;
            l.willShowChatList();
        }
        IntentUtils.setNextActivity(context, UserChatListActivity.class).startActivity();
        return true;
    }

    public static void hide() {
        if (ChannelPlugin.isInitialized()) {
            channelPlugin.finishAll();
        }
    }

    private void finishAll() {
        if (this.activityLifecycleManager != null) {
            this.activityLifecycleManager.finish();
        }
    }

    public static void showLauncher() {
        RxBus.post(new LauncherBus(true));
    }

    public static void hideLauncher() {
        RxBus.post(new LauncherBus(false));
    }

    public static ChannelApi getApi() {
        if (channelApi == null) {
            channelApi = ServiceFactory.create();
        }
        return channelApi;
    }

    @Nullable
    public static String getPluginKey() {
        if (channelPlugin == null) {
            return null;
        }
        return ChannelPlugin.channelPlugin.pluginKey;
    }

    private void initBugTracking(Channel channel) {
        if (this.application != null) {
            Mint.disableNetworkMonitoring();
            Mint.initAndStartSession((Application)this.application, (String)MINT_PROD_KEY);
            Mint.addExtraData((String)"plugin_version", (String)"2.3.1");
            if (channel != null) {
                Mint.addExtraData((String)"channel_id", (String)channel.getId());
                Mint.addExtraData((String)"channel_name", (String)channel.getName());
            }
        }
    }

    private void releaseBugTracking() {
        if (this.application != null) {
            Mint.clearExtraData();
            Mint.closeSession((Application)this.application);
            Mint.flush();
        }
    }

    public static boolean isInitialized() {
        if (channelPlugin == null) {
            L.e("Please initialize first");
            return false;
        }
        return true;
    }

    public static boolean isDebugMode() {
        return isDebugMode;
    }

    public static boolean isEnabledTrackDefaultEvent() {
        return isEnabledTrackDefaultEvent;
    }

    public static boolean isDataStored() {
        return ChannelStore.isDataStored();
    }

    public static void updateGuest() {
        ChannelPlugin.updateGuest(null);
    }

    public static void updateGuest(OnGuestUpdatedListener listener) {
        ChannelStore.fetchMe(listener);
    }

    public static void addOnChannelPluginChangedListener(OnChannelPluginChangedListener listener) {
        ChannelStore.addOnChannelPluginChangedListener(listener);
    }

    public static void removeOnChannelPluginChangedListener(OnChannelPluginChangedListener listener) {
        ChannelStore.removeOnChannelPluginChangedListener(listener);
    }

    public static void track(@NonNull Context context, @NonNull @Size(min=1L, max=30L) String name, @Nullable Map<String, Object> property) {
        if (TextUtils.isEmpty((CharSequence)name) || name.length() > 30) {
            return;
        }
        ChannelPlugin.track(new Event(context, name, property));
    }

    private static void track(@NonNull Event event) {
        ChannelPlugin.getApi().trackEvent(event).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe(new RestSubscriber());
    }

    public static void setOnChatListener(@NonNull OnChatListener listener) {
        if (ChannelPlugin.isInitialized()) {
            onChatListener = listener;
        }
    }

    @Nullable
    public static OnChatListener getOnChatListener() {
        return onChatListener;
    }

    static {
        onChatListener = null;
    }
}

