package com.zoyi.channel.plugin.android.model.rest;

import android.graphics.Color;

import com.zoyi.channel.plugin.android.model.interfaces.PersonEntity;
import com.zoyi.channel.plugin.android.model.interfaces.ProfileEntity;

/**
 * Created by mika on 2017. 1. 16..
 */
public class User implements PersonEntity {
  private String channelId;
  private String id;
  private String name;
  private String mobileNumber;
  private String avatarUrl;
  private Object meta;
  private Boolean ghost;
  private String locale;
  private String country;
  private String city;
  private String lastPageViewId;
  private Long pageViewsCount;
  private Long visitsCount;
  private Long createdAt;
  private Long updatedAt;
  private Long version;
  private String initial;
  private String color;
  private int alert;

  public String getId() {
    return id;
  }

  public String getName() {
    return name;
  }

  @Override
  public String getPersonType() {
    return this.getClass().getSimpleName();
  }

  @Override
  public int getBackgroundColor() {
    try {
      return Color.parseColor(color);
    } catch (Exception ex) {
    }
    return Color.BLACK;
  }

  @Override
  public int getTextColor() {
    return Color.WHITE;
  }

  @Override
  public String getAvatarUrl() {
    return avatarUrl;
  }

  @Override
  public String getInitial() {
    return initial;
  }

  @Override
  public boolean isHost() {
    return false;
  }

  public String getMobileNumber() {
    return mobileNumber;
  }

  public final static String CLASSNAME = "User";

  public Boolean isGhost() {
    return ghost;
  }

  public int getAlert() {
    return alert;
  }
}
