/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.settings;

import android.graphics.Color;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.util.Executor;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.layout.ChannelLayout;

public class SettingsHeaderFragment
extends Fragment
implements View.OnClickListener {
    private ChannelLayout layoutChannelImage;
    private TextView textChannelName;
    private TextView textChannelPhoneNumber;

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.ch_plugin_fragment_settings_header, container, false);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        Channel channel = ChannelStore.getChannel();
        Plugin plugin = ChannelStore.getPlugin();
        if (channel != null && plugin != null) {
            this.layoutChannelImage = (ChannelLayout)view.findViewById(R.id.layout_channel_image);
            this.textChannelName = (TextView)view.findViewById(R.id.tv_channel_name);
            this.textChannelPhoneNumber = (TextView)view.findViewById(R.id.tv_channel_phone_number);
            view.setBackgroundColor(Color.parseColor((String)plugin.getBorderColor()));
            this.setChannelImage(channel, plugin);
            this.textChannelName.setText((CharSequence)channel.getName());
            this.textChannelName.setTextColor(plugin.getTextColor());
            this.textChannelPhoneNumber.setText((CharSequence)channel.getPhoneNumber());
            this.textChannelPhoneNumber.setOnClickListener((View.OnClickListener)this);
            this.textChannelPhoneNumber.setVisibility(UIUtils.getVisible(!TextUtils.isEmpty((CharSequence)channel.getPhoneNumber()), true));
            this.setChannelNameMargin();
        }
    }

    private void setChannelNameMargin() {
        LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)this.textChannelName.getLayoutParams();
        params.bottomMargin = this.textChannelPhoneNumber.getVisibility() == 0 ? (int)Utils.dpToPx(this.getContext(), 6.0f) : (int)Utils.dpToPx(this.getContext(), 24.0f);
        this.textChannelName.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    private void setChannelImage(Channel channel, Plugin plugin) {
        if (TextUtils.isEmpty((CharSequence)channel.getAvatarUrl())) {
            this.layoutChannelImage.set(channel, plugin);
        } else {
            this.layoutChannelImage.set(channel);
        }
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.tv_channel_phone_number) {
            Executor.call(this.getContext(), this.textChannelPhoneNumber.getText().toString());
        }
    }
}

