/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.userchat_list;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.activity.chat.ChatActivity;
import com.zoyi.channel.plugin.android.activity.settings.SettingsActivity;
import com.zoyi.channel.plugin.android.activity.userchat_list.UserChatListAdapter;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.ChannelModel;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatsWrapper;
import com.zoyi.channel.plugin.android.presenter.userchat.UserChatContract;
import com.zoyi.channel.plugin.android.presenter.userchat.UserChatPresenter;
import com.zoyi.channel.plugin.android.socket.SocketManager;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.external.fab.FloatingActionButton;
import com.zoyi.channel.plugin.android.view.handler.AlertDialogListener;
import com.zoyi.channel.plugin.android.view.handler.InfiniteScrollListener;
import com.zoyi.channel.plugin.android.view.layout.BigBar;
import com.zoyi.channel.plugin.android.view.layout.MenuButton;

public class UserChatListActivity
extends BaseActivity
implements View.OnClickListener,
UserChatContract.View {
    private View emptyLayout;
    private RecyclerView recyclerView;
    private FloatingActionButton fab;
    private View reconnectLayout;
    private String tempChatId;
    private UserChatListAdapter adapter;
    private boolean showingChat = false;
    private boolean removeMode = false;
    private boolean isRefreshUserChat = false;
    private boolean isRemoveUserChat = false;
    private UserChatContract.Presenter presenter;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.init(R.layout.ch_plugin_activity_user_chat_list);
        if (this.getIntent() != null) {
            this.tempChatId = this.getIntent().getStringExtra("chatId");
        }
        this.emptyLayout = this.findViewById(R.id.layout_empty);
        this.reconnectLayout = this.findViewById(R.id.layout_reconnect);
        this.fab = (FloatingActionButton)this.findViewById(R.id.fab);
        this.fab.setOnClickListener(this);
        this.fab.hide(false);
        this.getBigBar().withActivity(this).addMenu(MenuButton.ActionType.EXIT, BigBar.MenuPosition.LEFT).addMenu(MenuButton.ActionType.REFRESH, BigBar.MenuPosition.RIGHT, MenuButton.MenuState.HIDDEN).addMenu(MenuButton.ActionType.MORE, BigBar.MenuPosition.RIGHT, MenuButton.MenuState.HIDDEN).addMenu(MenuButton.ActionType.DELETE, BigBar.MenuPosition.RIGHT, MenuButton.MenuState.HIDDEN).build();
        this.adapter = new UserChatListAdapter();
        this.presenter = new UserChatPresenter((Context)this);
        this.presenter.setView(this);
        this.presenter.setAdapterView(this.adapter);
        this.presenter.setAdapterModel(this.adapter);
        LinearLayoutManager manager = new LinearLayoutManager((Context)this);
        this.recyclerView = (RecyclerView)this.findViewById(R.id.recycler_view);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)manager);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
        this.recyclerView.setItemAnimator(null);
        this.recyclerView.getRecycledViewPool().setMaxRecycledViews(0, 40);
        this.recyclerView.addOnScrollListener((RecyclerView.OnScrollListener)new InfiniteScrollListener(manager, -1){

            @Override
            public void refresh() {
            }
        });
        if (SocketManager.isError()) {
            this.setRefreshVisibility(true);
            this.setReconnectVisibility(true);
        }
        this.setStyle();
        this.presenter.getUserChats();
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == 22 && this.adapter.getItemCount() == 0) {
            this.finish();
        }
        block0 : switch (requestCode) {
            case 3002: {
                switch (resultCode) {
                    case 25: {
                        this.refreshUserChat();
                        break;
                    }
                    case 23: {
                        this.setRemoveMode(data);
                    }
                }
                break;
            }
            case 21: {
                this.showingChat = false;
                switch (resultCode) {
                    case 24: {
                        this.startChat(null, this.presenter.getChatCount(null), false);
                        break block0;
                    }
                    case 25: {
                        this.refreshUserChat();
                        break block0;
                    }
                    case 23: {
                        this.setRemoveMode(data);
                    }
                }
            }
        }
    }

    protected void onStart() {
        this.presenter.setRunningChatId(null);
        super.onStart();
    }

    public void onBackPressed() {
        if (this.removeMode) {
            this.setRemoveMode(false);
        } else {
            super.onBackPressed();
        }
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.fab) {
            this.startChat(null, this.presenter.getChatCount(null), this.adapter.getItemCount() == 0);
        }
    }

    @Override
    public void optionClicked(MenuButton.ActionType actionType) {
        switch (actionType) {
            case EXIT: {
                if (!this.removeMode) break;
                this.setRemoveMode(false);
                return;
            }
            case REFRESH: {
                this.getBigBar().setMenuState(MenuButton.ActionType.REFRESH, MenuButton.MenuState.HIDDEN);
                this.presenter.refresh();
                break;
            }
            case MORE: {
                IntentUtils.setNextActivity((Context)this, SettingsActivity.class).startActivityForResult(3002);
                break;
            }
            case DELETE: {
                UIUtils.showAlertDialog((Context)this, ResUtils.getString((Context)this, "ch.chat.delete_description"), true, new AlertDialogListener(){

                    @Override
                    public void onPositive() {
                        UserChatListActivity.this.presenter.requestRemoveChats();
                    }
                });
            }
        }
        super.optionClicked(actionType);
    }

    private void setStyle() {
        Channel channel = ChannelStore.getChannel();
        Plugin plugin = ChannelStore.getPlugin();
        if (channel == null || plugin == null) {
            this.finish();
        } else {
            this.setStatusBarColor(plugin.getBackgroundColor());
            this.getBigBar().setTheme(plugin.getBackgroundColor(), plugin.getTextColor());
            this.getBigBar().setTitle(channel.getName());
            this.fab.setColorNormal(plugin.getBackgroundColor());
            this.fab.setColorPressed(Utils.addBlackMask(plugin.getBackgroundColor()));
            this.fab.setColorRipple(-1);
            this.fab.setImageResource(plugin.getTextColor() == -16777216 ? R.drawable.ch_plugin_ic_add_black_24dp : R.drawable.ch_plugin_ic_add_white_24dp);
            this.fab.attachToRecyclerView(this.recyclerView);
        }
    }

    private void refreshUserChat() {
        this.isRefreshUserChat = true;
        this.presenter.setInit(true);
        this.presenter.getUserChats();
    }

    private void setRemoveMode(Intent data) {
        if (data == null) {
            return;
        }
        if (data.getBooleanExtra("changed_setting", false)) {
            this.isRemoveUserChat = true;
            this.refreshUserChat();
        } else {
            this.setRemoveMode(true);
        }
    }

    private void setRemoveMode(boolean removeMode) {
        this.removeMode = removeMode;
        if (removeMode) {
            if (this.adapter.getItemCount() > 0) {
                this.getBigBar().setTitle(ResUtils.getString((Context)this, "ch.chat.delete_title"));
                this.getBigBar().setMenuState(MenuButton.ActionType.MORE, MenuButton.MenuState.HIDDEN);
                this.getBigBar().setMenuState(MenuButton.ActionType.DELETE, MenuButton.MenuState.DISABLED);
                this.fab.setVisibility(8);
                this.presenter.setEditMode(true);
            } else {
                this.removeMode = false;
            }
        } else {
            Channel channel = ChannelStore.getChannel();
            if (channel != null) {
                this.getBigBar().setTitle(channel.getName());
            }
            this.getBigBar().setMenuState(MenuButton.ActionType.DELETE, MenuButton.MenuState.HIDDEN);
            this.getBigBar().setMenuState(MenuButton.ActionType.MORE, MenuButton.MenuState.VISIBLE);
            this.fab.show();
            this.fab.setVisibility(0);
            this.presenter.setEditMode(false);
        }
    }

    @Override
    public void userChatsFetched(UserChatsWrapper userChatsWrapper) {
        this.getBigBar().setMenuState(MenuButton.ActionType.MORE, MenuButton.MenuState.VISIBLE);
        this.fab.show();
        if (this.tempChatId != null) {
            this.startChat(this.tempChatId, this.presenter.getChatCount(this.tempChatId), false);
            this.tempChatId = null;
        } else if (this.adapter.getItemCount() == 0) {
            if (this.isRefreshUserChat) {
                if (!this.isRemoveUserChat) {
                    this.finish();
                }
                this.isRefreshUserChat = false;
                this.isRemoveUserChat = false;
            } else if (!this.showingChat) {
                this.startChat(null, 0, true);
            }
        } else {
            this.isRefreshUserChat = false;
            if (this.isRemoveUserChat) {
                this.isRemoveUserChat = false;
                this.setRemoveMode(true);
            }
        }
        this.setViewVisibility();
    }

    @Override
    public void startChat(String chatId, int chatCount, boolean chatEmpty) {
        this.showingChat = true;
        IntentUtils.setNextActivity((Context)this, ChatActivity.class).putExtra("chatId", chatId).putExtra("chatCount", chatCount).putExtra("chatEmpty", chatEmpty).startActivityForResult(21);
    }

    @Override
    public void setRefreshVisibility(boolean showRefresh) {
        this.getBigBar().setMenuState(MenuButton.ActionType.REFRESH, showRefresh ? MenuButton.MenuState.VISIBLE : MenuButton.MenuState.HIDDEN);
    }

    @Override
    public void setReconnectVisibility(boolean show) {
        this.reconnectLayout.setVisibility(UIUtils.getVisible(show, true));
    }

    @Override
    public void checkUserChat(boolean hasCheckedChat) {
        this.getBigBar().setMenuState(MenuButton.ActionType.DELETE, hasCheckedChat ? MenuButton.MenuState.VISIBLE : MenuButton.MenuState.DISABLED);
    }

    @Override
    public void deleteChat(final String chatId) {
        UIUtils.showAlertDialog((Context)this, ResUtils.getString((Context)this, "ch.chat.delete_description"), true, new AlertDialogListener(){

            @Override
            public void onPositive() {
                UserChatListActivity.this.presenter.requestRemoveChat(chatId);
            }
        });
    }

    @Override
    public void completeRemoveChat() {
        this.hideProgress();
        this.setRemoveMode(false);
        this.setViewVisibility();
    }

    @Override
    public void receiveCommand(Command command, Object object) {
        this.presenter.receiveCommand(command, object);
    }

    @Override
    public void receiveData(ChannelModel channelModel, boolean upsert) {
        this.presenter.receiveData(channelModel, upsert);
        this.setViewVisibility();
    }

    private void setViewVisibility() {
        this.emptyLayout.setVisibility(UIUtils.getVisible(!this.hasUserChat(), true));
        this.recyclerView.setVisibility(UIUtils.getVisible(this.hasUserChat(), true));
    }

    private boolean hasUserChat() {
        return this.adapter.getItemCount() > 0;
    }
}

