/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.model.etc;

import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.activity.chat.ChatDataDictionary;
import com.zoyi.channel.plugin.android.model.rest.ProfileEntity;

public class Typing {
    public static final long TTL = 30L;
    private String action;
    private String chatId;
    private String chatType;
    private String personId;
    private String personType;
    private Long createdAt;

    public Typing(String action, String chatId, String chatType) {
        this.action = action;
        this.chatId = chatId;
        this.chatType = chatType;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setCreatedAt(Long createdAt) {
        this.createdAt = createdAt;
    }

    public boolean isOther() {
        String myPersonId = ChannelStore.getPersonId();
        return this.personId != null && myPersonId != null && !this.personId.equals(myPersonId);
    }

    public boolean isExpired() {
        return this.createdAt != null && System.currentTimeMillis() - this.createdAt >= 30L;
    }

    public String getKey() {
        return String.format("%s:%s:%s:%s", this.chatId, this.chatType, this.personId, this.personType);
    }

    public ProfileEntity getProfileEntity(ChatDataDictionary dictionary) {
        if (dictionary == null) {
            return null;
        }
        return dictionary.getProfile(this.personType, this.personId);
    }

    public boolean isSameChat(String chatId, String chatType) {
        return this.chatId.equals(chatId) && this.chatType.equals(chatType);
    }

    public boolean equals(Object o) {
        boolean ret = false;
        if (o != null && o instanceof Typing) {
            Typing next = (Typing)o;
            ret = this.chatId.equals(next.chatId) && this.chatType.equals(next.chatType) && this.personId.equals(next.personId) && this.personType.equals(next.personType);
        }
        return ret;
    }
}

