/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.functions.Func1;
import com.zoyi.rx.internal.producers.SingleDelayedProducer;
import com.zoyi.rx.plugins.RxJavaHooks;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OperatorAll<T>
implements Observable.Operator<Boolean, T> {
    final Func1<? super T, Boolean> predicate;

    public OperatorAll(Func1<? super T, Boolean> predicate) {
        this.predicate = predicate;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super Boolean> child) {
        final SingleDelayedProducer<? super Boolean> producer = new SingleDelayedProducer<Boolean>(child);
        Subscriber s = new Subscriber<T>(){
            boolean done;

            @Override
            public void onNext(T t) {
                Boolean result;
                if (this.done) {
                    return;
                }
                try {
                    result = OperatorAll.this.predicate.call(t);
                }
                catch (Throwable e) {
                    Exceptions.throwOrReport(e, this, t);
                    return;
                }
                if (!result.booleanValue()) {
                    this.done = true;
                    producer.setValue(false);
                    this.unsubscribe();
                }
            }

            @Override
            public void onError(Throwable e) {
                if (!this.done) {
                    this.done = true;
                    child.onError(e);
                } else {
                    RxJavaHooks.onError(e);
                }
            }

            @Override
            public void onCompleted() {
                if (!this.done) {
                    this.done = true;
                    producer.setValue(true);
                }
            }
        };
        child.add(s);
        child.setProducer(producer);
        return s;
    }
}

