package com.zoyi.channel.plugin.android.view.layout;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;

import com.zoyi.channel.plugin.android.R;

/**
 * Created by mika on 2016. 2. 2..
 */
public class AvatarLayout extends ProfileLayout {

  public AvatarLayout(Context context) {
    super(context);
    init(context, null);
  }

  public AvatarLayout(Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init(context, attrs);
  }

  public AvatarLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context, attrs);
  }

  @TargetApi(Build.VERSION_CODES.LOLLIPOP)
  public AvatarLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
    super(context, attrs, defStyleAttr, defStyleRes);
    init(context, attrs);
  }

  protected void init(Context context, AttributeSet attrs) {
    super.init(context, LayoutInflater.from(context).inflate(R.layout.ch_plugin_layout_avatar, this), attrs);
  }
}
