package com.zoyi.channel.plugin.android.network;

import com.zoyi.channel.plugin.android.ChannelPlugin;
import com.zoyi.com.google.gson.Gson;
import com.zoyi.okhttp3.OkHttpClient;
import com.zoyi.okhttp3.logging.HttpLoggingInterceptor;
import com.zoyi.retrofit2.Retrofit;
import com.zoyi.retrofit2.adapter.rxjava.RxJavaCallAdapterFactory;
import com.zoyi.retrofit2.converter.gson.GsonConverterFactory;

/**
 * Created by mika on 2016. 1. 20..
 */
public class ServiceFactory {

  static final String ENDPOINT = "https://api.channel.io/";
//  static final String ENDPOINT = "http://api.exp.channel.io/";

  public static ChannelApi create() {
    HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor()
        .setLevel(ChannelPlugin.isDebugMode()
            ? HttpLoggingInterceptor.Level.HEADERS
            : HttpLoggingInterceptor.Level.NONE);
    OkHttpClient client = new OkHttpClient.Builder()
        .addInterceptor(new RetrofitInterceptor())
        .addInterceptor(interceptor)
        .build();

    return new Retrofit.Builder()
        .baseUrl(ENDPOINT)
        .client(client)
        .addCallAdapterFactory(RxJavaCallAdapterFactory.create())
        .addConverterFactory(GsonConverterFactory.create(new Gson()))
        .build()
        .create(ChannelApi.class);
  }
}
