/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.settings;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.widget.SwitchCompat;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;

public class SettingsChatFragment
extends Fragment
implements View.OnClickListener,
CompoundButton.OnCheckedChangeListener {
    private Context context;
    private boolean completed = false;
    private boolean changed = false;

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.ch_plugin_fragment_settings_chat, container, false);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.context = this.getActivity();
        view.findViewById(R.id.tv_chat_close).setOnClickListener((View.OnClickListener)this);
        this.completed = PrefSupervisor.isShownClosedChat(this.context);
        SwitchCompat switchCompleted = (SwitchCompat)view.findViewById(R.id.sw_show_closed_chat);
        switchCompleted.setChecked(this.completed);
        switchCompleted.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this);
        SwitchCompat switchAlarm = (SwitchCompat)view.findViewById(R.id.sw_enable_alarm);
        switchAlarm.setChecked(PrefSupervisor.isEnabledPushAlarm(this.context));
        switchAlarm.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this);
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.tv_chat_close) {
            Intent data = new Intent();
            data.putExtra("changed_setting", this.changed);
            this.getActivity().setResult(23, data);
            this.getActivity().finish();
        }
    }

    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        int id2 = buttonView.getId();
        if (id2 == R.id.sw_show_closed_chat) {
            this.handleShowClosedChat(isChecked);
        }
        if (id2 == R.id.sw_enable_alarm) {
            PrefSupervisor.setPushAlarm(this.context, isChecked);
        }
    }

    private void handleShowClosedChat(boolean isChecked) {
        if (this.completed == isChecked) {
            this.changed = false;
            this.getActivity().setResult(0);
        } else {
            this.changed = true;
            this.getActivity().setResult(25);
        }
        PrefSupervisor.setShowClosedChat(this.context, isChecked);
    }
}

