/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util.io;

import com.zoyi.channel.plugin.android.util.io.IOCase;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Stack;

public class FilenameUtils {
    private static final int NOT_FOUND = -1;
    public static final char EXTENSION_SEPARATOR = '.';
    public static final String EXTENSION_SEPARATOR_STR = Character.toString('.');
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';
    private static final char SYSTEM_SEPARATOR = File.separatorChar;
    private static final char OTHER_SEPARATOR = FilenameUtils.isSystemWindows() ? (char)47 : (char)92;

    static boolean isSystemWindows() {
        return SYSTEM_SEPARATOR == '\\';
    }

    private static boolean isSeparator(char c2) {
        return c2 == '/' || c2 == '\\';
    }

    public static String normalize(String string2) {
        return FilenameUtils.doNormalize(string2, SYSTEM_SEPARATOR, true);
    }

    public static String normalize(String string2, boolean bl) {
        char c2 = bl ? (char)'/' : '\\';
        return FilenameUtils.doNormalize(string2, c2, true);
    }

    public static String normalizeNoEndSeparator(String string2) {
        return FilenameUtils.doNormalize(string2, SYSTEM_SEPARATOR, false);
    }

    public static String normalizeNoEndSeparator(String string2, boolean bl) {
        char c2 = bl ? (char)'/' : '\\';
        return FilenameUtils.doNormalize(string2, c2, false);
    }

    private static String doNormalize(String string2, char c2, boolean bl) {
        int n2;
        if (string2 == null) {
            return null;
        }
        FilenameUtils.failIfNullBytePresent(string2);
        int n3 = string2.length();
        if (n3 == 0) {
            return string2;
        }
        int n4 = FilenameUtils.getPrefixLength(string2);
        if (n4 < 0) {
            return null;
        }
        char[] cArray = new char[n3 + 2];
        string2.getChars(0, string2.length(), cArray, 0);
        int n5 = c2 == SYSTEM_SEPARATOR ? OTHER_SEPARATOR : SYSTEM_SEPARATOR;
        for (n2 = 0; n2 < cArray.length; ++n2) {
            if (cArray[n2] != n5) continue;
            cArray[n2] = c2;
        }
        n2 = 1;
        if (cArray[n3 - 1] != c2) {
            cArray[n3++] = c2;
            n2 = 0;
        }
        for (n5 = n4 + 1; n5 < n3; ++n5) {
            if (cArray[n5] != c2 || cArray[n5 - 1] != c2) continue;
            System.arraycopy(cArray, n5, cArray, n5 - 1, n3 - n5);
            --n3;
            --n5;
        }
        for (n5 = n4 + 1; n5 < n3; ++n5) {
            if (cArray[n5] != c2 || cArray[n5 - 1] != '.' || n5 != n4 + 1 && cArray[n5 - 2] != c2) continue;
            if (n5 == n3 - 1) {
                n2 = 1;
            }
            System.arraycopy(cArray, n5 + 1, cArray, n5 - 1, n3 - n5);
            n3 -= 2;
            --n5;
        }
        block3: for (n5 = n4 + 2; n5 < n3; ++n5) {
            if (cArray[n5] != c2 || cArray[n5 - 1] != '.' || cArray[n5 - 2] != '.' || n5 != n4 + 2 && cArray[n5 - 3] != c2) continue;
            if (n5 == n4 + 2) {
                return null;
            }
            if (n5 == n3 - 1) {
                n2 = 1;
            }
            for (int i2 = n5 - 4; i2 >= n4; --i2) {
                if (cArray[i2] != c2) continue;
                System.arraycopy(cArray, n5 + 1, cArray, i2 + 1, n3 - n5);
                n3 -= n5 - i2;
                n5 = i2 + 1;
                continue block3;
            }
            System.arraycopy(cArray, n5 + 1, cArray, n4, n3 - n5);
            n3 -= n5 + 1 - n4;
            n5 = n4 + 1;
        }
        if (n3 <= 0) {
            return "";
        }
        if (n3 <= n4) {
            return new String(cArray, 0, n3);
        }
        if (n2 != 0 && bl) {
            return new String(cArray, 0, n3);
        }
        return new String(cArray, 0, n3 - 1);
    }

    public static String concat(String string2, String string3) {
        int n2 = FilenameUtils.getPrefixLength(string3);
        if (n2 < 0) {
            return null;
        }
        if (n2 > 0) {
            return FilenameUtils.normalize(string3);
        }
        if (string2 == null) {
            return null;
        }
        n2 = string2.length();
        if (n2 == 0) {
            return FilenameUtils.normalize(string3);
        }
        char c2 = string2.charAt(n2 - 1);
        n2 = c2;
        if (FilenameUtils.isSeparator(c2)) {
            return FilenameUtils.normalize(string2 + string3);
        }
        return FilenameUtils.normalize(string2 + '/' + string3);
    }

    public static boolean directoryContains(String string2, String string3) throws IOException {
        if (string2 == null) {
            throw new IllegalArgumentException("Directory must not be null");
        }
        if (string3 == null) {
            return false;
        }
        if (IOCase.SYSTEM.checkEquals(string2, string3)) {
            return false;
        }
        return IOCase.SYSTEM.checkStartsWith(string3, string2);
    }

    public static String separatorsToUnix(String string2) {
        if (string2 == null || string2.indexOf(92) == -1) {
            return string2;
        }
        return string2.replace('\\', '/');
    }

    public static String separatorsToWindows(String string2) {
        if (string2 == null || string2.indexOf(47) == -1) {
            return string2;
        }
        return string2.replace('/', '\\');
    }

    public static String separatorsToSystem(String string2) {
        if (string2 == null) {
            return null;
        }
        if (FilenameUtils.isSystemWindows()) {
            return FilenameUtils.separatorsToWindows(string2);
        }
        return FilenameUtils.separatorsToUnix(string2);
    }

    public static int getPrefixLength(String string2) {
        if (string2 == null) {
            return -1;
        }
        int n2 = string2.length();
        if (n2 == 0) {
            return 0;
        }
        int n3 = string2.charAt(0);
        if (n3 == 58) {
            return -1;
        }
        if (n2 == 1) {
            if (n3 == 126) {
                return 2;
            }
            if (FilenameUtils.isSeparator((char)n3)) {
                return 1;
            }
            return 0;
        }
        if (n3 == 126) {
            int n4 = string2.indexOf(47, 1);
            n3 = string2.indexOf(92, 1);
            if (n4 == -1 && n3 == -1) {
                return n2 + 1;
            }
            n4 = n4 == -1 ? n3 : n4;
            n3 = n3 == -1 ? n4 : n3;
            return Math.min(n4, n3) + 1;
        }
        char c2 = string2.charAt(1);
        if (c2 == ':') {
            char c3 = Character.toUpperCase((char)n3);
            n3 = c3;
            if (c3 >= 'A' && n3 <= 90) {
                if (n2 == 2 || !FilenameUtils.isSeparator(string2.charAt(2))) {
                    return 2;
                }
                return 3;
            }
            return -1;
        }
        if (FilenameUtils.isSeparator((char)n3) && FilenameUtils.isSeparator(c2)) {
            n3 = string2.indexOf(47, 2);
            int n5 = string2.indexOf(92, 2);
            if (n3 == -1 && n5 == -1 || n3 == 2 || n5 == 2) {
                return -1;
            }
            n3 = n3 == -1 ? n5 : n3;
            n5 = n5 == -1 ? n3 : n5;
            return Math.min(n3, n5) + 1;
        }
        if (FilenameUtils.isSeparator((char)n3)) {
            return 1;
        }
        return 0;
    }

    public static int indexOfLastSeparator(String string2) {
        if (string2 == null) {
            return -1;
        }
        int n2 = string2.lastIndexOf(47);
        int n3 = string2.lastIndexOf(92);
        return Math.max(n2, n3);
    }

    public static int indexOfExtension(String string2) {
        if (string2 == null) {
            return -1;
        }
        int n2 = string2.lastIndexOf(46);
        int n3 = FilenameUtils.indexOfLastSeparator(string2);
        if (n3 > n2) {
            return -1;
        }
        return n2;
    }

    public static String getPrefix(String string2) {
        if (string2 == null) {
            return null;
        }
        int n2 = FilenameUtils.getPrefixLength(string2);
        if (n2 < 0) {
            return null;
        }
        if (n2 > string2.length()) {
            FilenameUtils.failIfNullBytePresent(string2 + '/');
            return string2 + '/';
        }
        string2 = string2.substring(0, n2);
        FilenameUtils.failIfNullBytePresent(string2);
        return string2;
    }

    public static String getPath(String string2) {
        return FilenameUtils.doGetPath(string2, 1);
    }

    public static String getPathNoEndSeparator(String string2) {
        return FilenameUtils.doGetPath(string2, 0);
    }

    private static String doGetPath(String string2, int n2) {
        if (string2 == null) {
            return null;
        }
        int n3 = FilenameUtils.getPrefixLength(string2);
        if (n3 < 0) {
            return null;
        }
        int n4 = FilenameUtils.indexOfLastSeparator(string2);
        n2 = n4 + n2;
        if (n3 >= string2.length() || n4 < 0 || n3 >= n2) {
            return "";
        }
        string2 = string2.substring(n3, n2);
        FilenameUtils.failIfNullBytePresent(string2);
        return string2;
    }

    public static String getFullPath(String string2) {
        return FilenameUtils.doGetFullPath(string2, true);
    }

    public static String getFullPathNoEndSeparator(String string2) {
        return FilenameUtils.doGetFullPath(string2, false);
    }

    private static String doGetFullPath(String string2, boolean bl) {
        if (string2 == null) {
            return null;
        }
        int n2 = FilenameUtils.getPrefixLength(string2);
        if (n2 < 0) {
            return null;
        }
        if (n2 >= string2.length()) {
            if (bl) {
                return FilenameUtils.getPrefix(string2);
            }
            return string2;
        }
        int n3 = FilenameUtils.indexOfLastSeparator(string2);
        if (n3 < 0) {
            return string2.substring(0, n2);
        }
        if (!(bl = n3 + (bl ? 1 : 0))) {
            bl += 1;
        }
        return string2.substring(0, bl ? 1 : 0);
    }

    public static String getName(String string2) {
        if (string2 == null) {
            return null;
        }
        FilenameUtils.failIfNullBytePresent(string2);
        int n2 = FilenameUtils.indexOfLastSeparator(string2);
        return string2.substring(n2 + 1);
    }

    private static void failIfNullBytePresent(String string2) {
        int n2 = string2.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (string2.charAt(i2) != '\u0000') continue;
            throw new IllegalArgumentException("Null byte present in file/path name. There are no known legitimate use cases for such data, but several injection attacks may use it");
        }
    }

    public static String getBaseName(String string2) {
        return FilenameUtils.removeExtension(FilenameUtils.getName(string2));
    }

    public static String getExtension(String string2) {
        if (string2 == null) {
            return null;
        }
        int n2 = FilenameUtils.indexOfExtension(string2);
        if (n2 == -1) {
            return "";
        }
        return string2.substring(n2 + 1);
    }

    public static String removeExtension(String string2) {
        if (string2 == null) {
            return null;
        }
        FilenameUtils.failIfNullBytePresent(string2);
        int n2 = FilenameUtils.indexOfExtension(string2);
        if (n2 == -1) {
            return string2;
        }
        return string2.substring(0, n2);
    }

    public static boolean equals(String string2, String string3) {
        return FilenameUtils.equals(string2, string3, false, IOCase.SENSITIVE);
    }

    public static boolean equalsOnSystem(String string2, String string3) {
        return FilenameUtils.equals(string2, string3, false, IOCase.SYSTEM);
    }

    public static boolean equalsNormalized(String string2, String string3) {
        return FilenameUtils.equals(string2, string3, true, IOCase.SENSITIVE);
    }

    public static boolean equalsNormalizedOnSystem(String string2, String string3) {
        return FilenameUtils.equals(string2, string3, true, IOCase.SYSTEM);
    }

    public static boolean equals(String string2, String string3, boolean bl, IOCase iOCase) {
        if (string2 == null || string3 == null) {
            return string2 == null && string3 == null;
        }
        if (bl) {
            string2 = FilenameUtils.normalize(string2);
            string3 = FilenameUtils.normalize(string3);
            if (string2 == null || string3 == null) {
                throw new NullPointerException("Error normalizing one or both of the file names");
            }
        }
        if (iOCase == null) {
            iOCase = IOCase.SENSITIVE;
        }
        return iOCase.checkEquals(string2, string3);
    }

    public static boolean isExtension(String string2, String string3) {
        if (string2 == null) {
            return false;
        }
        FilenameUtils.failIfNullBytePresent(string2);
        if (string3 == null || string3.isEmpty()) {
            return FilenameUtils.indexOfExtension(string2) == -1;
        }
        string2 = FilenameUtils.getExtension(string2);
        return string2.equals(string3);
    }

    public static boolean isExtension(String string2, String[] stringArray) {
        if (string2 == null) {
            return false;
        }
        FilenameUtils.failIfNullBytePresent(string2);
        if (stringArray == null || stringArray.length == 0) {
            return FilenameUtils.indexOfExtension(string2) == -1;
        }
        string2 = FilenameUtils.getExtension(string2);
        for (String string3 : stringArray) {
            if (!string2.equals(string3)) continue;
            return true;
        }
        return false;
    }

    public static boolean isExtension(String string2, Collection<String> object) {
        if (string2 == null) {
            return false;
        }
        FilenameUtils.failIfNullBytePresent(string2);
        if (object == null || object.isEmpty()) {
            return FilenameUtils.indexOfExtension(string2) == -1;
        }
        string2 = FilenameUtils.getExtension(string2);
        object = object.iterator();
        while (object.hasNext()) {
            String string3 = (String)object.next();
            if (!string2.equals(string3)) continue;
            return true;
        }
        return false;
    }

    public static boolean wildcardMatch(String string2, String string3) {
        return FilenameUtils.wildcardMatch(string2, string3, IOCase.SENSITIVE);
    }

    public static boolean wildcardMatchOnSystem(String string2, String string3) {
        return FilenameUtils.wildcardMatch(string2, string3, IOCase.SYSTEM);
    }

    public static boolean wildcardMatch(String string2, String stringArray, IOCase iOCase) {
        if (string2 == null && stringArray == null) {
            return true;
        }
        if (string2 == null || stringArray == null) {
            return false;
        }
        if (iOCase == null) {
            iOCase = IOCase.SENSITIVE;
        }
        stringArray = FilenameUtils.splitOnTokens((String)stringArray);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Stack<int[]> stack = new Stack<int[]>();
        do {
            if (stack.size() > 0) {
                int[] nArray = (int[])stack.pop();
                n4 = nArray[0];
                n3 = nArray[1];
                n2 = 1;
            }
            while (n4 < stringArray.length) {
                if (stringArray[n4].equals("?")) {
                    if (++n3 > string2.length()) break;
                    n2 = 0;
                } else if (stringArray[n4].equals("*")) {
                    n2 = 1;
                    if (n4 == stringArray.length - 1) {
                        n3 = string2.length();
                    }
                } else {
                    if (n2 != 0) {
                        if ((n3 = iOCase.checkIndexOf(string2, n3, stringArray[n4])) == -1) break;
                        n2 = iOCase.checkIndexOf(string2, n3 + 1, stringArray[n4]);
                        if (n2 >= 0) {
                            stack.push(new int[]{n4, n2});
                        }
                    } else if (!iOCase.checkRegionMatches(string2, n3, stringArray[n4])) break;
                    n3 += stringArray[n4].length();
                    n2 = 0;
                }
                ++n4;
            }
            if (n4 != stringArray.length || n3 != string2.length()) continue;
            return true;
        } while (stack.size() > 0);
        return false;
    }

    static String[] splitOnTokens(String object) {
        if (((String)object).indexOf(63) == -1 && ((String)object).indexOf(42) == -1) {
            return new String[]{object};
        }
        object = ((String)object).toCharArray();
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        Object object2 = 0;
        for (Object object3 : object) {
            if (object3 == 63 || object3 == 42) {
                if (stringBuilder.length() != 0) {
                    arrayList.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                }
                if (object3 == 63) {
                    arrayList.add("?");
                } else if (object2 != 42) {
                    arrayList.add("*");
                }
            } else {
                stringBuilder.append((char)object3);
            }
            object2 = object3;
        }
        if (stringBuilder.length() != 0) {
            arrayList.add(stringBuilder.toString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

