/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.photo_picker;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.widget.LinearLayout;
import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.activity.photo_picker.c;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.model.source.photopicker.PhotoItem;
import com.zoyi.channel.plugin.android.presenter.photopicker.PhotoPickerContract$Presenter;
import com.zoyi.channel.plugin.android.presenter.photopicker.PhotoPickerContract$View;
import com.zoyi.channel.plugin.android.presenter.photopicker.PhotoPickerPresenter;
import com.zoyi.channel.plugin.android.util.Executor;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.view.layout.BigBar$MenuPosition;
import com.zoyi.channel.plugin.android.view.layout.MenuButton$ActionType;
import com.zoyi.channel.plugin.android.view.layout.MenuButton$MenuState;
import java.util.ArrayList;

public class PhotoPickerActivity
extends BaseActivity
implements PhotoPickerContract$View {
    private LinearLayout emptyLayout;
    private PhotoPickerContract$Presenter presenter;

    @Override
    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.init(R.layout.ch_plugin_activity_photo_picker);
        bundle = (RecyclerView)this.findViewById(R.id.recycler_view_photo_picker);
        this.emptyLayout = (LinearLayout)this.findViewById(R.id.no_album);
        this.getBigBar().withActivity(this).setTitle(ResUtils.getString((Context)this, "ch.photo.all_images")).addMenu(MenuButton$ActionType.BACK, BigBar$MenuPosition.LEFT).addMenu(MenuButton$ActionType.CAMERA, BigBar$MenuPosition.RIGHT).addMenu(MenuButton$ActionType.DONE, BigBar$MenuPosition.RIGHT, MenuButton$MenuState.DISABLED).build();
        c c2 = new c(this);
        this.presenter = new PhotoPickerPresenter((Context)this);
        this.presenter.setView(this);
        this.presenter.setAdapterView(c2);
        this.presenter.setAdapterModel(c2);
        bundle.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager((Context)this, 3));
        bundle.setAdapter((RecyclerView.Adapter)c2);
        bundle.setItemAnimator(null);
        this.setStyle();
    }

    private void setStyle() {
        Plugin plugin = ChannelStore.getPlugin();
        if (plugin != null) {
            this.setStatusBarColor(plugin.getBackgroundColor());
            this.getBigBar().setTheme(plugin.getBackgroundColor(), plugin.getTextColor());
        }
    }

    protected void onResume() {
        super.onResume();
        this.fetchPhotoItems();
    }

    public void onBackPressed() {
        this.setResult(0);
        super.onBackPressed();
    }

    protected void onActivityResult(int n2, int n3, Intent intent) {
        if (n3 == -1) {
            switch (n2) {
                case 3000: {
                    String string = Executor.getPhotoPath();
                    if (!TextUtils.isEmpty((CharSequence)string)) {
                        Executor.startFileMediaScan((Activity)this, string);
                        this.sendPhotoPath(Executor.getPhotoPath());
                    }
                    return;
                }
            }
        }
        super.onActivityResult(n2, n3, intent);
    }

    @Override
    public void optionClicked(MenuButton$ActionType menuButton$ActionType) {
        super.optionClicked(menuButton$ActionType);
        switch (menuButton$ActionType) {
            case BACK: {
                this.onBackPressed();
                return;
            }
            case CAMERA: {
                this.openCamera();
                return;
            }
            case DONE: {
                this.presenter.collectSelectedPhotoItem();
            }
        }
    }

    @Override
    public void loadPhotoItems(ArrayList<PhotoItem> arrayList) {
        this.setEmptyLayoutVisibility(arrayList.isEmpty());
    }

    @Override
    public void sendPhotoPaths(ArrayList<String> arrayList) {
        Intent intent = new Intent();
        intent.putStringArrayListExtra("PHOTO_INTENT_KEY", arrayList);
        this.setResult(12, intent);
        this.finish();
    }

    @Override
    public void setMenuState(int n2) {
        this.getBigBar().setMenuState(MenuButton$ActionType.DONE, n2 > 0 ? MenuButton$MenuState.VISIBLE : MenuButton$MenuState.DISABLED);
    }

    @Override
    public void setPresenter(PhotoPickerContract$Presenter photoPickerContract$Presenter) {
    }

    private void fetchPhotoItems() {
        if (this.checkPermission(2)) {
            this.presenter.fetchPhotoItems();
        }
    }

    private void setEmptyLayoutVisibility(boolean bl) {
        this.emptyLayout.setVisibility(bl ? 0 : 8);
    }

    @Override
    protected void permissionAccepted(int n2) {
        switch (n2) {
            case 2: {
                this.fetchPhotoItems();
                return;
            }
            case 3: {
                this.openCamera();
            }
        }
    }

    @Override
    protected void permissionRejected(int n2) {
        if (n2 == 2) {
            this.finish();
        }
    }

    private void sendPhotoPath(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        this.sendPhotoPaths(arrayList);
    }

    private void openCamera() {
        if (this.checkPermission(3)) {
            Executor.takePhoto((Activity)this);
        }
    }
}

