/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.content.Context;
import android.graphics.Point;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.model.SendingMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.c;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.PreviewThumb;
import com.zoyi.channel.plugin.android.model.rest.WebPage;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.handler.TextLinkClickListener;
import com.zoyi.channel.plugin.android.view.layout.LinkedTextView;
import com.zoyi.channel.plugin.android.view.layout.MaskableFrameLayout;
import com.zoyi.com.bumptech.glide.h;

public class ChatMessageHolder
extends RecyclerView.ViewHolder
implements View.OnClickListener,
TextLinkClickListener {
    Context context;
    View root;
    View profileLayout;
    View headView;
    View contextView;
    View messageView;
    TextView textTime;
    LinkedTextView text;
    LinearLayout contentLayout;
    View webPageLayout;
    View fileLayout;
    View uploadLayout;
    MaskableFrameLayout imageLayout;
    ImageView imageContent;
    ImageView imagePlaceholder;
    ImageView imageUploading;
    TextView textFileName;
    TextView textFileInfo;
    ImageView imageIcon;
    TextView textWebTitle;
    TextView textWebDescription;
    View progressUpload;
    View imageUploadFailed;
    SendingMessageItem sendingMessageItem;
    Message message;
    OnMessageClickListener listener;

    public ChatMessageHolder(View view, OnMessageClickListener onMessageClickListener) {
        super(view);
        this.context = view.getContext();
        this.listener = onMessageClickListener;
        this.root = view.findViewById(R.id.layout_message_root);
        this.profileLayout = view.findViewById(R.id.message_profile_layout);
        this.textTime = (TextView)view.findViewById(R.id.message_time);
        this.headView = view.findViewById(R.id.message_head);
        this.contextView = view.findViewById(R.id.message_context);
        this.messageView = view.findViewById(R.id.message_text_view);
        this.text = (LinkedTextView)view.findViewById(R.id.message_text);
        this.contentLayout = (LinearLayout)view.findViewById(R.id.layout_content);
        this.imageLayout = (MaskableFrameLayout)view.findViewById(R.id.content_image);
        this.webPageLayout = view.findViewById(R.id.content_webpage);
        this.fileLayout = view.findViewById(R.id.content_file);
        this.uploadLayout = view.findViewById(R.id.content_loading);
        this.imageContent = (ImageView)view.findViewById(R.id.image_chat);
        this.imagePlaceholder = (ImageView)view.findViewById(R.id.image_placeholder);
        this.textFileName = (TextView)view.findViewById(R.id.text_file_name);
        this.textFileInfo = (TextView)view.findViewById(R.id.text_file_info);
        this.imageIcon = (ImageView)view.findViewById(R.id.icon_file);
        this.textWebTitle = (TextView)view.findViewById(R.id.text_web_title);
        this.textWebDescription = (TextView)view.findViewById(R.id.text_web_description);
        this.imageUploading = (ImageView)view.findViewById(R.id.image_loading);
        this.progressUpload = view.findViewById(R.id.progress_upload);
        this.imageUploadFailed = view.findViewById(R.id.image_upload_failed);
        this.contentLayout.setVisibility(8);
        this.imageContent.setOnClickListener((View.OnClickListener)this);
        this.webPageLayout.setOnClickListener((View.OnClickListener)this);
        this.fileLayout.setOnClickListener((View.OnClickListener)this);
        this.text.setOnTextLinkClickListener(this);
    }

    /*
     * WARNING - void declaration
     */
    private void setImage(PreviewThumb previewThumb, boolean bl, String string) {
        void var3_6;
        void var2_5;
        int n2;
        WindowManager windowManager = (WindowManager)this.context.getSystemService("window");
        Point point = new Point();
        windowManager.getDefaultDisplay().getSize(point);
        if (bl) {
            int n3 = point.x - (int)Utils.dpToPx(this.context, 146.0f);
            n2 = (int)((double)n3 * 0.52);
        } else {
            point = Utils.getCorrectImageSize(point.x, point.y, previewThumb.getWidth(), previewThumb.getHeight());
            int n4 = Math.max(point.x, 1);
            n2 = Math.max(point.y, 1);
        }
        point = (LinearLayout.LayoutParams)this.imageLayout.getLayoutParams();
        ((LinearLayout.LayoutParams)this.imageLayout.getLayoutParams()).width = var2_5;
        point.height = n2;
        int n5 = (int)Utils.dpToPx(this.context, !TextUtils.isEmpty((CharSequence)var3_6) ? 10.0f : 0.0f);
        int n6 = (int)Utils.dpToPx(this.context, 4.0f);
        point.setMargins(0, n5, 0, n6);
        this.imageLayout.setLayoutParams((ViewGroup.LayoutParams)point);
        this.imageLayout.setVisibility(0);
        this.imagePlaceholder.setVisibility(0);
        h.b(this.itemView.getContext()).a(previewThumb.getUrl()).g().a((int)var2_5, n2).b().a().a(new c(this)).a(this.imageContent);
    }

    protected void setLayout(boolean bl, Long l2) {
        this.profileLayout.setVisibility(UIUtils.getVisible(!bl, true));
        this.headView.setVisibility(UIUtils.getVisible(!bl, true));
        this.contextView.setVisibility(UIUtils.getVisible(bl, true));
        this.textTime.setVisibility(UIUtils.getVisible(l2 != null, true));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void set(Message object, boolean n2) {
        String string;
        TextView textView;
        String string2;
        TextView textView2;
        this.sendingMessageItem = null;
        this.message = object;
        if (object == null) {
            return;
        }
        this.setLayout(n2 != 0, ((Message)object).getCreatedAt());
        this.textTime.setText((CharSequence)TimeUtils.get(((Message)object).getCreatedAt()));
        if (((Message)object).getMessage() != null) {
            this.messageView.setVisibility(0);
            this.setText(((Message)object).getMessage());
        } else {
            this.messageView.setVisibility(8);
        }
        if (!((Message)object).hasContent()) {
            this.contentLayout.setVisibility(8);
            return;
        }
        this.contentLayout.setVisibility(0);
        for (n2 = 0; n2 < this.contentLayout.getChildCount(); ++n2) {
            this.contentLayout.getChildAt(n2).setVisibility(8);
        }
        if (((Message)object).getFile() != null) {
            File file = ((Message)object).getFile();
            if (file == null) return;
            if (file.isImage() && file.getPreviewThumb() != null) {
                this.setImage(file.getPreviewThumb(), false, ((Message)object).getMessage());
                return;
            }
            object = Utils.getProperBytes(file.getSize());
            String string3 = "";
            String string4 = file.getExtension();
            if (!"default".equals(string4) && !TextUtils.isEmpty((CharSequence)string4)) {
                string3 = String.format(" \u00b7 %s", string4.substring(0, 1).toUpperCase() + string4.substring(1));
            }
            this.textFileName.setText((CharSequence)file.getFilename());
            this.textFileInfo.setText((CharSequence)String.format("%s%s", object, string3));
            this.imageIcon.setImageResource(ResUtils.getFileIconResourceId(file));
            this.fileLayout.setVisibility(0);
            return;
        }
        if (((Message)object).getWebPage() == null) return;
        WebPage webPage = ((Message)object).getWebPage();
        this.setText(((Message)object).getMessage());
        if (webPage == null) return;
        this.webPageLayout.setVisibility(0);
        if (webPage.getPreviewThumb() != null) {
            this.setImage(webPage.getPreviewThumb(), true, ((Message)object).getMessage());
        }
        if (!TextUtils.isEmpty((CharSequence)webPage.getTitle())) {
            textView2 = this.textWebTitle;
            string2 = webPage.getTitle();
        } else {
            textView2 = this.textWebTitle;
            string2 = webPage.getUrl() != null ? webPage.getUrl() : "";
        }
        textView2.setText((CharSequence)string2);
        if (!TextUtils.isEmpty((CharSequence)webPage.getDescription())) {
            textView = this.textWebDescription;
            string = webPage.getTitle();
        } else {
            textView = this.textWebDescription;
            string = webPage.getUrl() != null ? webPage.getUrl() : "";
        }
        textView.setText((CharSequence)string);
    }

    protected void setText(String string) {
        this.text.setLinkedText(string == null ? "" : string);
    }

    public void onClick(View view) {
        if (this.listener != null && this.message != null) {
            this.listener.messageClicked(this.message);
        }
    }

    @Override
    public void onTextLinkClick(View view, String string) {
        if (this.listener != null) {
            this.listener.urlClicked(string);
        }
    }
}

