/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint;

import android.location.Location;
import android.text.TextUtils;
import com.splunk.mint.Properties;
import com.splunk.mint.Utils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;

abstract class BaseDTO {
    protected static final String UNKNOWN = "NA";
    protected byte type;
    protected String sessionID;
    protected HashMap<String, Object> customData;
    private Long msFromStart;
    protected Long timestampMilis;
    private static volatile String globalSessionID = Utils.getRandomSessionNumber();
    private static volatile Boolean globalIsInitialSession = true;

    protected static synchronized String getGlobalSessionID() {
        return globalSessionID;
    }

    protected static synchronized void resetGlobalSessionID() {
        if (globalIsInitialSession.booleanValue()) {
            globalIsInitialSession = false;
            return;
        }
        globalSessionID = Utils.getRandomSessionNumber();
    }

    public BaseDTO(byte by, HashMap<String, Object> hashMap) {
        this(by, hashMap, null);
    }

    public BaseDTO(byte by, HashMap<String, Object> hashMap, String string) {
        this.sessionID = TextUtils.isEmpty((CharSequence)string) ? BaseDTO.getGlobalSessionID() : string;
        this.timestampMilis = System.currentTimeMillis();
        this.type = by;
        this.customData = hashMap;
        this.msFromStart = Utils.getMilisFromStart();
    }

    public synchronized void resetSessionID() {
        BaseDTO.resetGlobalSessionID();
        this.sessionID = BaseDTO.getGlobalSessionID();
    }

    public synchronized JSONObject getBasicDataFixtureJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("sdkVersion", (Object)"5.2.1");
            jSONObject.put("apiKey", (Object)Properties.API_KEY);
            jSONObject.put("platform", (Object)"Android");
            jSONObject.put("device", (Object)((Properties.PHONE_BRAND != null ? Properties.PHONE_BRAND + " " : "") + Properties.PHONE_MODEL));
            jSONObject.put("osVersion", (Object)Properties.OS_VERSION);
            jSONObject.put("locale", (Object)Properties.LOCALE);
            jSONObject.put("uuid", (Object)Properties.UID);
            jSONObject.put("userIdentifier", (Object)Properties.userIdentifier);
            jSONObject.put("appEnvironment", (Object)Properties.applicationEnvironment);
            jSONObject.put("batteryLevel", Properties.BATTERY_LEVEL);
            jSONObject.put("carrier", (Object)Properties.CARRIER);
            jSONObject.put("remoteIP", (Object)"{%#@@#%}");
            jSONObject.put("appVersionCode", (Object)Properties.APP_VERSIONCODE);
            jSONObject.put("appVersionName", (Object)Properties.APP_VERSIONNAME);
            jSONObject.put("packageName", (Object)Properties.APP_PACKAGE);
            jSONObject.put("connection", (Object)Properties.CONNECTION);
            jSONObject.put("state", (Object)Properties.STATE);
            jSONObject.put("currentView", (Object)Properties.lastView);
            jSONObject.put("screenOrientation", (Object)Properties.SCREEN_ORIENTATION);
            jSONObject.put("msFromStart", (Object)this.msFromStart);
            jSONObject.put("session_id", (Object)this.sessionID);
            JSONObject jSONObject2 = new JSONObject();
            Iterator<Map.Entry<String, Object>> iterator = Properties.extraData;
            if (iterator != null && !((ConcurrentHashMap)((Object)iterator)).isEmpty()) {
                for (Map.Entry entry : ((ConcurrentHashMap)((Object)iterator)).entrySet()) {
                    if (entry.getValue() == null) {
                        jSONObject2.put((String)entry.getKey(), (Object)"null");
                        continue;
                    }
                    jSONObject2.put((String)entry.getKey(), entry.getValue());
                }
            }
            if (this.customData != null && !this.customData.isEmpty()) {
                for (Map.Entry<String, Object> entry : this.customData.entrySet()) {
                    if (entry.getValue() == null) {
                        jSONObject2.put(entry.getKey(), (Object)"null");
                        continue;
                    }
                    jSONObject2.put(entry.getKey(), entry.getValue());
                }
            }
            jSONObject.put("extraData", (Object)jSONObject2);
            if (Properties.startedTransactions != null) {
                jSONObject.put("transactions", (Object)Properties.startedTransactions.getTransactionsJson());
            }
            this.addLocation(jSONObject);
        }
        catch (JSONException jSONException) {
            JSONException jSONException2 = jSONException;
            jSONException.printStackTrace();
        }
        return jSONObject;
    }

    void addLocation(JSONObject object) {
        JSONObject jSONObject = new JSONObject();
        String string = UNKNOWN;
        String string2 = UNKNOWN;
        String string3 = UNKNOWN;
        Location location = Properties.location;
        if (location != null) {
            string = Double.toString(location.getLongitude());
            string2 = Double.toString(location.getLatitude());
            string3 = Long.toString(location.getTime());
        }
        try {
            jSONObject.put("longitude", (Object)string);
            jSONObject.put("latitude", (Object)string2);
            jSONObject.put("timestamp", (Object)string3);
            object.put("location", (Object)jSONObject);
            return;
        }
        catch (JSONException jSONException) {
            object = jSONException;
            jSONException.printStackTrace();
            return;
        }
    }
}

