/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint.network.socket;

import com.splunk.mint.Logger;
import com.splunk.mint.Properties;
import com.splunk.mint.network.Counter;
import com.splunk.mint.network.Metric;
import com.splunk.mint.network.MonitorRegistry;
import com.splunk.mint.network.NetLogManager;
import com.splunk.mint.network.io.InputStreamMonitor;
import com.splunk.mint.network.io.InputStreamMonitorKitKat;
import com.splunk.mint.network.io.OutputStreamMonitor;
import com.splunk.mint.network.util.Delegator;
import com.splunk.mint.network.util.ReflectionUtil;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MonitoringSocketImpl
extends SocketImpl {
    public static final String ENCAPSULATED_SOCKET_IMPL = "java.net.PlainSocketImpl";
    private static final String[] SYSTEM_PACKAGES = new String[]{"android", "java", "org.apache", "splunk", "libcore"};
    private static final String[] HTTP_CLASSES = new String[]{"HttpClient", "URLConnection", "HttpsURLConnectionImpl", "HttpURLConnectionImpl"};
    private InputStreamMonitor mInputStreamMonitor = null;
    private OutputStreamMonitor mOutputStreamMonitor = null;
    private InputStreamMonitorKitKat mInputStreamMonitorKitKat = null;
    private final MonitorRegistry registry;
    private final Delegator delegator;
    private String name = "NA";
    private final String method = ReflectionUtil.extractCallingMethod(SYSTEM_PACKAGES);
    private final boolean http = ReflectionUtil.callingClassAnyOf(HTTP_CLASSES);
    private String protocol = "NA";
    private long startTime;
    private boolean readingDone = false;

    public MonitoringSocketImpl(MonitorRegistry registry) {
        this.delegator = new Delegator((Object)this, SocketImpl.class, ENCAPSULATED_SOCKET_IMPL);
        this.registry = registry;
    }

    @Override
    protected void create(boolean isStreaming) throws IOException {
        try {
            this.delegator.invoke(isStreaming);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            this.createActionEventFromCollectedStats(this.registry.getMetricsForName(this.name), null, null, System.currentTimeMillis(), NetLogManager.exceptionToString(e.getCause()), this.name);
            try {
                throw e.getCause();
            }
            catch (Throwable e1) {
                e1.printStackTrace();
            }
        }
    }

    @Override
    protected void bind(InetAddress address, int port) throws IOException {
        this.name = address.getHostName();
        try {
            this.delegator.invoke(address, port);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            this.createActionEventFromCollectedStats(this.registry.getMetricsForName(this.name), null, null, System.currentTimeMillis(), NetLogManager.exceptionToString(e.getCause()), this.name);
            try {
                throw e.getCause();
            }
            catch (Throwable e1) {
                e1.printStackTrace();
            }
        }
        this.startTime = System.currentTimeMillis();
    }

    @Override
    protected void accept(SocketImpl newSocket) throws IOException {
        try {
            this.delegator.invoke(newSocket);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            this.createActionEventFromCollectedStats(this.registry.getMetricsForName(this.name), null, null, System.currentTimeMillis(), NetLogManager.exceptionToString(e.getCause()), this.name);
            try {
                throw e.getCause();
            }
            catch (Throwable e1) {
                e1.printStackTrace();
            }
        }
    }

    @Override
    protected int available() throws IOException {
        try {
            Integer result = (Integer)this.delegator.invoke(new Object[0]);
            return result;
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            return 0;
        }
    }

    @Override
    protected void connect(InetAddress address, int port) throws IOException {
        this.name = address.getHostName();
        try {
            this.delegator.delegateTo("connect", InetAddress.class, Integer.TYPE).invoke(address, port);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            this.createActionEventFromCollectedStats(this.registry.getMetricsForName(this.name), null, null, System.currentTimeMillis(), NetLogManager.exceptionToString(e.getCause()), this.name);
            try {
                throw e.getCause();
            }
            catch (Throwable e1) {
                e1.printStackTrace();
            }
        }
        this.startTime = System.currentTimeMillis();
        this.setProtocolFromPort(port);
    }

    @Override
    protected void connect(SocketAddress remoteAddr, int timeout) throws IOException {
        if (remoteAddr instanceof InetSocketAddress) {
            InetSocketAddress addr = (InetSocketAddress)remoteAddr;
            this.name = addr.getHostName();
            this.setProtocolFromPort(addr.getPort());
        } else {
            this.name = remoteAddr.toString();
        }
        try {
            this.delegator.invoke(remoteAddr, timeout);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            this.createActionEventFromCollectedStats(this.registry.getMetricsForName(this.name), null, null, System.currentTimeMillis(), NetLogManager.exceptionToString(e.getCause()), this.name);
            try {
                throw e.getCause();
            }
            catch (Throwable e1) {
                e1.printStackTrace();
            }
        }
        this.startTime = System.currentTimeMillis();
    }

    @Override
    protected void connect(String host, int port) throws IOException {
        this.name = host;
        try {
            this.delegator.invoke(host, port);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            this.createActionEventFromCollectedStats(this.registry.getMetricsForName(this.name), null, null, System.currentTimeMillis(), NetLogManager.exceptionToString(e.getCause()), this.name);
            try {
                throw e.getCause();
            }
            catch (Throwable e1) {
                e1.printStackTrace();
            }
        }
        this.startTime = System.currentTimeMillis();
        this.setProtocolFromPort(port);
    }

    @Override
    protected void close() throws IOException {
        try {
            this.delegator.invoke(new Object[0]);
        }
        catch (Exception e) {
            Logger.logError("Error closing socket impl: " + e.getMessage());
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            this.createActionEventFromCollectedStats(this.registry.getMetricsForName(this.name), null, null, System.currentTimeMillis(), NetLogManager.exceptionToString(e.getCause()), this.name);
            try {
                throw e.getCause();
            }
            catch (Throwable e1) {
                e1.printStackTrace();
            }
        }
    }

    public void readingDone() {
        if (!this.readingDone) {
            this.readingDone = true;
            if (Properties.isKitKat) {
                if (this.mOutputStreamMonitor != null && this.mInputStreamMonitorKitKat != null) {
                    this.createActionEventFromCollectedStats(this.registry.getMetricsForName(this.name), this.mOutputStreamMonitor.getHeaders(), this.mInputStreamMonitorKitKat.getHeaders(), System.currentTimeMillis(), this.mInputStreamMonitorKitKat.exception, null);
                }
            } else if (this.mOutputStreamMonitor != null && this.mInputStreamMonitor != null) {
                this.createActionEventFromCollectedStats(this.registry.getMetricsForName(this.name), this.mOutputStreamMonitor.getHeaders(), this.mInputStreamMonitor.getHeaders(), System.currentTimeMillis(), this.mInputStreamMonitor.exception, null);
            }
        }
    }

    private void createActionEventFromCollectedStats(ArrayList<Metric<?>> metrics, HashMap<String, List<String>> outputHeaders, HashMap<String, List<String>> inputHeaders, long endTime, String exception, String exceptionUrl) {
        String url = "";
        if (outputHeaders != null) {
            try {
                url = outputHeaders.get("Host").get(0);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            try {
                url = url + outputHeaders.get("splk-host2").get(0);
            }
            catch (Exception exception3) {
                // empty catch block
            }
        }
        if (exception != null) {
            url = exceptionUrl;
        }
        int statuscode = 0;
        if (inputHeaders != null) {
            try {
                statuscode = Integer.valueOf(inputHeaders.get("splk-statuscode").get(0));
            }
            catch (Exception exception4) {
                // empty catch block
            }
        }
        Long bytesOut = 0L;
        long bytesIn = 0L;
        for (Metric<?> m : metrics) {
            if (!(m instanceof Counter)) continue;
            if (((Counter)m).getName().endsWith("-bytes-out")) {
                bytesOut = (Long)m.getValue();
                continue;
            }
            if (!((Counter)m).getName().endsWith("-bytes-in")) continue;
            bytesIn = (Long)m.getValue();
        }
        try {
            bytesIn = Long.valueOf(inputHeaders.get("Content-Length").get(0));
        }
        catch (Exception e) {
            Logger.logInfo("Could not read the Content-Length HTTP header value");
        }
        NetLogManager.getInstance().logNetworkRequest(url, this.protocol, this.startTime, endTime, statuscode, bytesOut, bytesIn, exception, null);
    }

    @Override
    protected InputStream getInputStream() throws IOException {
        InputStream stream = null;
        try {
            stream = (InputStream)this.delegator.invoke(new Object[0]);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            this.createActionEventFromCollectedStats(this.registry.getMetricsForName(this.name), null, null, System.currentTimeMillis(), NetLogManager.exceptionToString(e.getCause()), this.name);
        }
        if (stream != null) {
            if (Properties.isKitKat) {
                if (this.mInputStreamMonitorKitKat == null) {
                    this.mInputStreamMonitorKitKat = new InputStreamMonitorKitKat(this.name, this.registry, stream, this);
                }
                return this.mInputStreamMonitorKitKat;
            }
            if (this.mInputStreamMonitor == null) {
                this.mInputStreamMonitor = new InputStreamMonitor(this.name, this.registry, stream, this);
            }
            return this.mInputStreamMonitor;
        }
        return null;
    }

    @Override
    public Object getOption(int optID) throws SocketException {
        try {
            return this.delegator.invoke(optID);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected OutputStream getOutputStream() throws IOException {
        OutputStream out = null;
        try {
            out = (OutputStream)this.delegator.invoke(new Object[0]);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            e.printStackTrace();
        }
        if (out != null) {
            if (this.mOutputStreamMonitor == null) {
                this.mOutputStreamMonitor = new OutputStreamMonitor(this.name, this.registry, out);
            }
            return this.mOutputStreamMonitor;
        }
        return null;
    }

    @Override
    protected void listen(int backlog) throws IOException {
        try {
            this.delegator.invoke(backlog);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            e.printStackTrace();
        }
    }

    @Override
    protected void sendUrgentData(int value) throws IOException {
        try {
            this.delegator.invoke(value);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            e.printStackTrace();
        }
    }

    @Override
    public void setOption(int optID, Object val) throws SocketException {
        try {
            this.delegator.invoke(optID, val);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected FileDescriptor getFileDescriptor() {
        try {
            return (FileDescriptor)this.delegator.invoke(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected InetAddress getInetAddress() {
        try {
            return (InetAddress)this.delegator.invoke(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected int getLocalPort() {
        try {
            Integer result = (Integer)this.delegator.invoke(new Object[0]);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Override
    protected int getPort() {
        try {
            Integer port = (Integer)this.delegator.invoke(new Object[0]);
            return port;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Override
    protected void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        try {
            this.delegator.invoke(connectionTime, latency, bandwidth);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void shutdownInput() throws IOException {
        if (Properties.isKitKat) {
            if (this.mInputStreamMonitorKitKat != null) {
                this.mInputStreamMonitorKitKat.close();
            }
        } else if (this.mInputStreamMonitor != null) {
            this.mInputStreamMonitor.close();
        }
        try {
            this.delegator.invoke(new Object[0]);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void shutdownOutput() throws IOException {
        if (this.mOutputStreamMonitor != null) {
            this.mOutputStreamMonitor.close();
        }
        try {
            this.delegator.invoke(new Object[0]);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected boolean supportsUrgentData() {
        try {
            Boolean result = (Boolean)this.delegator.invoke(new Object[0]);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getMethod() {
        return this.method;
    }

    public boolean isHttp() {
        return this.http;
    }

    private void setProtocolFromPort(int port) {
        if (port == 80) {
            this.protocol = "HTTP";
        } else if (port == 443) {
            this.protocol = "HTTPS";
        }
    }
}

