/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.userchat_list;

import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.CheckBox;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.userchat_list.OnUserChatCheckListener;
import com.zoyi.channel.plugin.android.activity.userchat_list.OnUserChatClickListener;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.Session;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.model.source.userchat.UserChatItem;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;
import java.util.List;

class UserChatHolder
extends RecyclerView.ViewHolder
implements View.OnClickListener,
View.OnLongClickListener {
    private Context context;
    private CheckBox checkImage;
    private View singleAvatar;
    private View doubleAvatar;
    private View tripleAvatar;
    private AvatarLayout avatarSingle;
    private AvatarLayout avatarDouble1;
    private AvatarLayout avatarDouble2;
    private AvatarLayout avatarTriple1;
    private AvatarLayout avatarTriple2;
    private AvatarLayout avatarTriple3;
    private TextView textName;
    private TextView textTime;
    private TextView textMessage;
    private TextView textBadge;
    private UserChat userChat;
    private OnUserChatClickListener clickListener;
    private OnUserChatCheckListener checkListener;
    private boolean editMode = false;

    UserChatHolder(View itemView, OnUserChatClickListener clickListener, OnUserChatCheckListener checkListener) {
        super(itemView);
        this.context = itemView.getContext();
        this.clickListener = clickListener;
        this.checkListener = checkListener;
        this.checkImage = (CheckBox)itemView.findViewById(R.id.check_userchat);
        this.singleAvatar = itemView.findViewById(R.id.layout_single);
        this.doubleAvatar = itemView.findViewById(R.id.layout_double);
        this.tripleAvatar = itemView.findViewById(R.id.layout_triple);
        this.avatarSingle = (AvatarLayout)itemView.findViewById(R.id.avatar_single);
        this.avatarDouble1 = (AvatarLayout)itemView.findViewById(R.id.avatar_double1);
        this.avatarDouble2 = (AvatarLayout)itemView.findViewById(R.id.avatar_double2);
        this.avatarTriple1 = (AvatarLayout)itemView.findViewById(R.id.avatar_triple1);
        this.avatarTriple2 = (AvatarLayout)itemView.findViewById(R.id.avatar_triple2);
        this.avatarTriple3 = (AvatarLayout)itemView.findViewById(R.id.avatar_triple3);
        this.avatarSingle.setTextSize(16);
        this.avatarDouble1.setTextSize(14);
        this.avatarDouble2.setTextSize(14);
        this.avatarTriple1.setTextSize(10);
        this.avatarTriple2.setTextSize(10);
        this.avatarTriple3.setTextSize(10);
        this.textName = (TextView)itemView.findViewById(R.id.text_name);
        this.textTime = (TextView)itemView.findViewById(R.id.text_time);
        this.textMessage = (TextView)itemView.findViewById(R.id.text_message);
        this.textBadge = (TextView)itemView.findViewById(R.id.text_badge);
        itemView.setOnClickListener((View.OnClickListener)this);
        itemView.setOnLongClickListener((View.OnLongClickListener)this);
    }

    void setUserChatItem(UserChatItem item, boolean checked, boolean editMode) {
        this.editMode = editMode;
        this.userChat = item.getUserChat();
        this.checkImage.setChecked(editMode && checked);
        this.checkImage.setVisibility(UIUtils.getVisible(editMode, true));
        Message message = item.getMessage();
        Session session = item.getSession();
        List<? extends ProfileEntity> profiles = item.getProfiles();
        this.textName.setText((CharSequence)UIUtils.getNamesString(profiles));
        this.setTextMessage(message);
        this.setTextTime(message);
        if (session != null && session.getAlert() != null && session.getAlert() > 0) {
            this.textBadge.setVisibility(0);
            this.textBadge.setText((CharSequence)Utils.getCount(session.getAlert(), true));
        } else {
            this.textBadge.setVisibility(8);
        }
        this.singleAvatar.setVisibility(8);
        this.doubleAvatar.setVisibility(8);
        this.tripleAvatar.setVisibility(8);
        if (profiles.size() == 1) {
            this.singleAvatar.setVisibility(0);
            this.avatarSingle.set(profiles.get(0));
        } else if (profiles.size() == 2) {
            this.doubleAvatar.setVisibility(0);
            this.avatarDouble1.set(profiles.get(0));
            this.avatarDouble2.set(profiles.get(1));
        } else if (profiles.size() > 2) {
            this.tripleAvatar.setVisibility(0);
            this.avatarTriple1.set(profiles.get(0));
            this.avatarTriple2.set(profiles.get(1));
            this.avatarTriple3.set(profiles.get(2));
        }
    }

    private void setTextMessage(Message message) {
        if (this.userChat.isStateResolved()) {
            this.textMessage.setText(R.string.ch_review_require_preview);
            this.textMessage.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.ch_dark));
        } else if (this.userChat.isStateClosed()) {
            this.textMessage.setText((CharSequence)this.context.getString(R.string.ch_review_complete_preview));
            this.textMessage.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.ch_light));
        } else {
            this.textMessage.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.ch_dark));
            if (message != null) {
                if (message.getMessage() != null) {
                    this.textMessage.setText((CharSequence)message.getMessage());
                } else if (message.getFile() != null) {
                    if (message.getFile().isImage()) {
                        this.textMessage.setText((CharSequence)ResUtils.getString(this.context, "ch.notification.upload_image.description"));
                    } else {
                        this.textMessage.setText((CharSequence)ResUtils.getString(this.context, "ch.notification.upload_file.description"));
                    }
                } else {
                    this.textMessage.setText((CharSequence)"");
                }
            } else {
                this.textMessage.setText((CharSequence)"");
            }
        }
    }

    private void setTextTime(Message message) {
        if (this.userChat != null) {
            if (this.userChat.isStateResolved()) {
                this.textTime.setText((CharSequence)TimeUtils.get(this.userChat.getResolvedAt()));
            } else if (message != null) {
                this.textTime.setText((CharSequence)TimeUtils.get(message.getCreatedAt()));
            } else {
                this.textTime.setText((CharSequence)TimeUtils.get(this.userChat.getUpdatedAt()));
            }
        } else {
            this.textTime.setText((CharSequence)"");
        }
    }

    public String getChatId() {
        if (this.userChat != null) {
            return this.userChat.getId();
        }
        return null;
    }

    public void onClick(View view) {
        if (this.editMode) {
            this.checkListener.onUserChatCheck(this.getChatId());
        } else {
            this.clickListener.onUserChatClick(this.getChatId());
        }
    }

    public boolean onLongClick(View v) {
        if (this.editMode) {
            return false;
        }
        this.clickListener.onUserChatLongClick(this.getChatId());
        return true;
    }
}

