/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Observable;
import com.zoyi.rx.Producer;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.functions.Action1;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperatorDoOnRequest<T>
implements Observable.Operator<T, T> {
    final Action1<? super Long> request;

    public OperatorDoOnRequest(Action1<? super Long> request) {
        this.request = request;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super T> child) {
        final ParentSubscriber<? super T> parent = new ParentSubscriber<T>(child);
        child.setProducer(new Producer(){

            public void request(long n) {
                OperatorDoOnRequest.this.request.call((Long)n);
                parent.requestMore(n);
            }
        });
        child.add(parent);
        return parent;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ParentSubscriber<T>
    extends Subscriber<T> {
        private final Subscriber<? super T> child;

        ParentSubscriber(Subscriber<? super T> child) {
            this.child = child;
            this.request(0L);
        }

        private void requestMore(long n) {
            this.request(n);
        }

        @Override
        public void onCompleted() {
            this.child.onCompleted();
        }

        @Override
        public void onError(Throwable e) {
            this.child.onError(e);
        }

        @Override
        public void onNext(T t) {
            this.child.onNext(t);
        }
    }
}

