/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.subjects;

import com.zoyi.rx.Subscriber;
import com.zoyi.rx.internal.operators.BackpressureUtils;
import com.zoyi.rx.plugins.RxJavaHooks;
import com.zoyi.rx.subjects.ReplaySubject$ReplayBuffer;
import com.zoyi.rx.subjects.ReplaySubject$ReplayProducer;
import java.lang.reflect.Array;

final class ReplaySubject$ReplayUnboundedBuffer<T>
implements ReplaySubject$ReplayBuffer<T> {
    final int capacity;
    volatile int size;
    final Object[] head;
    Object[] tail;
    int tailIndex;
    volatile boolean done;
    Throwable error;

    public ReplaySubject$ReplayUnboundedBuffer(int n2) {
        this.capacity = n2;
        this.head = new Object[n2 + 1];
        this.tail = this.head;
    }

    @Override
    public final void next(T t2) {
        if (this.done) {
            return;
        }
        int n2 = this.tailIndex;
        Object[] objectArray = this.tail;
        if (n2 == objectArray.length - 1) {
            Object[] objectArray2 = new Object[objectArray.length];
            Object[] objectArray3 = objectArray2;
            objectArray2[0] = t2;
            this.tailIndex = 1;
            objectArray[n2] = objectArray3;
            this.tail = objectArray3;
        } else {
            objectArray[n2] = t2;
            this.tailIndex = n2 + 1;
        }
        ++this.size;
    }

    @Override
    public final void error(Throwable throwable) {
        if (this.done) {
            RxJavaHooks.onError(throwable);
            return;
        }
        this.error = throwable;
        this.done = true;
    }

    @Override
    public final void complete() {
        this.done = true;
    }

    @Override
    public final void drain(ReplaySubject$ReplayProducer<T> replaySubject$ReplayProducer) {
        if (replaySubject$ReplayProducer.getAndIncrement() != 0) {
            return;
        }
        int n2 = 1;
        Subscriber<Object> subscriber = replaySubject$ReplayProducer.actual;
        int n3 = this.capacity;
        do {
            boolean bl;
            boolean bl2;
            long l2 = replaySubject$ReplayProducer.requested.get();
            long l3 = 0L;
            Object[] objectArray = (Object[])replaySubject$ReplayProducer.node;
            if (objectArray == null) {
                objectArray = this.head;
            }
            int n4 = replaySubject$ReplayProducer.tailIndex;
            int n5 = replaySubject$ReplayProducer.index;
            while (l3 != l2) {
                if (subscriber.isUnsubscribed()) {
                    replaySubject$ReplayProducer.node = null;
                    return;
                }
                bl2 = this.done;
                boolean bl3 = bl = n5 == this.size;
                if (bl2 && bl) {
                    replaySubject$ReplayProducer.node = null;
                    Throwable throwable = this.error;
                    if (throwable != null) {
                        subscriber.onError(throwable);
                        return;
                    }
                    subscriber.onCompleted();
                    return;
                }
                if (bl) break;
                if (n4 == n3) {
                    objectArray = (Object[])objectArray[n4];
                    n4 = 0;
                }
                Object object = objectArray[n4];
                subscriber.onNext(object);
                ++l3;
                ++n4;
                ++n5;
            }
            if (l3 == l2) {
                if (subscriber.isUnsubscribed()) {
                    replaySubject$ReplayProducer.node = null;
                    return;
                }
                bl2 = this.done;
                boolean bl4 = bl = n5 == this.size;
                if (bl2 && bl) {
                    replaySubject$ReplayProducer.node = null;
                    Throwable throwable = this.error;
                    if (throwable != null) {
                        subscriber.onError(throwable);
                        return;
                    }
                    subscriber.onCompleted();
                    return;
                }
            }
            if (l3 != 0L && l2 != Long.MAX_VALUE) {
                BackpressureUtils.produced(replaySubject$ReplayProducer.requested, l3);
            }
            replaySubject$ReplayProducer.index = n5;
            replaySubject$ReplayProducer.tailIndex = n4;
            replaySubject$ReplayProducer.node = objectArray;
        } while ((n2 = replaySubject$ReplayProducer.addAndGet(-n2)) != 0);
    }

    @Override
    public final boolean isComplete() {
        return this.done;
    }

    @Override
    public final Throwable error() {
        return this.error;
    }

    @Override
    public final T last() {
        int n2 = this.size;
        if (n2 == 0) {
            return null;
        }
        Object[] objectArray = this.head;
        int n3 = this.capacity;
        while (n2 >= n3) {
            objectArray = (Object[])objectArray[n3];
            n2 -= n3;
        }
        return (T)objectArray[n2 - 1];
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public final T[] toArray(T[] objectArray) {
        int n2 = this.size;
        if (objectArray.length < n2) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n2);
        }
        Object[] objectArray2 = this.head;
        int n3 = this.capacity;
        int n4 = 0;
        while (n4 + n3 < n2) {
            System.arraycopy(objectArray2, 0, objectArray, n4, n3);
            n4 += n3;
            objectArray2 = (Object[])objectArray2[n3];
        }
        System.arraycopy(objectArray2, 0, objectArray, n4, n2 - n4);
        if (objectArray.length > n2) {
            objectArray[n2] = null;
        }
        return objectArray;
    }
}

