/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.subjects;

import com.zoyi.rx.Observable$OnSubscribe;
import com.zoyi.rx.Observer;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.subjects.ReplaySubject$ReplayBuffer;
import com.zoyi.rx.subjects.ReplaySubject$ReplayProducer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

final class ReplaySubject$ReplayState<T>
extends AtomicReference<ReplaySubject$ReplayProducer<T>[]>
implements Observable$OnSubscribe<T>,
Observer<T> {
    private static final long serialVersionUID = 5952362471246910544L;
    final ReplaySubject$ReplayBuffer<T> buffer;
    static final ReplaySubject$ReplayProducer[] EMPTY = new ReplaySubject$ReplayProducer[0];
    static final ReplaySubject$ReplayProducer[] TERMINATED = new ReplaySubject$ReplayProducer[0];

    public ReplaySubject$ReplayState(ReplaySubject$ReplayBuffer<T> replaySubject$ReplayBuffer) {
        this.buffer = replaySubject$ReplayBuffer;
        this.lazySet(EMPTY);
    }

    @Override
    public final void call(Subscriber<? super T> subscriber) {
        ReplaySubject$ReplayProducer<T> replaySubject$ReplayProducer = new ReplaySubject$ReplayProducer<T>(subscriber, this);
        subscriber.add(replaySubject$ReplayProducer);
        subscriber.setProducer(replaySubject$ReplayProducer);
        if (this.add(replaySubject$ReplayProducer) && replaySubject$ReplayProducer.isUnsubscribed()) {
            this.remove(replaySubject$ReplayProducer);
            return;
        }
        this.buffer.drain(replaySubject$ReplayProducer);
    }

    final boolean add(ReplaySubject$ReplayProducer<T> replaySubject$ReplayProducer) {
        ReplaySubject$ReplayProducer[] replaySubject$ReplayProducerArray;
        ReplaySubject$ReplayProducer[] replaySubject$ReplayProducerArray2;
        do {
            if ((replaySubject$ReplayProducerArray2 = (ReplaySubject$ReplayProducer[])this.get()) == TERMINATED) {
                return false;
            }
            int n2 = replaySubject$ReplayProducerArray2.length;
            replaySubject$ReplayProducerArray = new ReplaySubject$ReplayProducer[n2 + 1];
            System.arraycopy(replaySubject$ReplayProducerArray2, 0, replaySubject$ReplayProducerArray, 0, n2);
            replaySubject$ReplayProducerArray[n2] = replaySubject$ReplayProducer;
        } while (!this.compareAndSet(replaySubject$ReplayProducerArray2, replaySubject$ReplayProducerArray));
        return true;
    }

    final void remove(ReplaySubject$ReplayProducer<T> replaySubject$ReplayProducer) {
        ReplaySubject$ReplayProducer[] replaySubject$ReplayProducerArray;
        ReplaySubject$ReplayProducer[] replaySubject$ReplayProducerArray2;
        do {
            if ((replaySubject$ReplayProducerArray2 = (ReplaySubject$ReplayProducer[])this.get()) == TERMINATED || replaySubject$ReplayProducerArray2 == EMPTY) {
                return;
            }
            int n2 = replaySubject$ReplayProducerArray2.length;
            int n3 = -1;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (replaySubject$ReplayProducerArray2[i2] != replaySubject$ReplayProducer) continue;
                n3 = i2;
                break;
            }
            if (n3 < 0) {
                return;
            }
            if (n2 == 1) {
                replaySubject$ReplayProducerArray = EMPTY;
                continue;
            }
            replaySubject$ReplayProducerArray = new ReplaySubject$ReplayProducer[n2 - 1];
            System.arraycopy(replaySubject$ReplayProducerArray2, 0, replaySubject$ReplayProducerArray, 0, n3);
            System.arraycopy(replaySubject$ReplayProducerArray2, n3 + 1, replaySubject$ReplayProducerArray, n3, n2 - n3 - 1);
        } while (!this.compareAndSet(replaySubject$ReplayProducerArray2, replaySubject$ReplayProducerArray));
    }

    @Override
    public final void onNext(T object) {
        ReplaySubject$ReplayBuffer<Object> replaySubject$ReplayBuffer = this.buffer;
        replaySubject$ReplayBuffer.next(object);
        for (ReplaySubject$ReplayProducer replaySubject$ReplayProducer : (ReplaySubject$ReplayProducer[])this.get()) {
            replaySubject$ReplayBuffer.drain(replaySubject$ReplayProducer);
        }
    }

    @Override
    public final void onError(Throwable serializable) {
        ReplaySubject$ReplayBuffer<T> replaySubject$ReplayBuffer = this.buffer;
        replaySubject$ReplayBuffer.error((Throwable)serializable);
        serializable = null;
        for (ReplaySubject$ReplayProducer replaySubject$ReplayProducer : this.getAndSet(TERMINATED)) {
            try {
                replaySubject$ReplayBuffer.drain(replaySubject$ReplayProducer);
            }
            catch (Throwable throwable) {
                if (serializable == null) {
                    serializable = new ArrayList();
                }
                serializable.add(throwable);
            }
        }
        Exceptions.throwIfAny((List<? extends Throwable>)((Object)serializable));
    }

    @Override
    public final void onCompleted() {
        ReplaySubject$ReplayBuffer<T> replaySubject$ReplayBuffer = this.buffer;
        replaySubject$ReplayBuffer.complete();
        for (ReplaySubject$ReplayProducer replaySubject$ReplayProducer : this.getAndSet(TERMINATED)) {
            replaySubject$ReplayBuffer.drain(replaySubject$ReplayProducer);
        }
    }

    final boolean isTerminated() {
        return this.get() == TERMINATED;
    }
}

