/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.subjects;

import com.zoyi.rx.Observable$OnSubscribe;
import com.zoyi.rx.annotations.Beta;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.internal.operators.NotificationLite;
import com.zoyi.rx.internal.producers.SingleProducer;
import com.zoyi.rx.subjects.AsyncSubject$1;
import com.zoyi.rx.subjects.Subject;
import com.zoyi.rx.subjects.SubjectSubscriptionManager;
import com.zoyi.rx.subjects.SubjectSubscriptionManager$SubjectObserver;
import java.util.ArrayList;

public final class AsyncSubject<T>
extends Subject<T, T> {
    final SubjectSubscriptionManager<T> state;
    volatile Object lastValue;
    private final NotificationLite<T> nl = NotificationLite.instance();

    public static <T> AsyncSubject<T> create() {
        SubjectSubscriptionManager subjectSubscriptionManager = new SubjectSubscriptionManager();
        new SubjectSubscriptionManager().onTerminated = new AsyncSubject$1(subjectSubscriptionManager);
        return new AsyncSubject(subjectSubscriptionManager, subjectSubscriptionManager);
    }

    protected AsyncSubject(Observable$OnSubscribe<T> observable$OnSubscribe, SubjectSubscriptionManager<T> subjectSubscriptionManager) {
        super(observable$OnSubscribe);
        this.state = subjectSubscriptionManager;
    }

    @Override
    public final void onCompleted() {
        if (this.state.active) {
            Object object = this.lastValue;
            if (object == null) {
                object = this.nl.completed();
            }
            for (SubjectSubscriptionManager$SubjectObserver<T> subjectSubscriptionManager$SubjectObserver : this.state.terminate(object)) {
                if (object == this.nl.completed()) {
                    subjectSubscriptionManager$SubjectObserver.onCompleted();
                    continue;
                }
                subjectSubscriptionManager$SubjectObserver.actual.setProducer(new SingleProducer(subjectSubscriptionManager$SubjectObserver.actual, this.nl.getValue(object)));
            }
        }
    }

    @Override
    public final void onError(Throwable throwable) {
        if (this.state.active) {
            SubjectSubscriptionManager$SubjectObserver<T>[] subjectSubscriptionManager$SubjectObserverArray = this.nl.error(throwable);
            ArrayList<Throwable> arrayList = null;
            for (SubjectSubscriptionManager$SubjectObserver<T> subjectSubscriptionManager$SubjectObserver : this.state.terminate(subjectSubscriptionManager$SubjectObserverArray)) {
                try {
                    subjectSubscriptionManager$SubjectObserver.onError(throwable);
                }
                catch (Throwable throwable2) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<Throwable>();
                    }
                    arrayList.add(throwable2);
                }
            }
            Exceptions.throwIfAny(arrayList);
        }
    }

    @Override
    public final void onNext(T t2) {
        this.lastValue = this.nl.next(t2);
    }

    @Override
    public final boolean hasObservers() {
        return this.state.observers().length > 0;
    }

    @Beta
    public final boolean hasValue() {
        Object object = this.lastValue;
        Object object2 = this.state.getLatest();
        return !this.nl.isError(object2) && this.nl.isNext(object);
    }

    @Beta
    public final boolean hasThrowable() {
        Object object = this.state.getLatest();
        return this.nl.isError(object);
    }

    @Beta
    public final boolean hasCompleted() {
        Object object = this.state.getLatest();
        return object != null && !this.nl.isError(object);
    }

    @Beta
    public final T getValue() {
        Object object = this.lastValue;
        Object object2 = this.state.getLatest();
        if (!this.nl.isError(object2) && this.nl.isNext(object)) {
            return this.nl.getValue(object);
        }
        return null;
    }

    @Beta
    public final Throwable getThrowable() {
        Object object = this.state.getLatest();
        if (this.nl.isError(object)) {
            return this.nl.getError(object);
        }
        return null;
    }
}

