/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.schedulers;

import com.zoyi.rx.Scheduler;
import com.zoyi.rx.annotations.Experimental;
import com.zoyi.rx.internal.schedulers.ExecutorScheduler;
import com.zoyi.rx.internal.schedulers.GenericScheduledExecutorService;
import com.zoyi.rx.internal.schedulers.ImmediateScheduler;
import com.zoyi.rx.internal.schedulers.SchedulerLifecycle;
import com.zoyi.rx.internal.schedulers.TrampolineScheduler;
import com.zoyi.rx.internal.util.RxRingBuffer;
import com.zoyi.rx.plugins.RxJavaHooks;
import com.zoyi.rx.plugins.RxJavaPlugins;
import com.zoyi.rx.plugins.RxJavaSchedulersHook;
import com.zoyi.rx.schedulers.TestScheduler;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;

public final class Schedulers {
    private final Scheduler computationScheduler;
    private final Scheduler ioScheduler;
    private final Scheduler newThreadScheduler;
    private static final AtomicReference<Schedulers> INSTANCE = new AtomicReference();

    private static Schedulers getInstance() {
        Schedulers schedulers;
        while ((schedulers = INSTANCE.get()) == null) {
            schedulers = new Schedulers();
            if (INSTANCE.compareAndSet(null, schedulers)) {
                return schedulers;
            }
            schedulers.shutdownInstance();
        }
        return schedulers;
    }

    private Schedulers() {
        Object object = RxJavaPlugins.getInstance().getSchedulersHook();
        Scheduler scheduler = ((RxJavaSchedulersHook)object).getComputationScheduler();
        this.computationScheduler = scheduler != null ? scheduler : RxJavaSchedulersHook.createComputationScheduler();
        scheduler = ((RxJavaSchedulersHook)object).getIOScheduler();
        this.ioScheduler = scheduler != null ? scheduler : RxJavaSchedulersHook.createIoScheduler();
        object = ((RxJavaSchedulersHook)object).getNewThreadScheduler();
        if (object != null) {
            this.newThreadScheduler = object;
            return;
        }
        this.newThreadScheduler = RxJavaSchedulersHook.createNewThreadScheduler();
    }

    public static Scheduler immediate() {
        return ImmediateScheduler.INSTANCE;
    }

    public static Scheduler trampoline() {
        return TrampolineScheduler.INSTANCE;
    }

    public static Scheduler newThread() {
        return RxJavaHooks.onNewThreadScheduler(Schedulers.getInstance().newThreadScheduler);
    }

    public static Scheduler computation() {
        return RxJavaHooks.onComputationScheduler(Schedulers.getInstance().computationScheduler);
    }

    public static Scheduler io() {
        return RxJavaHooks.onIOScheduler(Schedulers.getInstance().ioScheduler);
    }

    public static TestScheduler test() {
        return new TestScheduler();
    }

    public static Scheduler from(Executor executor) {
        return new ExecutorScheduler(executor);
    }

    @Experimental
    public static void reset() {
        Schedulers schedulers = INSTANCE.getAndSet(null);
        if (schedulers != null) {
            schedulers.shutdownInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start() {
        Schedulers schedulers = Schedulers.getInstance();
        schedulers.startInstance();
        synchronized (schedulers) {
            GenericScheduledExecutorService.INSTANCE.start();
            RxRingBuffer.SPSC_POOL.start();
            RxRingBuffer.SPMC_POOL.start();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        Schedulers schedulers = Schedulers.getInstance();
        schedulers.shutdownInstance();
        synchronized (schedulers) {
            GenericScheduledExecutorService.INSTANCE.shutdown();
            RxRingBuffer.SPSC_POOL.shutdown();
            RxRingBuffer.SPMC_POOL.shutdown();
            return;
        }
    }

    final synchronized void startInstance() {
        if (this.computationScheduler instanceof SchedulerLifecycle) {
            ((SchedulerLifecycle)((Object)this.computationScheduler)).start();
        }
        if (this.ioScheduler instanceof SchedulerLifecycle) {
            ((SchedulerLifecycle)((Object)this.ioScheduler)).start();
        }
        if (this.newThreadScheduler instanceof SchedulerLifecycle) {
            ((SchedulerLifecycle)((Object)this.newThreadScheduler)).start();
        }
    }

    final synchronized void shutdownInstance() {
        if (this.computationScheduler instanceof SchedulerLifecycle) {
            ((SchedulerLifecycle)((Object)this.computationScheduler)).shutdown();
        }
        if (this.ioScheduler instanceof SchedulerLifecycle) {
            ((SchedulerLifecycle)((Object)this.ioScheduler)).shutdown();
        }
        if (this.newThreadScheduler instanceof SchedulerLifecycle) {
            ((SchedulerLifecycle)((Object)this.newThreadScheduler)).shutdown();
        }
    }
}

