/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.plugins;

import com.zoyi.rx.annotations.Experimental;
import com.zoyi.rx.plugins.RxJavaCompletableExecutionHook;
import com.zoyi.rx.plugins.RxJavaErrorHandler;
import com.zoyi.rx.plugins.RxJavaObservableExecutionHook;
import com.zoyi.rx.plugins.RxJavaObservableExecutionHookDefault;
import com.zoyi.rx.plugins.RxJavaPlugins$1;
import com.zoyi.rx.plugins.RxJavaPlugins$2;
import com.zoyi.rx.plugins.RxJavaSchedulersHook;
import com.zoyi.rx.plugins.RxJavaSingleExecutionHook;
import com.zoyi.rx.plugins.RxJavaSingleExecutionHookDefault;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;

public class RxJavaPlugins {
    private static final RxJavaPlugins INSTANCE = new RxJavaPlugins();
    private final AtomicReference<RxJavaErrorHandler> errorHandler = new AtomicReference();
    private final AtomicReference<RxJavaObservableExecutionHook> observableExecutionHook = new AtomicReference();
    private final AtomicReference<RxJavaSingleExecutionHook> singleExecutionHook = new AtomicReference();
    private final AtomicReference<RxJavaCompletableExecutionHook> completableExecutionHook = new AtomicReference();
    private final AtomicReference<RxJavaSchedulersHook> schedulersHook = new AtomicReference();
    static final RxJavaErrorHandler DEFAULT_ERROR_HANDLER = new RxJavaPlugins$1();

    @Deprecated
    public static RxJavaPlugins getInstance() {
        return INSTANCE;
    }

    RxJavaPlugins() {
    }

    @Experimental
    public void reset() {
        RxJavaPlugins.INSTANCE.errorHandler.set(null);
        RxJavaPlugins.INSTANCE.observableExecutionHook.set(null);
        RxJavaPlugins.INSTANCE.singleExecutionHook.set(null);
        RxJavaPlugins.INSTANCE.completableExecutionHook.set(null);
        RxJavaPlugins.INSTANCE.schedulersHook.set(null);
    }

    public RxJavaErrorHandler getErrorHandler() {
        if (this.errorHandler.get() == null) {
            Object object = RxJavaPlugins.getPluginImplementationViaProperty(RxJavaErrorHandler.class, System.getProperties());
            if (object == null) {
                this.errorHandler.compareAndSet(null, DEFAULT_ERROR_HANDLER);
            } else {
                this.errorHandler.compareAndSet(null, (RxJavaErrorHandler)object);
            }
        }
        return this.errorHandler.get();
    }

    public void registerErrorHandler(RxJavaErrorHandler rxJavaErrorHandler) {
        if (!this.errorHandler.compareAndSet(null, rxJavaErrorHandler)) {
            throw new IllegalStateException("Another strategy was already registered: " + this.errorHandler.get());
        }
    }

    public RxJavaObservableExecutionHook getObservableExecutionHook() {
        if (this.observableExecutionHook.get() == null) {
            Object object = RxJavaPlugins.getPluginImplementationViaProperty(RxJavaObservableExecutionHook.class, System.getProperties());
            if (object == null) {
                this.observableExecutionHook.compareAndSet(null, RxJavaObservableExecutionHookDefault.getInstance());
            } else {
                this.observableExecutionHook.compareAndSet(null, (RxJavaObservableExecutionHook)object);
            }
        }
        return this.observableExecutionHook.get();
    }

    public void registerObservableExecutionHook(RxJavaObservableExecutionHook rxJavaObservableExecutionHook) {
        if (!this.observableExecutionHook.compareAndSet(null, rxJavaObservableExecutionHook)) {
            throw new IllegalStateException("Another strategy was already registered: " + this.observableExecutionHook.get());
        }
    }

    public RxJavaSingleExecutionHook getSingleExecutionHook() {
        if (this.singleExecutionHook.get() == null) {
            Object object = RxJavaPlugins.getPluginImplementationViaProperty(RxJavaSingleExecutionHook.class, System.getProperties());
            if (object == null) {
                this.singleExecutionHook.compareAndSet(null, RxJavaSingleExecutionHookDefault.getInstance());
            } else {
                this.singleExecutionHook.compareAndSet(null, (RxJavaSingleExecutionHook)object);
            }
        }
        return this.singleExecutionHook.get();
    }

    public void registerSingleExecutionHook(RxJavaSingleExecutionHook rxJavaSingleExecutionHook) {
        if (!this.singleExecutionHook.compareAndSet(null, rxJavaSingleExecutionHook)) {
            throw new IllegalStateException("Another strategy was already registered: " + this.singleExecutionHook.get());
        }
    }

    @Experimental
    public RxJavaCompletableExecutionHook getCompletableExecutionHook() {
        if (this.completableExecutionHook.get() == null) {
            Object object = RxJavaPlugins.getPluginImplementationViaProperty(RxJavaCompletableExecutionHook.class, System.getProperties());
            if (object == null) {
                this.completableExecutionHook.compareAndSet(null, new RxJavaPlugins$2(this));
            } else {
                this.completableExecutionHook.compareAndSet(null, (RxJavaCompletableExecutionHook)object);
            }
        }
        return this.completableExecutionHook.get();
    }

    @Experimental
    public void registerCompletableExecutionHook(RxJavaCompletableExecutionHook rxJavaCompletableExecutionHook) {
        if (!this.completableExecutionHook.compareAndSet(null, rxJavaCompletableExecutionHook)) {
            throw new IllegalStateException("Another strategy was already registered: " + this.singleExecutionHook.get());
        }
    }

    static Object getPluginImplementationViaProperty(Class<?> clazz, Properties properties) {
        Class<?> clazz2;
        properties = (Properties)properties.clone();
        String string = clazz.getSimpleName();
        String string2 = "rxjava.plugin.";
        String string3 = string2 + string + ".implementation";
        if ((string3 = properties.getProperty(string3)) == null) {
            clazz2 = ".class";
            String string4 = ".impl";
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String string5 = entry.getKey().toString();
                if (!string5.startsWith(string2) || !string5.endsWith((String)((Object)clazz2)) || !string.equals(entry = entry.getValue().toString())) continue;
                string3 = string5.substring(0, string5.length() - ((String)((Object)clazz2)).length()).substring(string2.length());
                string3 = properties.getProperty(string2 = string2 + string3 + string4);
                if (string3 != null) break;
                throw new IllegalStateException("Implementing class declaration for " + string + " missing: " + string2);
            }
        }
        if (string3 != null) {
            try {
                clazz2 = Class.forName(string3);
                clazz2 = clazz2.asSubclass(clazz);
                return clazz2.newInstance();
            }
            catch (ClassCastException classCastException) {
                throw new IllegalStateException(string + " implementation is not an instance of " + string + ": " + string3, classCastException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalStateException(string + " implementation class not found: " + string3, classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                throw new IllegalStateException(string + " implementation not able to be instantiated: " + string3, instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalStateException(string + " implementation not able to be accessed: " + string3, illegalAccessException);
            }
        }
        return null;
    }

    public RxJavaSchedulersHook getSchedulersHook() {
        if (this.schedulersHook.get() == null) {
            Object object = RxJavaPlugins.getPluginImplementationViaProperty(RxJavaSchedulersHook.class, System.getProperties());
            if (object == null) {
                this.schedulersHook.compareAndSet(null, RxJavaSchedulersHook.getDefaultInstance());
            } else {
                this.schedulersHook.compareAndSet(null, (RxJavaSchedulersHook)object);
            }
        }
        return this.schedulersHook.get();
    }

    public void registerSchedulersHook(RxJavaSchedulersHook rxJavaSchedulersHook) {
        if (!this.schedulersHook.compareAndSet(null, rxJavaSchedulersHook)) {
            throw new IllegalStateException("Another strategy was already registered: " + this.schedulersHook.get());
        }
    }
}

