/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.observers;

import com.zoyi.rx.Subscriber;
import com.zoyi.rx.exceptions.CompositeException;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.exceptions.OnCompletedFailedException;
import com.zoyi.rx.exceptions.OnErrorFailedException;
import com.zoyi.rx.exceptions.OnErrorNotImplementedException;
import com.zoyi.rx.exceptions.UnsubscribeFailedException;
import com.zoyi.rx.plugins.RxJavaHooks;
import java.util.Arrays;

public class SafeSubscriber<T>
extends Subscriber<T> {
    private final Subscriber<? super T> actual;
    boolean done;

    public SafeSubscriber(Subscriber<? super T> subscriber) {
        super(subscriber);
        this.actual = subscriber;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onCompleted() {
        if (this.done) return;
        this.done = true;
        try {
            this.actual.onCompleted();
        }
        catch (Throwable throwable) {
            try {
                Throwable throwable3 = throwable;
                Exceptions.throwIfFatal(throwable);
                RxJavaHooks.onError(throwable3);
                throw new OnCompletedFailedException(throwable3.getMessage(), throwable3);
            }
            catch (Throwable throwable4) {
                try {
                    this.unsubscribe();
                    throw throwable4;
                }
                catch (Throwable throwable2) {
                    Throwable throwable6 = throwable2;
                    RxJavaHooks.onError(throwable2);
                    throw new UnsubscribeFailedException(throwable6.getMessage(), throwable6);
                }
            }
        }
        try {
            this.unsubscribe();
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            RxJavaHooks.onError(throwable);
            throw new UnsubscribeFailedException(throwable2.getMessage(), throwable2);
        }
    }

    @Override
    public void onError(Throwable throwable) {
        Exceptions.throwIfFatal(throwable);
        if (!this.done) {
            this.done = true;
            this._onError(throwable);
        }
    }

    @Override
    public void onNext(T object) {
        try {
            if (!this.done) {
                this.actual.onNext(object);
            }
            return;
        }
        catch (Throwable throwable) {
            object = throwable;
            Exceptions.throwOrReport(throwable, this);
            return;
        }
    }

    protected void _onError(Throwable throwable) {
        RxJavaHooks.onError(throwable);
        try {
            this.actual.onError(throwable);
        }
        catch (OnErrorNotImplementedException onErrorNotImplementedException) {
            try {
                this.unsubscribe();
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                RxJavaHooks.onError(throwable2);
                throw new OnErrorNotImplementedException("Observer.onError not implemented and error while unsubscribing.", new CompositeException(Arrays.asList(throwable, throwable3)));
            }
            throw onErrorNotImplementedException;
        }
        catch (Throwable throwable4) {
            Throwable throwable5 = throwable4;
            RxJavaHooks.onError(throwable4);
            try {
                this.unsubscribe();
            }
            catch (Throwable throwable6) {
                Throwable throwable7 = throwable6;
                RxJavaHooks.onError(throwable6);
                throw new OnErrorFailedException("Error occurred when trying to propagate error to Observer.onError and during unsubscription.", new CompositeException(Arrays.asList(throwable, throwable5, throwable7)));
            }
            throw new OnErrorFailedException("Error occurred when trying to propagate error to Observer.onError", new CompositeException(Arrays.asList(throwable, throwable5)));
        }
        try {
            this.unsubscribe();
            return;
        }
        catch (Throwable throwable8) {
            Throwable throwable9 = throwable8;
            RxJavaHooks.onError(throwable8);
            throw new OnErrorFailedException(throwable9);
        }
    }

    public Subscriber<? super T> getActual() {
        return this.actual;
    }
}

