/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.observers;

import com.zoyi.rx.CompletableSubscriber;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.annotations.Experimental;
import com.zoyi.rx.exceptions.CompositeException;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.exceptions.OnCompletedFailedException;
import com.zoyi.rx.exceptions.OnErrorFailedException;
import com.zoyi.rx.plugins.RxJavaHooks;

@Experimental
public final class SafeCompletableSubscriber
implements CompletableSubscriber,
Subscription {
    final CompletableSubscriber actual;
    Subscription s;
    boolean done;

    public SafeCompletableSubscriber(CompletableSubscriber completableSubscriber) {
        this.actual = completableSubscriber;
    }

    @Override
    public final void onCompleted() {
        if (this.done) {
            return;
        }
        this.done = true;
        try {
            this.actual.onCompleted();
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Exceptions.throwIfFatal(throwable);
            throw new OnCompletedFailedException(throwable2);
        }
    }

    @Override
    public final void onError(Throwable throwable) {
        RxJavaHooks.onError(throwable);
        if (this.done) {
            return;
        }
        this.done = true;
        try {
            this.actual.onError(throwable);
            return;
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            Exceptions.throwIfFatal(throwable2);
            throw new OnErrorFailedException(new CompositeException(throwable, throwable3));
        }
    }

    @Override
    public final void onSubscribe(Subscription subscription) {
        this.s = subscription;
        try {
            this.actual.onSubscribe(this);
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Exceptions.throwIfFatal(throwable);
            subscription.unsubscribe();
            this.onError(throwable2);
            return;
        }
    }

    @Override
    public final void unsubscribe() {
        this.s.unsubscribe();
    }

    @Override
    public final boolean isUnsubscribed() {
        return this.done || this.s.isUnsubscribed();
    }
}

