/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.observables;

import com.zoyi.rx.Observable;
import com.zoyi.rx.Observer;
import com.zoyi.rx.Producer;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.annotations.Experimental;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.functions.Action0;
import com.zoyi.rx.functions.Action1;
import com.zoyi.rx.functions.Actions;
import com.zoyi.rx.functions.Func1;
import com.zoyi.rx.internal.operators.BlockingOperatorLatest;
import com.zoyi.rx.internal.operators.BlockingOperatorMostRecent;
import com.zoyi.rx.internal.operators.BlockingOperatorNext;
import com.zoyi.rx.internal.operators.BlockingOperatorToFuture;
import com.zoyi.rx.internal.operators.BlockingOperatorToIterator;
import com.zoyi.rx.internal.operators.NotificationLite;
import com.zoyi.rx.internal.util.BlockingUtils;
import com.zoyi.rx.internal.util.UtilityFunctions;
import com.zoyi.rx.observables.BlockingObservable$1;
import com.zoyi.rx.observables.BlockingObservable$2;
import com.zoyi.rx.observables.BlockingObservable$3;
import com.zoyi.rx.observables.BlockingObservable$4;
import com.zoyi.rx.observables.BlockingObservable$5;
import com.zoyi.rx.observables.BlockingObservable$6;
import com.zoyi.rx.observables.BlockingObservable$7;
import com.zoyi.rx.observables.BlockingObservable$8;
import com.zoyi.rx.observables.BlockingObservable$9;
import com.zoyi.rx.subscriptions.Subscriptions;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;

public final class BlockingObservable<T> {
    private final Observable<? extends T> o;
    static final Object ON_START = new Object();
    static final Object SET_PRODUCER = new Object();
    static final Object UNSUBSCRIBE = new Object();

    private BlockingObservable(Observable<? extends T> observable) {
        this.o = observable;
    }

    public static <T> BlockingObservable<T> from(Observable<? extends T> observable) {
        return new BlockingObservable<T>(observable);
    }

    public final void forEach(Action1<? super T> object) {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        AtomicReference atomicReference = new AtomicReference();
        object = this.o.subscribe(new BlockingObservable$1(this, countDownLatch, atomicReference, (Action1)object));
        BlockingUtils.awaitForComplete(countDownLatch, (Subscription)object);
        if (atomicReference.get() != null) {
            Exceptions.propagate((Throwable)atomicReference.get());
        }
    }

    public final Iterator<T> getIterator() {
        return BlockingOperatorToIterator.toIterator(this.o);
    }

    public final T first() {
        return this.blockForSingle(this.o.first());
    }

    public final T first(Func1<? super T, Boolean> func1) {
        return this.blockForSingle(this.o.first(func1));
    }

    public final T firstOrDefault(T t2) {
        return this.blockForSingle(this.o.map(UtilityFunctions.identity()).firstOrDefault(t2));
    }

    public final T firstOrDefault(T t2, Func1<? super T, Boolean> func1) {
        return this.blockForSingle(this.o.filter(func1).map(UtilityFunctions.identity()).firstOrDefault(t2));
    }

    public final T last() {
        return this.blockForSingle(this.o.last());
    }

    public final T last(Func1<? super T, Boolean> func1) {
        return this.blockForSingle(this.o.last(func1));
    }

    public final T lastOrDefault(T t2) {
        return this.blockForSingle(this.o.map(UtilityFunctions.identity()).lastOrDefault(t2));
    }

    public final T lastOrDefault(T t2, Func1<? super T, Boolean> func1) {
        return this.blockForSingle(this.o.filter(func1).map(UtilityFunctions.identity()).lastOrDefault(t2));
    }

    public final Iterable<T> mostRecent(T t2) {
        return BlockingOperatorMostRecent.mostRecent(this.o, t2);
    }

    public final Iterable<T> next() {
        return BlockingOperatorNext.next(this.o);
    }

    public final Iterable<T> latest() {
        return BlockingOperatorLatest.latest(this.o);
    }

    public final T single() {
        return this.blockForSingle(this.o.single());
    }

    public final T single(Func1<? super T, Boolean> func1) {
        return this.blockForSingle(this.o.single(func1));
    }

    public final T singleOrDefault(T t2) {
        return this.blockForSingle(this.o.map(UtilityFunctions.identity()).singleOrDefault(t2));
    }

    public final T singleOrDefault(T t2, Func1<? super T, Boolean> func1) {
        return this.blockForSingle(this.o.filter(func1).map(UtilityFunctions.identity()).singleOrDefault(t2));
    }

    public final Future<T> toFuture() {
        return BlockingOperatorToFuture.toFuture(this.o);
    }

    public final Iterable<T> toIterable() {
        return new BlockingObservable$2(this);
    }

    private T blockForSingle(Observable<? extends T> object) {
        AtomicReference atomicReference = new AtomicReference();
        AtomicReference atomicReference2 = new AtomicReference();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        object = ((Observable)object).subscribe(new BlockingObservable$3(this, countDownLatch, atomicReference2, atomicReference));
        BlockingUtils.awaitForComplete(countDownLatch, (Subscription)object);
        if (atomicReference2.get() != null) {
            Exceptions.propagate((Throwable)atomicReference2.get());
        }
        return (T)atomicReference.get();
    }

    @Experimental
    public final void subscribe() {
        Object object = new CountDownLatch(1);
        Throwable[] throwableArray = new Throwable[]{null};
        Subscription subscription = this.o.subscribe(new BlockingObservable$4(this, throwableArray, (CountDownLatch)object));
        BlockingUtils.awaitForComplete((CountDownLatch)object, subscription);
        object = throwableArray[0];
        if (object != null) {
            Exceptions.propagate((Throwable)object);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Experimental
    public final void subscribe(Observer<? super T> observer) {
        NotificationLite<T> notificationLite = NotificationLite.instance();
        LinkedBlockingQueue linkedBlockingQueue = new LinkedBlockingQueue();
        Subscription subscription = this.o.subscribe(new BlockingObservable$5(this, linkedBlockingQueue, notificationLite));
        try {
            Object e2;
            do {
                if ((e2 = linkedBlockingQueue.poll()) != null) continue;
                e2 = linkedBlockingQueue.take();
            } while (!notificationLite.accept(observer, e2));
            return;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            observer.onError(interruptedException);
            return;
        }
        finally {
            subscription.unsubscribe();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Experimental
    public final void subscribe(Subscriber<? super T> subscriber) {
        NotificationLite<T> notificationLite = NotificationLite.instance();
        LinkedBlockingQueue linkedBlockingQueue = new LinkedBlockingQueue();
        Producer[] producerArray = new Producer[]{null};
        BlockingObservable$6 blockingObservable$6 = new BlockingObservable$6(this, linkedBlockingQueue, notificationLite, producerArray);
        subscriber.add(blockingObservable$6);
        subscriber.add(Subscriptions.create(new BlockingObservable$7(this, linkedBlockingQueue)));
        this.o.subscribe(blockingObservable$6);
        try {
            while (!subscriber.isUnsubscribed()) {
                Object e2 = linkedBlockingQueue.poll();
                if (e2 == null) {
                    e2 = linkedBlockingQueue.take();
                }
                if (subscriber.isUnsubscribed()) return;
                if (e2 == UNSUBSCRIBE) return;
                if (e2 == ON_START) {
                    subscriber.onStart();
                    continue;
                }
                if (e2 == SET_PRODUCER) {
                    subscriber.setProducer(producerArray[0]);
                    continue;
                }
                if (notificationLite.accept(subscriber, e2)) return;
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            subscriber.onError(interruptedException);
            return;
        }
        finally {
            blockingObservable$6.unsubscribe();
        }
    }

    @Experimental
    public final void subscribe(Action1<? super T> action1) {
        this.subscribe(action1, new BlockingObservable$8(this), Actions.empty());
    }

    @Experimental
    public final void subscribe(Action1<? super T> action1, Action1<? super Throwable> action12) {
        this.subscribe(action1, action12, Actions.empty());
    }

    @Experimental
    public final void subscribe(Action1<? super T> action1, Action1<? super Throwable> action12, Action0 action0) {
        this.subscribe(new BlockingObservable$9(this, action1, action12, action0));
    }
}

