/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.util.unsafe;

import com.zoyi.rx.internal.util.SuppressAnimalSniffer;
import com.zoyi.rx.internal.util.unsafe.ConcurrentCircularArrayQueueL0Pad;
import com.zoyi.rx.internal.util.unsafe.Pow2;
import com.zoyi.rx.internal.util.unsafe.UnsafeAccess;
import java.util.Iterator;

@SuppressAnimalSniffer
public abstract class ConcurrentCircularArrayQueue<E>
extends ConcurrentCircularArrayQueueL0Pad<E> {
    protected static final int SPARSE_SHIFT = Integer.getInteger("sparse.shift", 0);
    protected static final int BUFFER_PAD = 32;
    private static final long REF_ARRAY_BASE;
    private static final int REF_ELEMENT_SHIFT;
    protected final long mask;
    protected final E[] buffer;

    public ConcurrentCircularArrayQueue(int n2) {
        n2 = Pow2.roundToPowerOfTwo(n2);
        this.mask = n2 - 1;
        this.buffer = new Object[(n2 << SPARSE_SHIFT) + 64];
    }

    protected final long calcElementOffset(long l2) {
        return this.calcElementOffset(l2, this.mask);
    }

    protected final long calcElementOffset(long l2, long l3) {
        return REF_ARRAY_BASE + ((l2 & l3) << REF_ELEMENT_SHIFT);
    }

    protected final void spElement(long l2, E e2) {
        this.spElement(this.buffer, l2, e2);
    }

    protected final void spElement(E[] EArray, long l2, E e2) {
        UnsafeAccess.UNSAFE.putObject(EArray, l2, e2);
    }

    protected final void soElement(long l2, E e2) {
        this.soElement(this.buffer, l2, e2);
    }

    protected final void soElement(E[] EArray, long l2, E e2) {
        UnsafeAccess.UNSAFE.putOrderedObject(EArray, l2, e2);
    }

    protected final E lpElement(long l2) {
        return this.lpElement(this.buffer, l2);
    }

    protected final E lpElement(E[] EArray, long l2) {
        return (E)UnsafeAccess.UNSAFE.getObject(EArray, l2);
    }

    protected final E lvElement(long l2) {
        return this.lvElement(this.buffer, l2);
    }

    protected final E lvElement(E[] EArray, long l2) {
        return (E)UnsafeAccess.UNSAFE.getObjectVolatile(EArray, l2);
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        while (this.poll() != null || !this.isEmpty()) {
        }
    }

    static {
        int n2 = UnsafeAccess.UNSAFE.arrayIndexScale(Object[].class);
        if (4 == n2) {
            REF_ELEMENT_SHIFT = 2 + SPARSE_SHIFT;
        } else if (8 == n2) {
            REF_ELEMENT_SHIFT = 3 + SPARSE_SHIFT;
        } else {
            throw new IllegalStateException("Unknown pointer size");
        }
        REF_ARRAY_BASE = UnsafeAccess.UNSAFE.arrayBaseOffset(Object[].class) + (32 << REF_ELEMENT_SHIFT - SPARSE_SHIFT);
    }
}

