/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.util.atomic;

import com.zoyi.rx.internal.util.unsafe.Pow2;
import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class SpscExactAtomicArrayQueue<T>
extends AtomicReferenceArray<T>
implements Queue<T> {
    private static final long serialVersionUID = 6210984603741293445L;
    final int mask;
    final int capacitySkip;
    final AtomicLong producerIndex;
    final AtomicLong consumerIndex;

    public SpscExactAtomicArrayQueue(int n2) {
        super(Pow2.roundToPowerOfTwo(n2));
        int n3 = this.length();
        this.mask = n3 - 1;
        this.capacitySkip = n3 - n2;
        this.producerIndex = new AtomicLong();
        this.consumerIndex = new AtomicLong();
    }

    @Override
    public final boolean offer(T t2) {
        int n2;
        if (t2 == null) {
            throw new NullPointerException();
        }
        long l2 = this.producerIndex.get();
        int n3 = (int)(l2 + (long)this.capacitySkip) & (n2 = this.mask);
        if (this.get(n3) != null) {
            return false;
        }
        n2 = (int)l2 & n2;
        this.producerIndex.lazySet(l2 + 1L);
        this.lazySet(n2, t2);
        return true;
    }

    @Override
    public final T poll() {
        long l2 = this.consumerIndex.get();
        int n2 = (int)l2 & this.mask;
        Object e2 = this.get(n2);
        if (e2 == null) {
            return null;
        }
        this.consumerIndex.lazySet(l2 + 1L);
        this.lazySet(n2, null);
        return (T)e2;
    }

    @Override
    public final T peek() {
        return (T)this.get((int)this.consumerIndex.get() & this.mask);
    }

    @Override
    public final void clear() {
        while (this.poll() != null || !this.isEmpty()) {
        }
    }

    @Override
    public final boolean isEmpty() {
        return this.producerIndex == this.consumerIndex;
    }

    @Override
    public final int size() {
        long l2 = this.consumerIndex.get();
        while (true) {
            long l3 = this.producerIndex.get();
            long l4 = this.consumerIndex.get();
            if (l2 == l4) {
                return (int)(l3 - l4);
            }
            l2 = l4;
        }
    }

    @Override
    public final boolean contains(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Iterator<T> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final <E> E[] toArray(E[] EArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean containsAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean addAll(Collection<? extends T> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean add(T t2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final T remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final T element() {
        throw new UnsupportedOperationException();
    }
}

