/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.util.atomic;

import com.zoyi.rx.internal.util.atomic.AtomicReferenceArrayQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class SpscAtomicArrayQueue<E>
extends AtomicReferenceArrayQueue<E> {
    private static final Integer MAX_LOOK_AHEAD_STEP = Integer.getInteger("jctools.spsc.max.lookahead.step", 4096);
    final AtomicLong producerIndex = new AtomicLong();
    long producerLookAhead;
    final AtomicLong consumerIndex = new AtomicLong();
    final int lookAheadStep;

    public SpscAtomicArrayQueue(int n2) {
        super(n2);
        this.lookAheadStep = Math.min(n2 / 4, MAX_LOOK_AHEAD_STEP);
    }

    @Override
    public final boolean offer(E e2) {
        if (e2 == null) {
            throw new NullPointerException("Null is not a valid element");
        }
        AtomicReferenceArray atomicReferenceArray = this.buffer;
        int n2 = this.mask;
        long l2 = this.producerIndex.get();
        int n3 = this.calcElementOffset(l2, n2);
        if (l2 >= this.producerLookAhead) {
            int n4 = this.lookAheadStep;
            if (null == this.lvElement(atomicReferenceArray, this.calcElementOffset(l2 + (long)n4, n2))) {
                this.producerLookAhead = l2 + (long)n4;
            } else if (null != this.lvElement(atomicReferenceArray, n3)) {
                return false;
            }
        }
        this.soElement(atomicReferenceArray, n3, e2);
        this.soProducerIndex(l2 + 1L);
        return true;
    }

    @Override
    public final E poll() {
        AtomicReferenceArray atomicReferenceArray = this.buffer;
        long l2 = this.consumerIndex.get();
        int n2 = this.calcElementOffset(l2);
        Object e2 = this.lvElement(atomicReferenceArray, n2);
        if (e2 == null) {
            return null;
        }
        this.soElement(atomicReferenceArray, n2, null);
        this.soConsumerIndex(l2 + 1L);
        return e2;
    }

    @Override
    public final E peek() {
        return this.lvElement(this.calcElementOffset(this.consumerIndex.get()));
    }

    @Override
    public final int size() {
        long l2;
        long l3;
        long l4 = this.lvConsumerIndex();
        do {
            l3 = l4;
            l2 = this.lvProducerIndex();
        } while (l3 != (l4 = this.lvConsumerIndex()));
        return (int)(l2 - l4);
    }

    @Override
    public final boolean isEmpty() {
        return this.lvProducerIndex() == this.lvConsumerIndex();
    }

    private void soProducerIndex(long l2) {
        this.producerIndex.lazySet(l2);
    }

    private void soConsumerIndex(long l2) {
        this.consumerIndex.lazySet(l2);
    }

    private long lvConsumerIndex() {
        return this.consumerIndex.get();
    }

    private long lvProducerIndex() {
        return this.producerIndex.get();
    }
}

