/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.util;

import com.zoyi.rx.functions.Action1;
import com.zoyi.rx.internal.util.unsafe.Pow2;
import java.util.Arrays;

public final class OpenHashSet<T> {
    final float loadFactor;
    int mask;
    int size;
    int maxSize;
    T[] keys;
    private static final int INT_PHI = -1640531527;

    public OpenHashSet() {
        this(16, 0.75f);
    }

    public OpenHashSet(int n2) {
        this(n2, 0.75f);
    }

    public OpenHashSet(int n2, float f2) {
        this.loadFactor = f2;
        n2 = Pow2.roundToPowerOfTwo(n2);
        this.mask = n2 - 1;
        this.maxSize = (int)(f2 * (float)n2);
        this.keys = new Object[n2];
    }

    public final boolean add(T t2) {
        T[] TArray = this.keys;
        int n2 = this.mask;
        int n3 = OpenHashSet.mix(t2.hashCode()) & n2;
        T t3 = TArray[n3];
        if (t3 != null) {
            if (t3.equals(t2)) {
                return false;
            }
            while ((t3 = TArray[n3 = n3 + 1 & n2]) != null) {
                if (!t3.equals(t2)) continue;
                return false;
            }
        }
        TArray[n3] = t2;
        if (++this.size >= this.maxSize) {
            this.rehash();
        }
        return true;
    }

    public final boolean remove(T t2) {
        T[] TArray = this.keys;
        int n2 = this.mask;
        int n3 = OpenHashSet.mix(t2.hashCode()) & n2;
        T t3 = TArray[n3];
        if (t3 == null) {
            return false;
        }
        if (t3.equals(t2)) {
            return this.removeEntry(n3, TArray, n2);
        }
        do {
            if ((t3 = TArray[n3 = n3 + 1 & n2]) != null) continue;
            return false;
        } while (!t3.equals(t2));
        return this.removeEntry(n3, TArray, n2);
    }

    final boolean removeEntry(int n2, T[] TArray, int n3) {
        --this.size;
        while (true) {
            T t2;
            int n4 = n2;
            n2 = n2 + 1 & n3;
            while (true) {
                if ((t2 = TArray[n2]) == null) {
                    TArray[n4] = null;
                    return true;
                }
                int n5 = OpenHashSet.mix(t2.hashCode()) & n3;
                if (n4 > n2 ? n4 >= n5 && n5 > n2 : n4 >= n5 || n5 > n2) break;
                n2 = n2 + 1 & n3;
            }
            TArray[n4] = t2;
        }
    }

    public final void clear(Action1<? super T> action1) {
        if (this.size == 0) {
            return;
        }
        Object[] objectArray = this.keys;
        int n2 = this.keys.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            T t2 = objectArray[i2];
            if (t2 == null) continue;
            action1.call(t2);
        }
        Arrays.fill(objectArray, null);
        this.size = 0;
    }

    public final void terminate() {
        this.size = 0;
        this.keys = new Object[0];
    }

    final void rehash() {
        T[] TArray = this.keys;
        int n2 = this.keys.length;
        int n3 = n2 << 1;
        int n4 = n3 - 1;
        Object[] objectArray = new Object[n3];
        int n5 = this.size;
        while (n5-- != 0) {
            while (TArray[--n2] == null) {
            }
            int n6 = OpenHashSet.mix(TArray[n2].hashCode()) & n4;
            if (objectArray[n6] != null) {
                while (objectArray[n6 = n6 + 1 & n4] != null) {
                }
            }
            objectArray[n6] = TArray[n2];
        }
        this.mask = n4;
        this.maxSize = (int)((float)n3 * this.loadFactor);
        this.keys = objectArray;
    }

    static int mix(int n2) {
        return (n2 *= -1640531527) ^ n2 >>> 16;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public final T[] values() {
        return this.keys;
    }
}

