/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.util;

import com.zoyi.rx.internal.schedulers.GenericScheduledExecutorService;
import com.zoyi.rx.internal.schedulers.SchedulerLifecycle;
import com.zoyi.rx.internal.util.ObjectPool$1;
import com.zoyi.rx.internal.util.unsafe.MpmcArrayQueue;
import com.zoyi.rx.internal.util.unsafe.UnsafeAccess;
import com.zoyi.rx.plugins.RxJavaHooks;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public abstract class ObjectPool<T>
implements SchedulerLifecycle {
    Queue<T> pool;
    final int minSize;
    final int maxSize;
    private final long validationInterval;
    private final AtomicReference<Future<?>> periodicTask;

    public ObjectPool() {
        this(0, 0, 67L);
    }

    private ObjectPool(int n2, int n3, long l2) {
        this.minSize = n2;
        this.maxSize = n3;
        this.validationInterval = l2;
        this.periodicTask = new AtomicReference();
        this.initialize(n2);
        this.start();
    }

    public T borrowObject() {
        T t2 = this.pool.poll();
        if (t2 == null) {
            t2 = this.createObject();
        }
        return t2;
    }

    public void returnObject(T t2) {
        if (t2 == null) {
            return;
        }
        this.pool.offer(t2);
    }

    @Override
    public void shutdown() {
        Future future = this.periodicTask.getAndSet(null);
        if (future != null) {
            future.cancel(false);
        }
    }

    @Override
    public void start() {
        while (true) {
            if (this.periodicTask.get() != null) {
                return;
            }
            ScheduledFuture<?> scheduledFuture = GenericScheduledExecutorService.getInstance();
            try {
                scheduledFuture = scheduledFuture.scheduleAtFixedRate(new ObjectPool$1(this), this.validationInterval, this.validationInterval, TimeUnit.SECONDS);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                scheduledFuture = rejectedExecutionException;
                RxJavaHooks.onError(rejectedExecutionException);
                return;
            }
            if (this.periodicTask.compareAndSet(null, scheduledFuture)) break;
            scheduledFuture.cancel(false);
        }
    }

    protected abstract T createObject();

    private void initialize(int n2) {
        this.pool = UnsafeAccess.isUnsafeAvailable() ? new MpmcArrayQueue<T>(Math.max(this.maxSize, 1024)) : new ConcurrentLinkedQueue<T>();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.pool.add(this.createObject());
        }
    }
}

