/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.subscriptions;

import com.zoyi.rx.Subscription;
import com.zoyi.rx.internal.subscriptions.Unsubscribed;
import com.zoyi.rx.subscriptions.Subscriptions;
import java.util.concurrent.atomic.AtomicReference;

public final class SequentialSubscription
extends AtomicReference<Subscription>
implements Subscription {
    private static final long serialVersionUID = 995205034283130269L;

    public SequentialSubscription() {
    }

    public SequentialSubscription(Subscription subscription) {
        this.lazySet(subscription);
    }

    public final Subscription current() {
        Subscription subscription = (Subscription)super.get();
        if (subscription == Unsubscribed.INSTANCE) {
            return Subscriptions.unsubscribed();
        }
        return subscription;
    }

    public final boolean update(Subscription subscription) {
        Subscription subscription2;
        do {
            if ((subscription2 = (Subscription)this.get()) != Unsubscribed.INSTANCE) continue;
            if (subscription != null) {
                subscription.unsubscribe();
            }
            return false;
        } while (!this.compareAndSet(subscription2, subscription));
        if (subscription2 != null) {
            subscription2.unsubscribe();
        }
        return true;
    }

    public final boolean replace(Subscription subscription) {
        Subscription subscription2;
        do {
            if ((subscription2 = (Subscription)this.get()) != Unsubscribed.INSTANCE) continue;
            if (subscription != null) {
                subscription.unsubscribe();
            }
            return false;
        } while (!this.compareAndSet(subscription2, subscription));
        return true;
    }

    public final boolean updateWeak(Subscription subscription) {
        Subscription subscription2 = (Subscription)this.get();
        if (subscription2 == Unsubscribed.INSTANCE) {
            if (subscription != null) {
                subscription.unsubscribe();
            }
            return false;
        }
        if (this.compareAndSet(subscription2, subscription)) {
            return true;
        }
        subscription2 = (Subscription)this.get();
        if (subscription != null) {
            subscription.unsubscribe();
        }
        return subscription2 == Unsubscribed.INSTANCE;
    }

    public final boolean replaceWeak(Subscription subscription) {
        Subscription subscription2 = (Subscription)this.get();
        if (subscription2 == Unsubscribed.INSTANCE) {
            if (subscription != null) {
                subscription.unsubscribe();
            }
            return false;
        }
        if (this.compareAndSet(subscription2, subscription)) {
            return true;
        }
        subscription2 = (Subscription)this.get();
        if (subscription2 == Unsubscribed.INSTANCE) {
            if (subscription != null) {
                subscription.unsubscribe();
            }
            return false;
        }
        return true;
    }

    @Override
    public final void unsubscribe() {
        Subscription subscription = (Subscription)this.get();
        if (subscription != Unsubscribed.INSTANCE && (subscription = (Subscription)this.getAndSet(Unsubscribed.INSTANCE)) != null && subscription != Unsubscribed.INSTANCE) {
            subscription.unsubscribe();
        }
    }

    @Override
    public final boolean isUnsubscribed() {
        return this.get() == Unsubscribed.INSTANCE;
    }
}

