/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.schedulers;

import com.zoyi.rx.Scheduler$Worker;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.functions.Action0;

class SleepingAction
implements Action0 {
    private final Action0 underlying;
    private final Scheduler$Worker innerScheduler;
    private final long execTime;

    public SleepingAction(Action0 action0, Scheduler$Worker scheduler$Worker, long l2) {
        this.underlying = action0;
        this.innerScheduler = scheduler$Worker;
        this.execTime = l2;
    }

    @Override
    public void call() {
        if (this.innerScheduler.isUnsubscribed()) {
            return;
        }
        long l2 = this.execTime - this.innerScheduler.now();
        if (l2 > 0L) {
            try {
                Thread.sleep(l2);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                Exceptions.propagate(interruptedException);
            }
        }
        if (this.innerScheduler.isUnsubscribed()) {
            return;
        }
        this.underlying.call();
    }
}

