/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.schedulers;

import com.zoyi.rx.internal.schedulers.GenericScheduledExecutorServiceFactory;
import com.zoyi.rx.internal.schedulers.NewThreadWorker;
import com.zoyi.rx.internal.schedulers.SchedulerLifecycle;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicReference;

public final class GenericScheduledExecutorService
implements SchedulerLifecycle {
    private static final ScheduledExecutorService[] NONE = new ScheduledExecutorService[0];
    private static final ScheduledExecutorService SHUTDOWN = Executors.newScheduledThreadPool(0);
    public static final GenericScheduledExecutorService INSTANCE;
    private final AtomicReference<ScheduledExecutorService[]> executor = new AtomicReference<ScheduledExecutorService[]>(NONE);
    private static int roundRobin;

    private GenericScheduledExecutorService() {
        this.start();
    }

    @Override
    public final void start() {
        int n2 = Runtime.getRuntime().availableProcessors();
        if (n2 > 4) {
            n2 /= 2;
        }
        if (n2 > 8) {
            n2 = 8;
        }
        ScheduledExecutorService[] scheduledExecutorServiceArray = new ScheduledExecutorService[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            scheduledExecutorServiceArray[i2] = GenericScheduledExecutorServiceFactory.create();
        }
        if (this.executor.compareAndSet(NONE, scheduledExecutorServiceArray)) {
            ScheduledExecutorService[] scheduledExecutorServiceArray2 = scheduledExecutorServiceArray;
            n2 = scheduledExecutorServiceArray.length;
            for (int i3 = 0; i3 < n2; ++i3) {
                ScheduledExecutorService scheduledExecutorService = scheduledExecutorServiceArray2[i3];
                if (NewThreadWorker.tryEnableCancelPolicy(scheduledExecutorService) || !(scheduledExecutorService instanceof ScheduledThreadPoolExecutor)) continue;
                NewThreadWorker.registerExecutor((ScheduledThreadPoolExecutor)scheduledExecutorService);
            }
            return;
        }
        ScheduledExecutorService[] scheduledExecutorServiceArray3 = scheduledExecutorServiceArray;
        n2 = scheduledExecutorServiceArray.length;
        for (int i4 = 0; i4 < n2; ++i4) {
            ScheduledExecutorService scheduledExecutorService = scheduledExecutorServiceArray3[i4];
            scheduledExecutorService.shutdownNow();
        }
    }

    @Override
    public final void shutdown() {
        ScheduledExecutorService[] scheduledExecutorServiceArray;
        do {
            if ((scheduledExecutorServiceArray = this.executor.get()) != NONE) continue;
            return;
        } while (!this.executor.compareAndSet(scheduledExecutorServiceArray, NONE));
        for (ScheduledExecutorService scheduledExecutorService : scheduledExecutorServiceArray) {
            NewThreadWorker.deregisterExecutor(scheduledExecutorService);
            scheduledExecutorService.shutdownNow();
        }
    }

    public static ScheduledExecutorService getInstance() {
        ScheduledExecutorService[] scheduledExecutorServiceArray = GenericScheduledExecutorService.INSTANCE.executor.get();
        if (scheduledExecutorServiceArray == NONE) {
            return SHUTDOWN;
        }
        int n2 = roundRobin + 1;
        if (n2 >= scheduledExecutorServiceArray.length) {
            n2 = 0;
        }
        roundRobin = n2;
        return scheduledExecutorServiceArray[n2];
    }

    static {
        SHUTDOWN.shutdown();
        INSTANCE = new GenericScheduledExecutorService();
    }
}

