/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.schedulers;

import com.zoyi.rx.Scheduler$Worker;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.functions.Action0;
import com.zoyi.rx.internal.schedulers.ExecutorScheduler$ExecutorSchedulerWorker$1;
import com.zoyi.rx.internal.schedulers.ExecutorScheduler$ExecutorSchedulerWorker$2;
import com.zoyi.rx.internal.schedulers.GenericScheduledExecutorService;
import com.zoyi.rx.internal.schedulers.ScheduledAction;
import com.zoyi.rx.plugins.RxJavaHooks;
import com.zoyi.rx.subscriptions.CompositeSubscription;
import com.zoyi.rx.subscriptions.MultipleAssignmentSubscription;
import com.zoyi.rx.subscriptions.Subscriptions;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

final class ExecutorScheduler$ExecutorSchedulerWorker
extends Scheduler$Worker
implements Runnable {
    final Executor executor;
    final CompositeSubscription tasks;
    final ConcurrentLinkedQueue<ScheduledAction> queue;
    final AtomicInteger wip;
    final ScheduledExecutorService service;

    public ExecutorScheduler$ExecutorSchedulerWorker(Executor executor) {
        this.executor = executor;
        this.queue = new ConcurrentLinkedQueue();
        this.wip = new AtomicInteger();
        this.tasks = new CompositeSubscription();
        this.service = GenericScheduledExecutorService.getInstance();
    }

    @Override
    public final Subscription schedule(Action0 object) {
        if (this.isUnsubscribed()) {
            return Subscriptions.unsubscribed();
        }
        object = RxJavaHooks.onScheduledAction((Action0)object);
        object = new ScheduledAction((Action0)object, this.tasks);
        this.tasks.add((Subscription)object);
        this.queue.offer((ScheduledAction)object);
        if (this.wip.getAndIncrement() == 0) {
            try {
                this.executor.execute(this);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                this.tasks.remove((Subscription)object);
                this.wip.decrementAndGet();
                RxJavaHooks.onError(rejectedExecutionException);
                throw rejectedExecutionException;
            }
        }
        return object;
    }

    @Override
    public final void run() {
        do {
            if (this.tasks.isUnsubscribed()) {
                this.queue.clear();
                return;
            }
            ScheduledAction scheduledAction = this.queue.poll();
            if (scheduledAction == null) {
                return;
            }
            if (scheduledAction.isUnsubscribed()) continue;
            if (!this.tasks.isUnsubscribed()) {
                scheduledAction.run();
                continue;
            }
            this.queue.clear();
            return;
        } while (this.wip.decrementAndGet() != 0);
    }

    @Override
    public final Subscription schedule(Action0 object, long l2, TimeUnit timeUnit) {
        if (l2 <= 0L) {
            return this.schedule((Action0)object);
        }
        if (this.isUnsubscribed()) {
            return Subscriptions.unsubscribed();
        }
        object = RxJavaHooks.onScheduledAction((Action0)object);
        MultipleAssignmentSubscription multipleAssignmentSubscription = new MultipleAssignmentSubscription();
        MultipleAssignmentSubscription multipleAssignmentSubscription2 = new MultipleAssignmentSubscription();
        multipleAssignmentSubscription2.set(multipleAssignmentSubscription);
        this.tasks.add(multipleAssignmentSubscription2);
        Subscription subscription = Subscriptions.create(new ExecutorScheduler$ExecutorSchedulerWorker$1(this, multipleAssignmentSubscription2));
        object = new ScheduledAction(new ExecutorScheduler$ExecutorSchedulerWorker$2(this, multipleAssignmentSubscription2, (Action0)object, subscription));
        multipleAssignmentSubscription.set((Subscription)object);
        try {
            ScheduledFuture<?> scheduledFuture = this.service.schedule((Runnable)object, l2, timeUnit);
            ((ScheduledAction)object).add(scheduledFuture);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            RejectedExecutionException rejectedExecutionException2 = rejectedExecutionException;
            RxJavaHooks.onError(rejectedExecutionException);
            throw rejectedExecutionException2;
        }
        return subscription;
    }

    @Override
    public final boolean isUnsubscribed() {
        return this.tasks.isUnsubscribed();
    }

    @Override
    public final void unsubscribe() {
        this.tasks.unsubscribe();
        this.queue.clear();
    }
}

