/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.producers;

import com.zoyi.rx.Producer;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.internal.operators.BackpressureUtils;
import com.zoyi.rx.internal.util.atomic.SpscLinkedAtomicQueue;
import com.zoyi.rx.internal.util.unsafe.SpscLinkedQueue;
import com.zoyi.rx.internal.util.unsafe.UnsafeAccess;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class QueuedValueProducer<T>
extends AtomicLong
implements Producer {
    private static final long serialVersionUID = 7277121710709137047L;
    final Subscriber<? super T> child;
    final Queue<Object> queue;
    final AtomicInteger wip;
    static final Object NULL_SENTINEL = new Object();

    public QueuedValueProducer(Subscriber<? super T> subscriber) {
        this(subscriber, UnsafeAccess.isUnsafeAvailable() ? new SpscLinkedQueue() : new SpscLinkedAtomicQueue());
    }

    public QueuedValueProducer(Subscriber<? super T> subscriber, Queue<Object> queue) {
        this.child = subscriber;
        this.queue = queue;
        this.wip = new AtomicInteger();
    }

    @Override
    public final void request(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("n >= 0 required");
        }
        if (l2 > 0L) {
            BackpressureUtils.getAndAddRequest(this, l2);
            this.drain();
        }
    }

    public final boolean offer(T t2) {
        if (t2 == null ? !this.queue.offer(NULL_SENTINEL) : !this.queue.offer(t2)) {
            return false;
        }
        this.drain();
        return true;
    }

    private void drain() {
        if (this.wip.getAndIncrement() == 0) {
            Subscriber<Object> subscriber = this.child;
            Queue<Object> queue = this.queue;
            do {
                Object object;
                if (subscriber.isUnsubscribed()) {
                    return;
                }
                this.wip.lazySet(1);
                long l2 = this.get();
                long l3 = 0L;
                while (l2 != 0L && (object = queue.poll()) != null) {
                    Object object2;
                    try {
                        if (object == NULL_SENTINEL) {
                            subscriber.onNext(null);
                        } else {
                            object2 = object;
                            subscriber.onNext(object2);
                        }
                    }
                    catch (Throwable throwable) {
                        object2 = throwable;
                        Exceptions.throwOrReport(throwable, subscriber, object != NULL_SENTINEL ? object : null);
                        return;
                    }
                    if (subscriber.isUnsubscribed()) {
                        return;
                    }
                    --l2;
                    ++l3;
                }
                if (l3 == 0L || this.get() == Long.MAX_VALUE) continue;
                this.addAndGet(-l3);
            } while (this.wip.decrementAndGet() != 0);
        }
    }
}

