/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.producers;

import com.zoyi.rx.Observer;
import com.zoyi.rx.Producer;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.internal.operators.BackpressureUtils;
import com.zoyi.rx.internal.producers.ProducerObserverArbiter$1;
import java.util.ArrayList;
import java.util.List;

public final class ProducerObserverArbiter<T>
implements Observer<T>,
Producer {
    final Subscriber<? super T> child;
    boolean emitting;
    List<T> queue;
    Producer currentProducer;
    long requested;
    long missedRequested;
    Producer missedProducer;
    Object missedTerminal;
    volatile boolean hasError;
    static final Producer NULL_PRODUCER = new ProducerObserverArbiter$1();

    public ProducerObserverArbiter(Subscriber<? super T> subscriber) {
        this.child = subscriber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onNext(T t2) {
        ProducerObserverArbiter producerObserverArbiter = this;
        synchronized (producerObserverArbiter) {
            if (this.emitting) {
                List<T> list = this.queue;
                if (list == null) {
                    list = new ArrayList<T>(4);
                    this.queue = list;
                }
                list.add(t2);
                return;
            }
            this.emitting = true;
        }
        try {
            this.child.onNext(t2);
            long l2 = this.requested;
            if (l2 != Long.MAX_VALUE) {
                this.requested = l2 - 1L;
            }
            this.emitLoop();
            return;
        }
        catch (Throwable throwable) {
            producerObserverArbiter = this;
            synchronized (producerObserverArbiter) {
                this.emitting = false;
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onError(Throwable throwable) {
        boolean bl;
        ProducerObserverArbiter producerObserverArbiter = this;
        synchronized (producerObserverArbiter) {
            if (this.emitting) {
                this.missedTerminal = throwable;
                bl = false;
            } else {
                this.emitting = true;
                bl = true;
            }
        }
        if (bl) {
            this.child.onError(throwable);
            return;
        }
        this.hasError = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onCompleted() {
        ProducerObserverArbiter producerObserverArbiter = this;
        synchronized (producerObserverArbiter) {
            if (this.emitting) {
                this.missedTerminal = true;
                return;
            }
            this.emitting = true;
        }
        this.child.onCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void request(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("n >= 0 required");
        }
        if (l2 == 0L) {
            return;
        }
        Producer producer = this;
        synchronized (producer) {
            if (this.emitting) {
                this.missedRequested += l2;
                return;
            }
            this.emitting = true;
        }
        producer = this.currentProducer;
        try {
            long l3 = this.requested;
            long l4 = l3 + l2;
            if (l4 < 0L) {
                l4 = Long.MAX_VALUE;
            }
            this.requested = l4;
            this.emitLoop();
        }
        catch (Throwable throwable) {
            ProducerObserverArbiter producerObserverArbiter = this;
            synchronized (producerObserverArbiter) {
                this.emitting = false;
            }
            throw throwable;
        }
        if (producer != null) {
            producer.request(l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setProducer(Producer producer) {
        ProducerObserverArbiter producerObserverArbiter = this;
        synchronized (producerObserverArbiter) {
            if (this.emitting) {
                this.missedProducer = producer != null ? producer : NULL_PRODUCER;
                return;
            }
            this.emitting = true;
        }
        this.currentProducer = producer;
        long l2 = this.requested;
        try {
            this.emitLoop();
        }
        catch (Throwable throwable) {
            producerObserverArbiter = this;
            synchronized (producerObserverArbiter) {
                this.emitting = false;
            }
            throw throwable;
        }
        if (producer != null && l2 != 0L) {
            producer.request(l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void emitLoop() {
        Subscriber<T> subscriber = this.child;
        long l2 = 0L;
        Producer producer = null;
        block5: while (true) {
            long l3;
            boolean bl;
            List<T> list;
            Object object;
            Producer producer2;
            long l4;
            boolean bl2 = false;
            ProducerObserverArbiter producerObserverArbiter = this;
            synchronized (producerObserverArbiter) {
                l4 = this.missedRequested;
                producer2 = this.missedProducer;
                object = this.missedTerminal;
                list = this.queue;
                if (l4 == 0L && producer2 == null && list == null && object == null) {
                    this.emitting = false;
                    bl2 = true;
                } else {
                    this.missedRequested = 0L;
                    this.missedProducer = null;
                    this.queue = null;
                    this.missedTerminal = null;
                }
            }
            if (bl2) {
                if (l2 != 0L && producer != null) {
                    producer.request(l2);
                }
                return;
            }
            boolean bl3 = bl = list == null || list.isEmpty();
            if (object != null) {
                if (object != Boolean.TRUE) {
                    subscriber.onError((Throwable)object);
                    return;
                }
                if (bl) {
                    subscriber.onCompleted();
                    return;
                }
            }
            long l5 = 0L;
            if (list != null) {
                for (T t2 : list) {
                    if (subscriber.isUnsubscribed()) {
                        return;
                    }
                    if (this.hasError) continue block5;
                    try {
                        subscriber.onNext(t2);
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        Exceptions.throwOrReport(throwable, subscriber, t2);
                        return;
                    }
                }
                l5 = 0L + (long)list.size();
            }
            if ((l3 = this.requested) != Long.MAX_VALUE) {
                if (l4 != 0L) {
                    long l6 = l3 + l4;
                    if (l6 < 0L) {
                        l6 = Long.MAX_VALUE;
                    }
                    l3 = l6;
                }
                if (l5 != 0L && l3 != Long.MAX_VALUE) {
                    long l7 = l3 - l5;
                    if (l7 < 0L) {
                        throw new IllegalStateException("More produced than requested");
                    }
                    l3 = l7;
                }
                this.requested = l3;
            }
            if (producer2 != null) {
                if (producer2 == NULL_PRODUCER) {
                    this.currentProducer = null;
                    continue;
                }
                this.currentProducer = producer2;
                if (l3 == 0L) continue;
                l2 = BackpressureUtils.addCap(l2, l3);
                producer = producer2;
                continue;
            }
            Producer producer3 = this.currentProducer;
            if (producer3 == null || l4 == 0L) continue;
            l2 = BackpressureUtils.addCap(l2, l4);
            producer = producer3;
        }
    }
}

