/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Single;
import com.zoyi.rx.Single$OnSubscribe;
import com.zoyi.rx.SingleSubscriber;
import com.zoyi.rx.exceptions.CompositeException;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.functions.Action1;
import com.zoyi.rx.functions.Func0;
import com.zoyi.rx.functions.Func1;
import com.zoyi.rx.internal.operators.SingleOnSubscribeUsing$1;
import com.zoyi.rx.plugins.RxJavaHooks;
import java.util.Arrays;

public final class SingleOnSubscribeUsing<T, Resource>
implements Single$OnSubscribe<T> {
    final Func0<Resource> resourceFactory;
    final Func1<? super Resource, ? extends Single<? extends T>> singleFactory;
    final Action1<? super Resource> disposeAction;
    final boolean disposeEagerly;

    public SingleOnSubscribeUsing(Func0<Resource> func0, Func1<? super Resource, ? extends Single<? extends T>> func1, Action1<? super Resource> action1, boolean bl) {
        this.resourceFactory = func0;
        this.singleFactory = func1;
        this.disposeAction = action1;
        this.disposeEagerly = bl;
    }

    @Override
    public final void call(SingleSubscriber<? super T> singleSubscriber) {
        Single<T> single;
        Resource Resource;
        try {
            Resource = this.resourceFactory.call();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Exceptions.throwIfFatal(throwable);
            singleSubscriber.onError(throwable2);
            return;
        }
        try {
            single = this.singleFactory.call(Resource);
        }
        catch (Throwable throwable) {
            this.handleSubscriptionTimeError(singleSubscriber, Resource, throwable);
            return;
        }
        if (single == null) {
            this.handleSubscriptionTimeError(singleSubscriber, Resource, new NullPointerException("The single"));
            return;
        }
        SingleOnSubscribeUsing$1 singleOnSubscribeUsing$1 = new SingleOnSubscribeUsing$1(this, Resource, singleSubscriber);
        singleSubscriber.add(singleOnSubscribeUsing$1);
        single.subscribe(singleOnSubscribeUsing$1);
    }

    final void handleSubscriptionTimeError(SingleSubscriber<? super T> singleSubscriber, Resource Resource, Throwable throwable) {
        Throwable throwable2;
        Exceptions.throwIfFatal(throwable);
        if (this.disposeEagerly) {
            try {
                this.disposeAction.call(Resource);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                Exceptions.throwIfFatal(throwable3);
                throwable = new CompositeException(Arrays.asList(throwable, throwable2));
            }
        }
        singleSubscriber.onError(throwable);
        if (!this.disposeEagerly) {
            try {
                this.disposeAction.call(Resource);
                return;
            }
            catch (Throwable throwable4) {
                throwable2 = throwable4;
                Exceptions.throwIfFatal(throwable4);
                RxJavaHooks.onError(throwable2);
            }
        }
    }
}

