/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Scheduler;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.functions.Func1;
import com.zoyi.rx.internal.operators.BackpressureUtils;
import com.zoyi.rx.internal.operators.NotificationLite;
import java.util.ArrayDeque;
import java.util.concurrent.atomic.AtomicLong;

final class OperatorTakeLastTimed$TakeLastTimedSubscriber<T>
extends Subscriber<T>
implements Func1<Object, T> {
    final Subscriber<? super T> actual;
    final long ageMillis;
    final Scheduler scheduler;
    final int count;
    final AtomicLong requested;
    final ArrayDeque<Object> queue;
    final ArrayDeque<Long> queueTimes;
    final NotificationLite<T> nl;

    public OperatorTakeLastTimed$TakeLastTimedSubscriber(Subscriber<? super T> subscriber, int n2, long l2, Scheduler scheduler) {
        this.actual = subscriber;
        this.count = n2;
        this.ageMillis = l2;
        this.scheduler = scheduler;
        this.requested = new AtomicLong();
        this.queue = new ArrayDeque();
        this.queueTimes = new ArrayDeque();
        this.nl = NotificationLite.instance();
    }

    @Override
    public final void onNext(T t2) {
        if (this.count != 0) {
            long l2 = this.scheduler.now();
            if (this.queue.size() == this.count) {
                this.queue.poll();
                this.queueTimes.poll();
            }
            this.evictOld(l2);
            this.queue.offer(this.nl.next(t2));
            this.queueTimes.offer(l2);
        }
    }

    protected final void evictOld(long l2) {
        Long l3;
        long l4 = l2 - this.ageMillis;
        while ((l3 = this.queueTimes.peek()) != null && l3 < l4) {
            this.queue.poll();
            this.queueTimes.poll();
        }
    }

    @Override
    public final void onError(Throwable throwable) {
        this.queue.clear();
        this.queueTimes.clear();
        this.actual.onError(throwable);
    }

    @Override
    public final void onCompleted() {
        this.evictOld(this.scheduler.now());
        this.queueTimes.clear();
        BackpressureUtils.postCompleteDone(this.requested, this.queue, this.actual, this);
    }

    @Override
    public final T call(Object object) {
        return this.nl.getValue(object);
    }

    final void requestMore(long l2) {
        BackpressureUtils.postCompleteRequest(this.requested, l2, this.queue, this.actual, this);
    }
}

