/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Observer;
import com.zoyi.rx.Producer;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.internal.operators.BackpressureUtils;
import com.zoyi.rx.internal.operators.NotificationLite;
import com.zoyi.rx.internal.util.atomic.SpscLinkedAtomicQueue;
import com.zoyi.rx.internal.util.unsafe.SpscLinkedQueue;
import com.zoyi.rx.internal.util.unsafe.UnsafeAccess;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;

final class OperatorScan$InitialProducer<R>
implements Observer<R>,
Producer {
    final Subscriber<? super R> child;
    final Queue<Object> queue;
    boolean emitting;
    boolean missed;
    long missedRequested;
    final AtomicLong requested;
    volatile Producer producer;
    volatile boolean done;
    Throwable error;

    public OperatorScan$InitialProducer(R r2, Subscriber<? super R> abstractQueue) {
        this.child = abstractQueue;
        abstractQueue = UnsafeAccess.isUnsafeAvailable() ? new SpscLinkedQueue() : new SpscLinkedAtomicQueue<Object>();
        this.queue = abstractQueue;
        abstractQueue.offer(NotificationLite.instance().next(r2));
        this.requested = new AtomicLong();
    }

    @Override
    public final void onNext(R r2) {
        this.queue.offer(NotificationLite.instance().next(r2));
        this.emit();
    }

    final boolean checkTerminated(boolean bl, boolean bl2, Subscriber<? super R> subscriber) {
        if (subscriber.isUnsubscribed()) {
            return true;
        }
        if (bl) {
            Throwable throwable = this.error;
            if (throwable != null) {
                subscriber.onError(throwable);
                return true;
            }
            if (bl2) {
                subscriber.onCompleted();
                return true;
            }
        }
        return false;
    }

    @Override
    public final void onError(Throwable throwable) {
        this.error = throwable;
        this.done = true;
        this.emit();
    }

    @Override
    public final void onCompleted() {
        this.done = true;
        this.emit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void request(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("n >= required but it was " + l2);
        }
        if (l2 != 0L) {
            BackpressureUtils.getAndAddRequest(this.requested, l2);
            Producer producer = this.producer;
            if (producer == null) {
                AtomicLong atomicLong = this.requested;
                synchronized (atomicLong) {
                    producer = this.producer;
                    if (producer == null) {
                        long l3 = this.missedRequested;
                        this.missedRequested = BackpressureUtils.addCap(l3, l2);
                    }
                }
            }
            if (producer != null) {
                producer.request(l2);
            }
            this.emit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setProducer(Producer producer) {
        long l2;
        if (producer == null) {
            throw new NullPointerException();
        }
        AtomicLong atomicLong = this.requested;
        synchronized (atomicLong) {
            if (this.producer != null) {
                throw new IllegalStateException("Can't set more than one Producer!");
            }
            l2 = this.missedRequested;
            if (l2 != Long.MAX_VALUE) {
                --l2;
            }
            this.missedRequested = 0L;
            this.producer = producer;
        }
        if (l2 > 0L) {
            producer.request(l2);
        }
        this.emit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void emit() {
        OperatorScan$InitialProducer operatorScan$InitialProducer = this;
        synchronized (operatorScan$InitialProducer) {
            if (this.emitting) {
                this.missed = true;
                return;
            }
            this.emitting = true;
        }
        this.emitLoop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void emitLoop() {
        Subscriber<R> subscriber = this.child;
        Object object = this.queue;
        NotificationLite notificationLite = NotificationLite.instance();
        AtomicLong atomicLong = this.requested;
        long l2 = atomicLong.get();
        boolean bl;
        boolean bl2;
        while (!this.checkTerminated(bl2 = this.done, bl = object.isEmpty(), subscriber)) {
            Object object2;
            long l3;
            for (l3 = 0L; l3 != l2; ++l3) {
                bl2 = this.done;
                object2 = object.poll();
                boolean bl3 = bl = object2 == null;
                if (this.checkTerminated(bl2, bl, subscriber)) {
                    return;
                }
                if (bl) break;
                Object t2 = notificationLite.getValue(object2);
                try {
                    subscriber.onNext(t2);
                    continue;
                }
                catch (Throwable throwable) {
                    object = throwable;
                    Exceptions.throwOrReport(throwable, subscriber, t2);
                    return;
                }
            }
            if (l3 != 0L && l2 != Long.MAX_VALUE) {
                l2 = BackpressureUtils.produced(atomicLong, l3);
            }
            object2 = this;
            synchronized (object2) {
                if (!this.missed) {
                    this.emitting = false;
                    return;
                }
                this.missed = false;
            }
        }
        return;
    }
}

