/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Subscriber;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.exceptions.OnErrorThrowable;
import com.zoyi.rx.internal.operators.NotificationLite;
import com.zoyi.rx.internal.operators.OperatorReplay$InnerProducer;
import com.zoyi.rx.internal.operators.OperatorReplay$Node;
import com.zoyi.rx.internal.operators.OperatorReplay$ReplayBuffer;
import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;

class OperatorReplay$BoundedReplayBuffer<T>
extends AtomicReference<OperatorReplay$Node>
implements OperatorReplay$ReplayBuffer<T> {
    private static final long serialVersionUID = 2346567790059478686L;
    final NotificationLite<T> nl = NotificationLite.instance();
    OperatorReplay$Node tail;
    int size;
    long index;

    public OperatorReplay$BoundedReplayBuffer() {
        OperatorReplay$Node operatorReplay$Node;
        this.tail = operatorReplay$Node = new OperatorReplay$Node(null, 0L);
        this.set(operatorReplay$Node);
    }

    final void addLast(OperatorReplay$Node operatorReplay$Node) {
        this.tail.set(operatorReplay$Node);
        this.tail = operatorReplay$Node;
        ++this.size;
    }

    final void removeFirst() {
        OperatorReplay$Node operatorReplay$Node = (OperatorReplay$Node)this.get();
        if ((operatorReplay$Node = (OperatorReplay$Node)operatorReplay$Node.get()) == null) {
            throw new IllegalStateException("Empty list!");
        }
        --this.size;
        this.setFirst(operatorReplay$Node);
    }

    final void removeSome(int n2) {
        OperatorReplay$Node operatorReplay$Node = (OperatorReplay$Node)this.get();
        while (n2 > 0) {
            operatorReplay$Node = (OperatorReplay$Node)operatorReplay$Node.get();
            --n2;
            --this.size;
        }
        this.setFirst(operatorReplay$Node);
    }

    final void setFirst(OperatorReplay$Node operatorReplay$Node) {
        this.set(operatorReplay$Node);
    }

    OperatorReplay$Node getInitialHead() {
        return (OperatorReplay$Node)this.get();
    }

    @Override
    public final void next(T object) {
        object = this.enterTransform(this.nl.next(object));
        object = new OperatorReplay$Node(object, ++this.index);
        this.addLast((OperatorReplay$Node)object);
        this.truncate();
    }

    @Override
    public final void error(Throwable object) {
        object = this.enterTransform(this.nl.error((Throwable)object));
        object = new OperatorReplay$Node(object, ++this.index);
        this.addLast((OperatorReplay$Node)object);
        this.truncateFinal();
    }

    @Override
    public final void complete() {
        Object object = this.enterTransform(this.nl.completed());
        object = new OperatorReplay$Node(object, ++this.index);
        this.addLast((OperatorReplay$Node)object);
        this.truncateFinal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void replay(OperatorReplay$InnerProducer<T> operatorReplay$InnerProducer) {
        Object object = operatorReplay$InnerProducer;
        synchronized (object) {
            if (operatorReplay$InnerProducer.emitting) {
                operatorReplay$InnerProducer.missed = true;
                return;
            }
            operatorReplay$InnerProducer.emitting = true;
        }
        while (!operatorReplay$InnerProducer.isUnsubscribed()) {
            Serializable serializable;
            long l2;
            object = (OperatorReplay$Node)operatorReplay$InnerProducer.index();
            if (object == null) {
                object = this.getInitialHead();
                operatorReplay$InnerProducer.index = object;
                operatorReplay$InnerProducer.addTotalRequested(((OperatorReplay$Node)object).index);
            }
            if (operatorReplay$InnerProducer.isUnsubscribed()) {
                return;
            }
            Subscriber subscriber = operatorReplay$InnerProducer.child;
            if (subscriber == null) {
                return;
            }
            long l3 = operatorReplay$InnerProducer.get();
            for (l2 = 0L; l2 != l3 && (serializable = (OperatorReplay$Node)((AtomicReference)object).get()) != null; ++l2) {
                object = this.leaveTransform(serializable.value);
                try {
                    if (this.nl.accept(subscriber, object)) {
                        operatorReplay$InnerProducer.index = null;
                        return;
                    }
                }
                catch (Throwable throwable) {
                    operatorReplay$InnerProducer.index = null;
                    Exceptions.throwIfFatal(throwable);
                    operatorReplay$InnerProducer.unsubscribe();
                    if (!this.nl.isError(object) && !this.nl.isCompleted(object)) {
                        subscriber.onError(OnErrorThrowable.addValueAsLastCause(throwable, this.nl.getValue(object)));
                    }
                    return;
                }
                object = serializable;
                if (!operatorReplay$InnerProducer.isUnsubscribed()) continue;
                return;
            }
            if (l2 != 0L) {
                operatorReplay$InnerProducer.index = object;
                if (l3 != Long.MAX_VALUE) {
                    operatorReplay$InnerProducer.produced(l2);
                }
            }
            serializable = operatorReplay$InnerProducer;
            synchronized (serializable) {
                if (!operatorReplay$InnerProducer.missed) {
                    operatorReplay$InnerProducer.emitting = false;
                    return;
                }
                operatorReplay$InnerProducer.missed = false;
            }
        }
        return;
    }

    Object enterTransform(Object object) {
        return object;
    }

    Object leaveTransform(Object object) {
        return object;
    }

    void truncate() {
    }

    void truncateFinal() {
    }

    final void collect(Collection<? super T> collection) {
        OperatorReplay$Node operatorReplay$Node = this.getInitialHead();
        while ((operatorReplay$Node = (OperatorReplay$Node)operatorReplay$Node.get()) != null) {
            Object object = operatorReplay$Node.value;
            if (this.nl.isCompleted(object = this.leaveTransform(object)) || this.nl.isError(object)) break;
            collection.add(this.nl.getValue(object));
        }
    }

    boolean hasError() {
        return this.tail.value != null && this.nl.isError(this.leaveTransform(this.tail.value));
    }

    boolean hasCompleted() {
        return this.tail.value != null && this.nl.isCompleted(this.leaveTransform(this.tail.value));
    }
}

